/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.security;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.reactive.Single;
import io.helidon.security.EndpointConfig;
import io.helidon.security.OutboundSecurityClientBuilder;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.Security;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityEnvironment;
import io.helidon.webclient.WebClientRequestHeaders;
import io.helidon.webclient.WebClientServiceRequest;
import io.helidon.webclient.spi.WebClientService;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class WebClientSecurity
implements WebClientService {
    private static final Logger LOGGER = Logger.getLogger(WebClientSecurity.class.getName());
    private static final String PROVIDER_NAME = "io.helidon.security.rest.client.security.providerName";
    private final Security security;

    private WebClientSecurity() {
        this(null);
    }

    private WebClientSecurity(Security security) {
        this.security = security;
    }

    public static WebClientSecurity create() {
        Context context = Contexts.context().orElseGet(Contexts::globalContext);
        return context.get(Security.class).map(WebClientSecurity::new).orElseGet(WebClientSecurity::new);
    }

    public static WebClientSecurity create(Security security) {
        return new WebClientSecurity(security);
    }

    public Single<WebClientServiceRequest> request(WebClientServiceRequest request) {
        OutboundSecurityClientBuilder clientBuilder;
        SecurityContext context;
        if ("true".equalsIgnoreCase((String)request.properties().get("io.helidon.security.client.disable"))) {
            return Single.just((Object)request);
        }
        Context requestContext = request.context();
        Optional maybeContext = requestContext.get(SecurityContext.class);
        if (null == this.security) {
            if (maybeContext.isEmpty()) {
                return Single.just((Object)request);
            }
            context = (SecurityContext)maybeContext.get();
        } else {
            context = this.createContext(request);
        }
        Span span = context.tracer().buildSpan("security:outbound").asChildOf(context.tracingSpan()).start();
        String explicitProvider = (String)request.properties().get(PROVIDER_NAME);
        try {
            SecurityEnvironment.Builder outboundEnv = context.env().derive().clearHeaders().clearQueryParams();
            outboundEnv.method(request.method().name()).path(request.path().toString()).targetUri(request.uri()).headers(request.headers().toMap()).queryParams(request.queryParams());
            EndpointConfig.Builder outboundEp = context.endpointConfig().derive();
            Map propMap = request.properties();
            for (String name : propMap.keySet()) {
                Optional.ofNullable((String)request.properties().get(name)).ifPresent(property -> outboundEp.addAtribute(name, property));
            }
            clientBuilder = (OutboundSecurityClientBuilder)context.outboundClientBuilder().outboundEnvironment((Supplier)outboundEnv).outboundEndpointConfig((Supplier)outboundEp).explicitProvider(explicitProvider);
        }
        catch (Exception e) {
            WebClientSecurity.traceError(span, e, null);
            throw e;
        }
        return Single.create(clientBuilder.submit().thenApply(providerResponse -> this.processResponse(request, span, (OutboundSecurityResponse)providerResponse)));
    }

    private WebClientServiceRequest processResponse(WebClientServiceRequest request, Span span, OutboundSecurityResponse providerResponse) {
        try {
            switch (providerResponse.status()) {
                case FAILURE: 
                case FAILURE_FINISH: {
                    WebClientSecurity.traceError(span, providerResponse.throwable().orElse(null), providerResponse.description().orElse(providerResponse.status().toString()));
                    break;
                }
            }
            Map newHeaders = providerResponse.requestHeaders();
            LOGGER.finest(() -> "Client filter header(s). SIZE: " + newHeaders.size());
            WebClientRequestHeaders clientHeaders = request.headers();
            for (Map.Entry entry : newHeaders.entrySet()) {
                LOGGER.finest(() -> "    + Header: " + (String)entry.getKey() + ": " + String.valueOf(entry.getValue()));
                clientHeaders.remove((String)entry.getKey());
                for (String value : (List)entry.getValue()) {
                    clientHeaders.put((String)entry.getKey(), new String[]{value});
                }
            }
            span.finish();
            return request;
        }
        catch (Exception e) {
            WebClientSecurity.traceError(span, e, null);
            throw e;
        }
    }

    private SecurityContext createContext(WebClientServiceRequest request) {
        SecurityContext.Builder builder = this.security.contextBuilder(UUID.randomUUID().toString()).endpointConfig(EndpointConfig.builder().build()).env(SecurityEnvironment.builder().path(request.path().toString()).build());
        request.context().get(Tracer.class).ifPresent(arg_0 -> ((SecurityContext.Builder)builder).tracingTracer(arg_0));
        request.context().get(SpanContext.class).ifPresent(arg_0 -> ((SecurityContext.Builder)builder).tracingSpan(arg_0));
        return builder.build();
    }

    static void traceError(Span span, Throwable throwable, String description) {
        if (null != throwable) {
            Tags.ERROR.set(span, Boolean.valueOf(true));
            span.log(Map.of("event", "error", "error.object", throwable));
        } else {
            Tags.ERROR.set(span, Boolean.valueOf(true));
            span.log(Map.of("event", "error", "message", description, "error.kind", "SecurityException"));
        }
        span.finish();
    }
}

