/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.metrics;

import io.helidon.common.config.Config;
import io.helidon.webclient.api.WebClientServiceRequest;
import io.helidon.webclient.api.WebClientServiceResponse;
import io.helidon.webclient.metrics.WebClientMetric;
import io.helidon.webclient.metrics.WebClientMetricType;
import io.helidon.webclient.spi.WebClientService;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class WebClientMetrics
implements WebClientService {
    private final List<WebClientMetric> metrics;

    private WebClientMetrics(Builder builder) {
        this.metrics = builder.metrics;
    }

    public static WebClientMetric.Builder timer() {
        return WebClientMetric.builder(WebClientMetricType.TIMER);
    }

    public static WebClientMetric.Builder counter() {
        return WebClientMetric.builder(WebClientMetricType.COUNTER);
    }

    public static WebClientMetric.Builder meter() {
        return WebClientMetric.builder(WebClientMetricType.METER);
    }

    public static WebClientMetric.Builder gaugeInProgress() {
        return WebClientMetric.builder(WebClientMetricType.GAUGE_IN_PROGRESS);
    }

    public static WebClientMetrics create(Config config) {
        Builder builder = new Builder();
        config.asNodeList().ifPresent(configs -> configs.forEach(metricConfig -> builder.register(WebClientMetrics.processClientMetric(metricConfig))));
        return builder.build();
    }

    private static WebClientMetric processClientMetric(Config metricConfig) {
        String type;
        return switch (type = (String)metricConfig.get("type").asString().orElse((Object)"COUNTER")) {
            case "COUNTER" -> WebClientMetrics.counter().config(metricConfig).build();
            case "METER" -> WebClientMetrics.meter().config(metricConfig).build();
            case "TIMER" -> WebClientMetrics.timer().config(metricConfig).build();
            case "GAUGE_IN_PROGRESS" -> WebClientMetrics.gaugeInProgress().config(metricConfig).build();
            default -> throw new IllegalStateException(String.format("Metrics type %s is not supported through service loader", type));
        };
    }

    public WebClientServiceResponse handle(WebClientService.Chain chain, WebClientServiceRequest request) {
        WebClientService.Chain last = chain;
        ListIterator<WebClientMetric> serviceIterator = this.metrics.listIterator(this.metrics.size());
        while (serviceIterator.hasPrevious()) {
            WebClientService.Chain next = last;
            WebClientMetric service = serviceIterator.previous();
            last = clientRequest -> service.handle(next, clientRequest);
        }
        return last.proceed(request);
    }

    private static final class Builder
    implements io.helidon.common.Builder<Builder, WebClientMetrics> {
        private final List<WebClientMetric> metrics = new ArrayList<WebClientMetric>();

        private Builder() {
        }

        private void register(WebClientMetric clientMetric) {
            this.metrics.add(clientMetric);
        }

        public WebClientMetrics build() {
            return new WebClientMetrics(this);
        }
    }
}

