/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.metrics;

import io.helidon.http.Http;
import io.helidon.metrics.api.Counter;
import io.helidon.metrics.api.Meter;
import io.helidon.webclient.api.WebClientServiceRequest;
import io.helidon.webclient.api.WebClientServiceResponse;
import io.helidon.webclient.metrics.WebClientMetric;
import io.helidon.webclient.spi.WebClientService;

class WebClientCounter
extends WebClientMetric {
    WebClientCounter(WebClientMetric.Builder builder) {
        super(builder);
    }

    public WebClientServiceResponse handle(WebClientService.Chain chain, WebClientServiceRequest request) {
        Http.Method method = request.method();
        try {
            WebClientServiceResponse response = chain.proceed(request);
            int code = response.status().code();
            if (this.shouldContinueOnSuccess(method, code) || this.shouldContinueOnError(method, code)) {
                this.updateCounter(this.createMetadata(request, response));
            }
            return response;
        }
        catch (Throwable ex) {
            if (this.shouldContinueOnError(method)) {
                this.updateCounter(this.createMetadata(request, null));
            }
            throw ex;
        }
    }

    private void updateCounter(WebClientMetric.Metadata metadata) {
        Counter counter = (Counter)this.meterRegistry().getOrCreate((Meter.Builder)((Counter.Builder)Counter.builder((String)metadata.name()).description(metadata.description())));
        counter.increment();
    }
}

