/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.metrics;

import io.helidon.common.http.Http;
import io.helidon.common.reactive.Single;
import io.helidon.webclient.WebClientServiceRequest;
import io.helidon.webclient.WebClientServiceResponse;
import io.helidon.webclient.metrics.WebClientMetric;
import java.time.Duration;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Timer;

class WebClientTimer
extends WebClientMetric {
    WebClientTimer(WebClientMetric.Builder builder) {
        super(builder);
    }

    @Override
    MetricType metricType() {
        return MetricType.TIMER;
    }

    public Single<WebClientServiceRequest> request(WebClientServiceRequest request) {
        long start = System.nanoTime();
        Http.RequestMethod method = request.method();
        request.whenResponseReceived().thenAccept(response -> {
            if (this.shouldContinueOnError(method, response.status().code())) {
                this.updateTimer(this.createMetadata(request, (WebClientServiceResponse)response), start);
            }
        });
        request.whenComplete().thenAccept(response -> {
            if (this.shouldContinueOnSuccess(method, response.status().code())) {
                this.updateTimer(this.createMetadata(request, (WebClientServiceResponse)response), start);
            }
        }).exceptionally(throwable -> {
            if (this.shouldContinueOnError(method)) {
                this.updateTimer(this.createMetadata(request, null), start);
            }
            return null;
        });
        return Single.just((Object)request);
    }

    private void updateTimer(Metadata metadata, long start) {
        long time = System.nanoTime() - start;
        Timer timer = this.metricRegistry().timer(metadata);
        timer.update(Duration.ofNanos(time));
    }
}

