/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataReader;
import io.helidon.common.buffers.DataWriter;
import io.helidon.common.socket.SocketContext;
import io.helidon.http.http2.ConnectionFlowControl;
import io.helidon.http.http2.FlowControl;
import io.helidon.http.http2.Http2ConnectionWriter;
import io.helidon.http.http2.Http2ErrorCode;
import io.helidon.http.http2.Http2Exception;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2FrameData;
import io.helidon.http.http2.Http2FrameHeader;
import io.helidon.http.http2.Http2FrameListener;
import io.helidon.http.http2.Http2FrameTypes;
import io.helidon.http.http2.Http2GoAway;
import io.helidon.http.http2.Http2Headers;
import io.helidon.http.http2.Http2LoggingFrameListener;
import io.helidon.http.http2.Http2Ping;
import io.helidon.http.http2.Http2RstStream;
import io.helidon.http.http2.Http2Setting;
import io.helidon.http.http2.Http2Settings;
import io.helidon.http.http2.Http2StreamState;
import io.helidon.http.http2.Http2Util;
import io.helidon.http.http2.Http2WindowUpdate;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webclient.http2.Http2ClientConfig;
import io.helidon.webclient.http2.Http2ClientImpl;
import io.helidon.webclient.http2.Http2ClientProtocolConfig;
import io.helidon.webclient.http2.Http2ClientStream;
import io.helidon.webclient.http2.Http2StreamConfig;
import io.helidon.webclient.http2.LockingStreamIdSequence;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Http2ClientConnection {
    private static final System.Logger LOGGER = System.getLogger(Http2ClientConnection.class.getName());
    private static final int FRAME_HEADER_LENGTH = 9;
    private final Http2FrameListener sendListener = new Http2LoggingFrameListener("cl-send");
    private final Http2FrameListener recvListener = new Http2LoggingFrameListener("cl-recv");
    private final LockingStreamIdSequence streamIdSeq = new LockingStreamIdSequence();
    private final ReadWriteLock streamsLock = new ReentrantReadWriteLock();
    private final Map<Integer, Http2ClientStream> streams = new HashMap<Integer, Http2ClientStream>();
    private final ConnectionFlowControl connectionFlowControl;
    private final Http2Headers.DynamicTable inboundDynamicTable = Http2Headers.DynamicTable.create((long)((Long)Http2Setting.HEADER_TABLE_SIZE.defaultValue()));
    private final Http2ClientProtocolConfig protocolConfig;
    private final ClientConnection connection;
    private final SocketContext ctx;
    private final Http2ConnectionWriter writer;
    private final DataReader reader;
    private final DataWriter dataWriter;
    private final Semaphore pingPongSemaphore = new Semaphore(0);
    private final Http2ClientConfig clientConfig;
    private volatile int lastStreamId;
    private Http2Settings serverSettings = Http2Settings.builder().build();
    private Future<?> handleTask;
    private final AtomicReference<State> state = new AtomicReference<State>(State.OPEN);

    Http2ClientConnection(Http2ClientImpl http2Client, ClientConnection connection) {
        this.protocolConfig = http2Client.protocolConfig();
        this.clientConfig = http2Client.clientConfig();
        this.connectionFlowControl = ConnectionFlowControl.clientBuilder(this::writeWindowsUpdate).maxFrameSize(this.protocolConfig.maxFrameSize()).initialWindowSize(this.protocolConfig.initialWindowSize()).blockTimeout(this.protocolConfig.flowControlBlockTimeout()).build();
        this.connection = connection;
        this.ctx = connection.helidonSocket();
        this.dataWriter = connection.writer();
        this.reader = connection.reader();
        this.writer = new Http2ConnectionWriter((SocketContext)connection.helidonSocket(), connection.writer(), List.of());
    }

    public static Http2ClientConnection create(Http2ClientImpl http2Client, ClientConnection connection, boolean sendSettings) {
        Http2ClientConnection h2conn = new Http2ClientConnection(http2Client, connection);
        h2conn.start(http2Client.protocolConfig(), http2Client.webClient().executor(), sendSettings);
        return h2conn;
    }

    Http2ConnectionWriter writer() {
        return this.writer;
    }

    Http2Headers.DynamicTable getInboundDynamicTable() {
        return this.inboundDynamicTable;
    }

    ConnectionFlowControl flowControl() {
        return this.connectionFlowControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Http2ClientStream stream(int streamId) {
        Lock lock = this.streamsLock.readLock();
        lock.lock();
        try {
            Http2ClientStream http2ClientStream = this.streams.get(streamId);
            return http2ClientStream;
        }
        finally {
            lock.unlock();
        }
    }

    public LockingStreamIdSequence streamIdSequence() {
        return this.streamIdSeq;
    }

    Http2ClientStream createStream(Http2StreamConfig config) {
        Http2ClientStream stream = new Http2ClientStream(this, this.serverSettings, this.ctx, config, this.clientConfig, this.streamIdSeq);
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStream(int streamId, Http2ClientStream stream) {
        Lock lock = this.streamsLock.writeLock();
        lock.lock();
        try {
            this.streams.put(streamId, stream);
        }
        finally {
            lock.unlock();
        }
    }

    public void removeStream(int streamId) {
        Lock lock = this.streamsLock.writeLock();
        lock.lock();
        try {
            this.streams.remove(streamId);
        }
        finally {
            lock.unlock();
        }
    }

    Http2ClientStream tryStream(Http2StreamConfig config) {
        try {
            return this.createStream(config);
        }
        catch (UncheckedIOException | IllegalStateException e) {
            return null;
        }
    }

    boolean closed() {
        return this.state.get().closed() || this.protocolConfig.ping() && !this.ping();
    }

    boolean ping() {
        Http2Ping ping = Http2Ping.create();
        Http2FrameData frameData = ping.toFrameData();
        this.sendListener.frameHeader(this.ctx, 0, frameData.header());
        this.sendListener.frame(this.ctx, 0, ping);
        try {
            this.writer().writeData(frameData, FlowControl.Outbound.NOOP);
            return this.pingPongSemaphore.tryAcquire(this.protocolConfig.pingTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (UncheckedIOException | InterruptedException e) {
            this.ctx.log(LOGGER, System.Logger.Level.DEBUG, "Ping failed!", (Throwable)e, new Object[0]);
            return false;
        }
    }

    void pong() {
        this.pingPongSemaphore.release();
    }

    void updateLastStreamId(int lastStreamId) {
        this.lastStreamId = lastStreamId;
    }

    public void close() {
        this.goAway(0, Http2ErrorCode.NO_ERROR, "Closing connection");
        if (this.state.getAndSet(State.CLOSED) != State.CLOSED) {
            try {
                this.handleTask.cancel(true);
                this.ctx.log(LOGGER, System.Logger.Level.TRACE, "Closing connection", new Object[0]);
                this.connection.closeResource();
            }
            catch (Throwable e) {
                this.ctx.log(LOGGER, System.Logger.Level.TRACE, "Failed to close HTTP/2 connection.", e, new Object[0]);
            }
        }
    }

    static Http2Settings settings(Http2ClientProtocolConfig config) {
        Http2Settings.Builder b = Http2Settings.builder();
        if (config.maxHeaderListSize() > 0L) {
            b.add(Http2Setting.MAX_HEADER_LIST_SIZE, (Object)config.maxHeaderListSize());
        }
        return b.add(Http2Setting.INITIAL_WINDOW_SIZE, (Object)config.initialWindowSize()).add(Http2Setting.MAX_FRAME_SIZE, (Object)config.maxFrameSize()).add(Http2Setting.ENABLE_PUSH, (Object)false).build();
    }

    private void sendPreface(Http2ClientProtocolConfig config, boolean sendSettings) {
        int connectionWinSizeUpd;
        Http2FrameData frameData;
        BufferData prefaceData = Http2Util.prefaceData();
        this.sendListener.frame(this.ctx, 0, prefaceData);
        this.dataWriter.writeNow(prefaceData);
        if (sendSettings) {
            Http2Settings http2Settings = Http2ClientConnection.settings(config);
            Http2Flag.SettingsFlags flags = Http2Flag.SettingsFlags.create((int)0);
            frameData = http2Settings.toFrameData(null, 0, flags);
            this.sendListener.frameHeader(this.ctx, 0, frameData.header());
            this.sendListener.frame(this.ctx, 0, http2Settings);
            this.writer.write(frameData);
        }
        if ((connectionWinSizeUpd = config.initialWindowSize() - 65535) > 0) {
            Http2WindowUpdate windowUpdate = new Http2WindowUpdate(connectionWinSizeUpd);
            frameData = windowUpdate.toFrameData(null, 0, Http2Flag.NoFlags.create());
            this.sendListener.frameHeader(this.ctx, 0, frameData.header());
            this.sendListener.frame(this.ctx, 0, windowUpdate);
            this.writer.write(frameData);
        }
    }

    private void start(Http2ClientProtocolConfig protocolConfig, ExecutorService executor, boolean sendSettings) {
        CountDownLatch cdl = new CountDownLatch(1);
        this.handleTask = executor.submit(() -> {
            this.ctx.log(LOGGER, System.Logger.Level.TRACE, "Starting HTTP/2 connection, thread: %s", new Object[]{Thread.currentThread().getName()});
            try {
                this.sendPreface(protocolConfig, sendSettings);
            }
            catch (Throwable e) {
                this.ctx.log(LOGGER, System.Logger.Level.WARNING, "Failed to send preface.", e, new Object[0]);
            }
            finally {
                cdl.countDown();
            }
            try {
                while (!Thread.interrupted()) {
                    if (this.handle()) continue;
                    this.close();
                    this.ctx.log(LOGGER, System.Logger.Level.TRACE, "Connection closed", new Object[0]);
                    return;
                }
                this.ctx.log(LOGGER, System.Logger.Level.TRACE, "Client listener interrupted", new Object[0]);
            }
            catch (Throwable t) {
                this.close();
                this.ctx.log(LOGGER, System.Logger.Level.DEBUG, "Failed to handle HTTP/2 client connection", t, new Object[0]);
            }
        });
        try {
            if (!cdl.await(20L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Filed to send HTTP/2 preface within 20 seconds, this connection is broken");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted while waiting for preface to be sent", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeWindowsUpdate(int streamId, Http2WindowUpdate windowUpdateFrame) {
        Http2ClientStream stream;
        if (streamId == 0) {
            this.writer.write(windowUpdateFrame.toFrameData(this.serverSettings, streamId, Http2Flag.NoFlags.create()));
            return;
        }
        if (streamId < this.lastStreamId) {
            Lock lock = this.streamsLock.readLock();
            lock.lock();
            try {
                for (Http2ClientStream s : this.streams.values()) {
                    if (s.streamId() <= streamId || s.streamState() == Http2StreamState.IDLE) continue;
                    return;
                }
            }
            finally {
                lock.unlock();
            }
        }
        if ((stream = this.stream(streamId)) != null && !stream.streamState().equals((Object)Http2StreamState.CLOSED)) {
            this.writer.write(windowUpdateFrame.toFrameData(this.serverSettings, streamId, Http2Flag.NoFlags.create()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handle() {
        this.reader.ensureAvailable();
        BufferData frameHeaderBuffer = this.reader.readBuffer(9);
        Http2FrameHeader frameHeader = Http2FrameHeader.create((BufferData)frameHeaderBuffer);
        frameHeader.type().checkLength(frameHeader.length());
        BufferData data = frameHeader.length() != 0 ? this.reader.readBuffer(frameHeader.length()) : BufferData.empty();
        int streamId = frameHeader.streamId();
        switch (frameHeader.type()) {
            case GO_AWAY: {
                Http2GoAway http2GoAway = Http2GoAway.create((BufferData)data);
                this.recvListener.frameHeader(this.ctx, streamId, frameHeader);
                this.recvListener.frame(this.ctx, streamId, http2GoAway);
                this.close();
                this.ctx.log(LOGGER, System.Logger.Level.TRACE, "Connection closed by remote peer, error code: %s, last stream: %d", new Object[]{http2GoAway.errorCode(), http2GoAway.lastStreamId()});
                return false;
            }
            case SETTINGS: {
                this.serverSettings = Http2Settings.create((BufferData)data);
                this.recvListener.frameHeader(this.ctx, streamId, frameHeader);
                this.recvListener.frame(this.ctx, streamId, this.serverSettings);
                this.inboundDynamicTable.protocolMaxTableSize(((Long)this.serverSettings.value(Http2Setting.HEADER_TABLE_SIZE)).longValue());
                if (this.serverSettings.hasValue(Http2Setting.MAX_FRAME_SIZE)) {
                    this.connectionFlowControl.resetMaxFrameSize(((Long)this.serverSettings.value(Http2Setting.MAX_FRAME_SIZE)).intValue());
                }
                if (this.serverSettings.hasValue(Http2Setting.INITIAL_WINDOW_SIZE)) {
                    Long initWinSizeLong = (Long)this.serverSettings.value(Http2Setting.INITIAL_WINDOW_SIZE);
                    if (initWinSizeLong > Integer.MAX_VALUE) {
                        this.goAway(streamId, Http2ErrorCode.FLOW_CONTROL, "Window size too big. Max: ");
                        throw new Http2Exception(Http2ErrorCode.PROTOCOL, "Received too big INITIAL_WINDOW_SIZE " + initWinSizeLong);
                    }
                    int initWinSize = initWinSizeLong.intValue();
                    this.connectionFlowControl.resetInitialWindowSize(initWinSize);
                    Lock lock = this.streamsLock.readLock();
                    lock.lock();
                    try {
                        this.streams.values().forEach(stream -> stream.flowControl().outbound().resetStreamWindowSize(initWinSize));
                    }
                    finally {
                        lock.unlock();
                    }
                }
                this.ackSettings();
                return true;
            }
            case WINDOW_UPDATE: {
                Http2WindowUpdate windowUpdate = Http2WindowUpdate.create((BufferData)data);
                this.recvListener.frameHeader(this.ctx, streamId, frameHeader);
                this.recvListener.frame(this.ctx, streamId, windowUpdate);
                if (streamId == 0) {
                    boolean overflow;
                    Http2GoAway frame;
                    int increment = windowUpdate.windowSizeIncrement();
                    if (increment == 0) {
                        frame = new Http2GoAway(0, Http2ErrorCode.PROTOCOL, "Window size 0");
                        this.writer.write(frame.toFrameData(this.serverSettings, 0, Http2Flag.NoFlags.create()));
                    }
                    boolean bl = overflow = this.connectionFlowControl.incrementOutboundConnectionWindowSize(increment) > Integer.MAX_VALUE;
                    if (overflow) {
                        frame = new Http2GoAway(0, Http2ErrorCode.FLOW_CONTROL, "Window size too big. Max: ");
                        this.writer.write(frame.toFrameData(this.serverSettings, 0, Http2Flag.NoFlags.create()));
                    }
                } else {
                    this.stream(streamId).windowUpdate(windowUpdate);
                }
                return true;
            }
            case PING: {
                if (streamId != 0) {
                    throw new Http2Exception(Http2ErrorCode.PROTOCOL, "Received ping for a stream " + streamId);
                }
                if (frameHeader.length() != 8) {
                    throw new Http2Exception(Http2ErrorCode.FRAME_SIZE, "Received ping with wrong size. Should be 8 bytes, is " + frameHeader.length());
                }
                if (!((Http2Flag.PingFlags)frameHeader.flags(Http2FrameTypes.PING)).ack()) {
                    Http2Ping ping = Http2Ping.create((BufferData)data);
                    this.recvListener.frame(this.ctx, streamId, ping);
                    BufferData frame = ping.data();
                    Http2FrameHeader header = Http2FrameHeader.create((int)frame.available(), (Http2FrameTypes)Http2FrameTypes.PING, (Http2Flag)Http2Flag.PingFlags.create((int)1), (int)0);
                    this.writer.write(new Http2FrameData(header, frame));
                    break;
                }
                this.pong();
                break;
            }
            case RST_STREAM: {
                Http2RstStream rstStream = Http2RstStream.create((BufferData)data);
                this.recvListener.frame(this.ctx, streamId, rstStream);
                this.stream(streamId).rstStream(rstStream);
                break;
            }
            case DATA: {
                Http2ClientStream stream2 = this.stream(streamId);
                if (stream2 == null) {
                    this.ctx.log(LOGGER, System.Logger.Level.DEBUG, "%d: received data for stream %d, which does not exist", new Object[]{0, streamId});
                    break;
                }
                stream2.flowControl().inbound().decrementWindowSize(frameHeader.length());
                this.ctx.log(LOGGER, System.Logger.Level.DEBUG, "%d: received data for stream %d", new Object[]{0, streamId});
                stream2.push(new Http2FrameData(frameHeader, data));
                break;
            }
            case HEADERS: 
            case CONTINUATION: {
                this.stream(streamId).push(new Http2FrameData(frameHeader, data));
                return true;
            }
            default: {
                LOGGER.log(System.Logger.Level.WARNING, "Unsupported frame type!! " + String.valueOf(frameHeader.type()));
            }
        }
        return true;
    }

    private void ackSettings() {
        Http2Flag.SettingsFlags flags = Http2Flag.SettingsFlags.create((int)1);
        Http2Settings http2Settings = Http2Settings.create();
        Http2FrameData frameData = http2Settings.toFrameData(null, 0, flags);
        this.sendListener.frameHeader(this.ctx, 0, frameData.header());
        this.sendListener.frame(this.ctx, 0, http2Settings);
        this.writer.write(frameData);
    }

    private void goAway(int streamId, Http2ErrorCode errorCode, String msg) {
        if (State.OPEN == this.state.getAndSet(State.GO_AWAY)) {
            Http2Settings http2Settings = Http2Settings.create();
            Http2GoAway frame = new Http2GoAway(streamId, errorCode, msg);
            this.writer.write(frame.toFrameData(http2Settings, 0, Http2Flag.NoFlags.create()));
        }
    }

    private static enum State {
        CLOSED(true),
        GO_AWAY(true),
        OPEN(false);

        private final boolean closed;

        private State(boolean closed) {
            this.closed = closed;
        }

        boolean closed() {
            return this.closed;
        }
    }
}

