/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http1;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.HeaderNames;
import io.helidon.http.Method;
import io.helidon.http.Status;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.http1.Http1ClientRequestImpl;
import io.helidon.webclient.http1.Http1ClientResponseImpl;
import java.net.URI;
import java.util.Map;

class RedirectionProcessor {
    private RedirectionProcessor() {
    }

    static boolean redirectionStatusCode(Status status) {
        return status.family() == Status.Family.REDIRECTION;
    }

    static Http1ClientResponseImpl invokeWithFollowRedirects(Http1ClientRequestImpl request, byte[] entity) {
        return RedirectionProcessor.invokeWithFollowRedirects(request, 0, entity);
    }

    static Http1ClientResponseImpl invokeWithFollowRedirects(Http1ClientRequestImpl request, int initial, byte[] entity) {
        Http1ClientRequestImpl clientRequest = request;
        byte[] entityToBeSent = entity;
        for (int i = initial; i < request.maxRedirects(); ++i) {
            Http1ClientResponseImpl clientResponse = clientRequest.invokeRequestWithEntity(entityToBeSent);
            if (!RedirectionProcessor.redirectionStatusCode(clientResponse.status())) {
                return clientResponse;
            }
            try (Http1ClientResponseImpl http1ClientResponseImpl = clientResponse;){
                if (!clientResponse.headers().contains(HeaderNames.LOCATION)) {
                    throw new IllegalStateException("There is no " + String.valueOf(HeaderNames.LOCATION) + " header present in the response! It is not clear where to redirect.");
                }
                String redirectedUri = clientResponse.headers().get(HeaderNames.LOCATION).value();
                URI newUri = URI.create(redirectedUri);
                ClientUri redirectUri = ClientUri.create((URI)newUri);
                if (newUri.getHost() == null) {
                    ClientUri resolvedUri = clientRequest.resolvedUri();
                    redirectUri.scheme(resolvedUri.scheme());
                    redirectUri.host(resolvedUri.host());
                    redirectUri.port(resolvedUri.port());
                }
                if (clientResponse.status() == Status.TEMPORARY_REDIRECT_307 || clientResponse.status() == Status.PERMANENT_REDIRECT_308) {
                    clientRequest = new Http1ClientRequestImpl(clientRequest, clientRequest.method(), redirectUri, (Map<String, String>)request.properties());
                    continue;
                }
                entityToBeSent = BufferData.EMPTY_BYTES;
                clientRequest = new Http1ClientRequestImpl(clientRequest, Method.GET, redirectUri, (Map<String, String>)request.properties());
                continue;
            }
        }
        throw new IllegalStateException("Maximum number of request redirections (" + request.maxRedirects() + ") reached.");
    }
}

