/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http1;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.webclient.http1.Http1ClientProtocolConfigBlueprint;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.webclient.http1.Http1ClientProtocolConfigBlueprint")
public interface Http1ClientProtocolConfig
extends Http1ClientProtocolConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Http1ClientProtocolConfig instance) {
        return (Builder)Http1ClientProtocolConfig.builder().from(instance);
    }

    public static Http1ClientProtocolConfig create(Config config) {
        return ((Builder)Http1ClientProtocolConfig.builder().config(config)).buildPrototype();
    }

    public static Http1ClientProtocolConfig create() {
        return Http1ClientProtocolConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, Http1ClientProtocolConfig>
    implements io.helidon.common.Builder<Builder, Http1ClientProtocolConfig> {
        private Builder() {
        }

        public Http1ClientProtocolConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.Http1ClientProtocolConfigImpl(this);
        }

        public Http1ClientProtocolConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends Http1ClientProtocolConfig>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean defaultKeepAlive = true;
        private boolean validateRequestHeaders = false;
        private boolean validateResponseHeaders = true;
        private Config config;
        private int maxHeaderSize = 16384;
        private int maxStatusLineLength = 256;
        private String name = "http_1_1";

        protected BuilderBase() {
        }

        public BUILDER from(Http1ClientProtocolConfig prototype) {
            this.name(prototype.name());
            this.defaultKeepAlive(prototype.defaultKeepAlive());
            this.maxHeaderSize(prototype.maxHeaderSize());
            this.maxStatusLineLength(prototype.maxStatusLineLength());
            this.validateRequestHeaders(prototype.validateRequestHeaders());
            this.validateResponseHeaders(prototype.validateResponseHeaders());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.name(builder.name());
            this.defaultKeepAlive(builder.defaultKeepAlive());
            this.maxHeaderSize(builder.maxHeaderSize());
            this.maxStatusLineLength(builder.maxStatusLineLength());
            this.validateRequestHeaders(builder.validateRequestHeaders());
            this.validateResponseHeaders(builder.validateResponseHeaders());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("name").as(String.class).ifPresent(this::name);
            config.get("default-keep-alive").as(Boolean.class).ifPresent(this::defaultKeepAlive);
            config.get("max-header-size").as(Integer.class).ifPresent(this::maxHeaderSize);
            config.get("max-status-line-length").as(Integer.class).ifPresent(this::maxStatusLineLength);
            config.get("validate-request-headers").as(Boolean.class).ifPresent(this::validateRequestHeaders);
            config.get("validate-response-headers").as(Boolean.class).ifPresent(this::validateResponseHeaders);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER defaultKeepAlive(boolean defaultKeepAlive) {
            this.defaultKeepAlive = defaultKeepAlive;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxHeaderSize(int maxHeaderSize) {
            this.maxHeaderSize = maxHeaderSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxStatusLineLength(int maxStatusLineLength) {
            this.maxStatusLineLength = maxStatusLineLength;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER validateRequestHeaders(boolean validateRequestHeaders) {
            this.validateRequestHeaders = validateRequestHeaders;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER validateResponseHeaders(boolean validateResponseHeaders) {
            this.validateResponseHeaders = validateResponseHeaders;
            return (BUILDER)((BuilderBase)this.self());
        }

        public String name() {
            return this.name;
        }

        public boolean defaultKeepAlive() {
            return this.defaultKeepAlive;
        }

        public int maxHeaderSize() {
            return this.maxHeaderSize;
        }

        public int maxStatusLineLength() {
            return this.maxStatusLineLength;
        }

        public boolean validateRequestHeaders() {
            return this.validateRequestHeaders;
        }

        public boolean validateResponseHeaders() {
            return this.validateResponseHeaders;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "Http1ClientProtocolConfigBuilder{name=" + this.name + ",defaultKeepAlive=" + this.defaultKeepAlive + ",maxHeaderSize=" + this.maxHeaderSize + ",maxStatusLineLength=" + this.maxStatusLineLength + ",validateRequestHeaders=" + this.validateRequestHeaders + ",validateResponseHeaders=" + this.validateResponseHeaders + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected static class Http1ClientProtocolConfigImpl
        implements Http1ClientProtocolConfig {
            private final boolean defaultKeepAlive;
            private final boolean validateRequestHeaders;
            private final boolean validateResponseHeaders;
            private final int maxHeaderSize;
            private final int maxStatusLineLength;
            private final String name;

            protected Http1ClientProtocolConfigImpl(BuilderBase<?, ?> builder) {
                this.name = builder.name();
                this.defaultKeepAlive = builder.defaultKeepAlive();
                this.maxHeaderSize = builder.maxHeaderSize();
                this.maxStatusLineLength = builder.maxStatusLineLength();
                this.validateRequestHeaders = builder.validateRequestHeaders();
                this.validateResponseHeaders = builder.validateResponseHeaders();
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public boolean defaultKeepAlive() {
                return this.defaultKeepAlive;
            }

            @Override
            public int maxHeaderSize() {
                return this.maxHeaderSize;
            }

            @Override
            public int maxStatusLineLength() {
                return this.maxStatusLineLength;
            }

            @Override
            public boolean validateRequestHeaders() {
                return this.validateRequestHeaders;
            }

            @Override
            public boolean validateResponseHeaders() {
                return this.validateResponseHeaders;
            }

            public String toString() {
                return "Http1ClientProtocolConfig{name=" + this.name + ",defaultKeepAlive=" + this.defaultKeepAlive + ",maxHeaderSize=" + this.maxHeaderSize + ",maxStatusLineLength=" + this.maxStatusLineLength + ",validateRequestHeaders=" + this.validateRequestHeaders + ",validateResponseHeaders=" + this.validateResponseHeaders + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Http1ClientProtocolConfig)) {
                    return false;
                }
                Http1ClientProtocolConfig other = (Http1ClientProtocolConfig)o;
                return Objects.equals(this.name, other.name()) && this.defaultKeepAlive == other.defaultKeepAlive() && this.maxHeaderSize == other.maxHeaderSize() && this.maxStatusLineLength == other.maxStatusLineLength() && this.validateRequestHeaders == other.validateRequestHeaders() && this.validateResponseHeaders == other.validateResponseHeaders();
            }

            public int hashCode() {
                return Objects.hash(this.name, this.defaultKeepAlive, this.maxHeaderSize, this.maxStatusLineLength, this.validateRequestHeaders, this.validateResponseHeaders);
            }
        }
    }
}

