/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http1;

import io.helidon.common.tls.Tls;
import io.helidon.common.tls.TlsConfig;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.HeaderValues;
import io.helidon.http.WritableHeaders;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.ConnectionKey;
import io.helidon.webclient.api.Proxy;
import io.helidon.webclient.api.TcpClientConnection;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.http1.Http1ClientConfig;
import io.helidon.webclient.http1.Http1ClientImpl;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

class Http1ConnectionCache {
    private static final System.Logger LOGGER = System.getLogger(Http1ConnectionCache.class.getName());
    private static final Tls NO_TLS = ((TlsConfig.Builder)Tls.builder().enabled(false)).build();
    private static final String HTTPS = "https";
    private static final Http1ConnectionCache SHARED = Http1ConnectionCache.create();
    private static final List<String> ALPN_ID = List.of("http/1.1");
    private static final Duration QUEUE_TIMEOUT = Duration.ofMillis(10L);
    private final Map<ConnectionKey, LinkedBlockingDeque<TcpClientConnection>> cache = new ConcurrentHashMap<ConnectionKey, LinkedBlockingDeque<TcpClientConnection>>();

    Http1ConnectionCache() {
    }

    static Http1ConnectionCache shared() {
        return SHARED;
    }

    static Http1ConnectionCache create() {
        return new Http1ConnectionCache();
    }

    ClientConnection connection(Http1ClientImpl http1Client, Tls tls, Proxy proxy, ClientUri uri, ClientRequestHeaders headers, boolean defaultKeepAlive) {
        Tls effectiveTls;
        boolean keepAlive = this.handleKeepAlive(defaultKeepAlive, (WritableHeaders<?>)headers);
        Tls tls2 = effectiveTls = HTTPS.equals(uri.scheme()) ? tls : NO_TLS;
        if (keepAlive) {
            return this.keepAliveConnection(http1Client, effectiveTls, uri, proxy);
        }
        return this.oneOffConnection(http1Client, effectiveTls, uri, proxy);
    }

    private boolean handleKeepAlive(boolean defaultKeepAlive, WritableHeaders<?> headers) {
        if (headers.contains(HeaderValues.CONNECTION_CLOSE)) {
            return false;
        }
        if (defaultKeepAlive) {
            headers.setIfAbsent(HeaderValues.CONNECTION_KEEP_ALIVE);
            return true;
        }
        if (headers.contains(HeaderValues.CONNECTION_KEEP_ALIVE)) {
            return true;
        }
        headers.set(HeaderValues.CONNECTION_CLOSE);
        return false;
    }

    private ClientConnection keepAliveConnection(Http1ClientImpl http1Client, Tls tls, ClientUri uri, Proxy proxy) {
        TcpClientConnection connection;
        Http1ClientConfig clientConfig = http1Client.clientConfig();
        ConnectionKey connectionKey = new ConnectionKey(uri.scheme(), uri.host(), uri.port(), tls, clientConfig.dnsResolver(), clientConfig.dnsAddressLookup(), proxy);
        LinkedBlockingDeque connectionQueue = this.cache.computeIfAbsent(connectionKey, it -> new LinkedBlockingDeque(clientConfig.connectionCacheSize()));
        while ((connection = (TcpClientConnection)connectionQueue.poll()) != null && !connection.isConnected()) {
        }
        if (connection == null) {
            connection = TcpClientConnection.create((WebClient)http1Client.webClient(), (ConnectionKey)connectionKey, ALPN_ID, conn -> this.finishRequest(connectionQueue, (TcpClientConnection)conn), conn -> {}).connect();
        } else if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, String.format("[%s] client connection obtained %s", connection.channelId(), Thread.currentThread().getName()));
        }
        return connection;
    }

    private ClientConnection oneOffConnection(Http1ClientImpl http1Client, Tls tls, ClientUri uri, Proxy proxy) {
        WebClient webClient = http1Client.webClient();
        Http1ClientConfig clientConfig = http1Client.clientConfig();
        return TcpClientConnection.create((WebClient)webClient, (ConnectionKey)new ConnectionKey(uri.scheme(), uri.host(), uri.port(), tls, clientConfig.dnsResolver(), clientConfig.dnsAddressLookup(), proxy), ALPN_ID, conn -> false, conn -> {}).connect();
    }

    private boolean finishRequest(LinkedBlockingDeque<TcpClientConnection> connectionQueue, TcpClientConnection conn) {
        block6: {
            if (conn.isConnected()) {
                try {
                    if (connectionQueue.offer(conn, QUEUE_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS)) {
                        conn.helidonSocket().idle();
                        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                            LOGGER.log(System.Logger.Level.DEBUG, "[%s] client connection returned %s", conn.channelId(), Thread.currentThread().getName());
                        }
                        return true;
                    }
                    if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                        LOGGER.log(System.Logger.Level.DEBUG, "[%s] Unable to return client connection because queue is full %s", conn.channelId(), Thread.currentThread().getName());
                    }
                }
                catch (InterruptedException e) {
                    if (!LOGGER.isLoggable(System.Logger.Level.DEBUG)) break block6;
                    LOGGER.log(System.Logger.Level.DEBUG, "[%s] Unable to return client connection due to '%s' %s", conn.channelId(), e.getMessage(), Thread.currentThread().getName());
                }
            }
        }
        return false;
    }
}

