/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.grpc;

import io.grpc.CallOptions;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.helidon.common.buffers.BufferData;
import io.helidon.webclient.grpc.GrpcBaseClientCall;
import io.helidon.webclient.grpc.GrpcChannel;
import java.time.Duration;

class GrpcUnaryClientCall<ReqT, ResT>
extends GrpcBaseClientCall<ReqT, ResT> {
    private static final System.Logger LOGGER = System.getLogger(GrpcUnaryClientCall.class.getName());
    private volatile boolean closeCalled;
    private volatile boolean requestSent;
    private volatile boolean responseSent;

    GrpcUnaryClientCall(GrpcChannel grpcChannel, MethodDescriptor<ReqT, ResT> methodDescriptor, CallOptions callOptions) {
        super(grpcChannel, methodDescriptor, callOptions);
    }

    public void request(int numMessages) {
        this.socket().log(LOGGER, System.Logger.Level.DEBUG, "request called %d", new Object[]{numMessages});
        if (numMessages < 1) {
            this.close(Status.INVALID_ARGUMENT);
        }
    }

    public void cancel(String message, Throwable cause) {
        this.socket().log(LOGGER, System.Logger.Level.DEBUG, "cancel called %s", new Object[]{message});
        this.close(Status.CANCELLED);
    }

    public void halfClose() {
        this.socket().log(LOGGER, System.Logger.Level.DEBUG, "halfClose called", new Object[0]);
        this.close(this.responseSent ? Status.OK : Status.UNKNOWN);
    }

    public void sendMessage(ReqT message) {
        if (this.requestSent) {
            this.close(Status.FAILED_PRECONDITION);
            return;
        }
        byte[] serialized = this.serializeMessage(message);
        BufferData messageData = BufferData.createReadOnly((byte[])serialized, (int)0, (int)serialized.length);
        BufferData headerData = BufferData.create((int)5);
        headerData.writeInt8(0);
        headerData.writeUnsignedInt32((long)messageData.available());
        this.clientStream().writeData(BufferData.create((BufferData[])new BufferData[]{headerData, messageData}), true);
        this.requestSent = true;
        if (this.enableMetrics()) {
            this.bytesSent().addAndGet(serialized.length);
        }
        this.clientStream().readHeaders();
        while (this.isRemoteOpen()) {
            if (this.clientStream().trailers().isDone() || !this.clientStream().hasEntity()) {
                this.socket().log(LOGGER, System.Logger.Level.DEBUG, "[Reading thread] trailers or eos received", new Object[0]);
                break;
            }
            BufferData bufferData = this.readGrpcFrame();
            if (bufferData == null) continue;
            this.socket().log(LOGGER, System.Logger.Level.DEBUG, "response received", new Object[0]);
            if (this.enableMetrics()) {
                this.bytesRcvd().addAndGet(bufferData.available() - 5);
            }
            this.responseListener().onMessage(this.toResponse(bufferData));
            this.responseSent = true;
        }
    }

    @Override
    protected void startStreamingThreads() {
    }

    private void close(Status status) {
        if (!this.closeCalled) {
            this.socket().log(LOGGER, System.Logger.Level.DEBUG, "closing client call", new Object[0]);
            this.responseListener().onClose(status, EMPTY_METADATA);
            this.clientStream().cancel();
            this.connection().close();
            if (this.enableMetrics() && status == Status.OK) {
                GrpcBaseClientCall.MethodMetrics methodMetrics = this.methodMetrics();
                methodMetrics.callDuration().record(Duration.ofMillis(System.currentTimeMillis() - this.startMillis()));
                methodMetrics.recvMessageSize().record((double)this.bytesRcvd().get());
                methodMetrics.sentMessageSize().record((double)this.bytesSent().get());
            }
            this.unblockUnaryExecutor();
            this.closeCalled = true;
        }
    }
}

