/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.grpc;

import io.grpc.CallCredentials;
import io.grpc.ClientInterceptor;
import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.webclient.grpc.GrpcClientMethodDescriptor;
import io.helidon.webclient.grpc.GrpcServiceDescriptorBlueprint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webclient.grpc.GrpcServiceDescriptorBlueprint")
public interface GrpcServiceDescriptor
extends GrpcServiceDescriptorBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GrpcServiceDescriptor instance) {
        return (Builder)GrpcServiceDescriptor.builder().from(instance);
    }

    public static GrpcServiceDescriptor create() {
        return GrpcServiceDescriptor.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, GrpcServiceDescriptor>
    implements io.helidon.common.Builder<Builder, GrpcServiceDescriptor> {
        private Builder() {
        }

        public GrpcServiceDescriptor buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.GrpcServiceDescriptorImpl(this);
        }

        public GrpcServiceDescriptor build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends GrpcServiceDescriptor>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final List<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
        private final Map<String, GrpcClientMethodDescriptor> methods = new LinkedHashMap<String, GrpcClientMethodDescriptor>();
        private boolean isInterceptorsMutated;
        private CallCredentials callCredentials;
        private String serviceName;

        protected BuilderBase() {
        }

        public BUILDER from(GrpcServiceDescriptor prototype) {
            this.serviceName(prototype.serviceName());
            this.addMethods(prototype.methods());
            if (!this.isInterceptorsMutated) {
                this.interceptors.clear();
            }
            this.addInterceptors(prototype.interceptors());
            this.callCredentials(prototype.callCredentials());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.serviceName().ifPresent(this::serviceName);
            this.addMethods(builder.methods);
            if (this.isInterceptorsMutated) {
                if (builder.isInterceptorsMutated) {
                    this.addInterceptors(builder.interceptors);
                }
            } else {
                this.interceptors.clear();
                this.addInterceptors(builder.interceptors);
            }
            builder.callCredentials().ifPresent(this::callCredentials);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceName(String serviceName) {
            Objects.requireNonNull(serviceName);
            this.serviceName = serviceName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER methods(Map<String, ? extends GrpcClientMethodDescriptor> methods) {
            Objects.requireNonNull(methods);
            this.methods.clear();
            this.methods.putAll(methods);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addMethods(Map<String, ? extends GrpcClientMethodDescriptor> methods) {
            Objects.requireNonNull(methods);
            this.methods.putAll(methods);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putMethod(String key, GrpcClientMethodDescriptor method) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(method);
            this.methods.put(key, method);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER interceptors(List<? extends ClientInterceptor> interceptors) {
            Objects.requireNonNull(interceptors);
            this.isInterceptorsMutated = true;
            this.interceptors.clear();
            this.interceptors.addAll(interceptors);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInterceptors(List<? extends ClientInterceptor> interceptors) {
            Objects.requireNonNull(interceptors);
            this.isInterceptorsMutated = true;
            this.interceptors.addAll(interceptors);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInterceptor(ClientInterceptor interceptor) {
            Objects.requireNonNull(interceptor);
            this.interceptors.add(interceptor);
            this.isInterceptorsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearCallCredentials() {
            this.callCredentials = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER callCredentials(CallCredentials callCredentials) {
            Objects.requireNonNull(callCredentials);
            this.callCredentials = callCredentials;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> serviceName() {
            return Optional.ofNullable(this.serviceName);
        }

        public Map<String, GrpcClientMethodDescriptor> methods() {
            return this.methods;
        }

        public List<ClientInterceptor> interceptors() {
            return this.interceptors;
        }

        public Optional<CallCredentials> callCredentials() {
            return Optional.ofNullable(this.callCredentials);
        }

        public String toString() {
            return "GrpcServiceDescriptorBuilder{serviceName=" + this.serviceName + ",methods=" + String.valueOf(this.methods) + ",interceptors=" + String.valueOf(this.interceptors) + ",callCredentials=" + String.valueOf(this.callCredentials) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.serviceName == null) {
                collector.fatal(this.getClass(), "Property \"serviceName\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER callCredentials(Optional<? extends CallCredentials> callCredentials) {
            Objects.requireNonNull(callCredentials);
            this.callCredentials = callCredentials.map(CallCredentials.class::cast).orElse(this.callCredentials);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class GrpcServiceDescriptorImpl
        implements GrpcServiceDescriptor {
            private final List<ClientInterceptor> interceptors;
            private final Map<String, GrpcClientMethodDescriptor> methods;
            private final Optional<CallCredentials> callCredentials;
            private final String serviceName;

            protected GrpcServiceDescriptorImpl(BuilderBase<?, ?> builder) {
                this.serviceName = builder.serviceName().get();
                this.methods = Collections.unmodifiableMap(new LinkedHashMap<String, GrpcClientMethodDescriptor>(builder.methods()));
                this.interceptors = List.copyOf(builder.interceptors());
                this.callCredentials = builder.callCredentials();
            }

            @Override
            public String serviceName() {
                return this.serviceName;
            }

            @Override
            public Map<String, GrpcClientMethodDescriptor> methods() {
                return this.methods;
            }

            @Override
            public List<ClientInterceptor> interceptors() {
                return this.interceptors;
            }

            @Override
            public Optional<CallCredentials> callCredentials() {
                return this.callCredentials;
            }

            public String toString() {
                return "GrpcServiceDescriptor{serviceName=" + this.serviceName + ",methods=" + String.valueOf(this.methods) + ",interceptors=" + String.valueOf(this.interceptors) + ",callCredentials=" + String.valueOf(this.callCredentials) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GrpcServiceDescriptor)) {
                    return false;
                }
                GrpcServiceDescriptor other = (GrpcServiceDescriptor)o;
                return Objects.equals(this.serviceName, other.serviceName()) && Objects.equals(this.methods, other.methods()) && Objects.equals(this.interceptors, other.interceptors()) && Objects.equals(this.callCredentials, other.callCredentials());
            }

            public int hashCode() {
                return Objects.hash(this.serviceName, this.methods, this.interceptors, this.callCredentials);
            }
        }
    }
}

