/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.grpc;

import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.helidon.common.LazyValue;
import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.CompositeBufferData;
import io.helidon.common.socket.HelidonSocket;
import io.helidon.common.socket.SocketContext;
import io.helidon.common.tls.Tls;
import io.helidon.grpc.core.GrpcHeadersUtil;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.WritableHeaders;
import io.helidon.http.http2.Http2FrameData;
import io.helidon.http.http2.Http2Headers;
import io.helidon.http.http2.Http2Settings;
import io.helidon.http.http2.Http2StreamState;
import io.helidon.metrics.api.Counter;
import io.helidon.metrics.api.DistributionSummary;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.Metrics;
import io.helidon.metrics.api.Tag;
import io.helidon.metrics.api.Timer;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.ConnectionKey;
import io.helidon.webclient.api.DefaultDnsResolver;
import io.helidon.webclient.api.DnsAddressLookup;
import io.helidon.webclient.api.Proxy;
import io.helidon.webclient.api.TcpClientConnection;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.grpc.ClientUriSupplier;
import io.helidon.webclient.grpc.GrpcChannel;
import io.helidon.webclient.grpc.GrpcClientConfig;
import io.helidon.webclient.grpc.GrpcClientImpl;
import io.helidon.webclient.grpc.GrpcClientStream;
import io.helidon.webclient.http2.Http2ClientConnection;
import io.helidon.webclient.http2.Http2ClientImpl;
import io.helidon.webclient.http2.Http2StreamConfig;
import io.helidon.webclient.http2.StreamTimeoutException;
import io.helidon.webclient.spi.DnsResolver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

abstract class GrpcBaseClientCall<ReqT, ResT>
extends ClientCall<ReqT, ResT> {
    private static final System.Logger LOGGER = System.getLogger(GrpcBaseClientCall.class.getName());
    protected static final Metadata EMPTY_METADATA = new Metadata();
    protected static final Header GRPC_ACCEPT_ENCODING = HeaderValues.create((HeaderName)HeaderNames.ACCEPT_ENCODING, (String)"gzip");
    protected static final Header GRPC_CONTENT_TYPE = HeaderValues.create((HeaderName)HeaderNames.CONTENT_TYPE, (String)"application/grpc");
    protected static final BufferData PING_FRAME = BufferData.create((String)"PING");
    protected static final BufferData EMPTY_BUFFER_DATA = BufferData.empty();
    protected static final int DATA_PREFIX_LENGTH = 5;
    protected static final Tag OK_TAG = Tag.create((String)"grpc.status", (String)"OK");
    private static final LazyValue<Map<String, MethodMetrics>> METHOD_METRICS = LazyValue.create(ConcurrentHashMap::new);
    private final GrpcClientImpl grpcClient;
    private final GrpcChannel grpcChannel;
    private final MethodDescriptor<ReqT, ResT> methodDescriptor;
    private final CallOptions callOptions;
    private final int initBufferSize;
    private final Duration pollWaitTime;
    private final boolean abortPollTimeExpired;
    private final Duration heartbeatPeriod;
    private final ClientUriSupplier clientUriSupplier;
    private final GrpcClientConfig grpcConfig;
    private final MethodDescriptor.Marshaller<ReqT> requestMarshaller;
    private final MethodDescriptor.Marshaller<ResT> responseMarshaller;
    private volatile Http2ClientConnection connection;
    private volatile GrpcClientStream clientStream;
    private volatile ClientCall.Listener<ResT> responseListener;
    private volatile HelidonSocket socket;
    private volatile MethodMetrics methodMetrics;
    private volatile long startMillis;
    private AtomicLong bytesSent;
    private AtomicLong bytesRcvd;

    GrpcBaseClientCall(GrpcChannel grpcChannel, MethodDescriptor<ReqT, ResT> methodDescriptor, CallOptions callOptions) {
        this.grpcClient = (GrpcClientImpl)grpcChannel.grpcClient();
        this.grpcConfig = this.grpcClient.clientConfig();
        this.grpcChannel = grpcChannel;
        this.methodDescriptor = methodDescriptor;
        this.callOptions = callOptions;
        this.requestMarshaller = methodDescriptor.getRequestMarshaller();
        this.responseMarshaller = methodDescriptor.getResponseMarshaller();
        this.initBufferSize = this.grpcClient.prototype().protocolConfig().initBufferSize();
        this.pollWaitTime = this.grpcClient.prototype().protocolConfig().pollWaitTime();
        this.abortPollTimeExpired = this.grpcClient.prototype().protocolConfig().abortPollTimeExpired();
        this.heartbeatPeriod = this.grpcClient.prototype().protocolConfig().heartbeatPeriod();
        this.clientUriSupplier = this.grpcClient.prototype().clientUriSupplier().orElse(null);
    }

    public void start(ClientCall.Listener<ResT> responseListener, Metadata metadata) {
        LOGGER.log(System.Logger.Level.DEBUG, "start called");
        this.responseListener = responseListener;
        if (this.grpcConfig.enableMetrics()) {
            this.initMetrics();
            this.bytesSent = new AtomicLong(0L);
            this.bytesRcvd = new AtomicLong(0L);
            this.startMillis = System.currentTimeMillis();
            this.methodMetrics.callStarted.increment();
        }
        ClientUri clientUri = this.nextClientUri();
        ClientConnection clientConnection = this.clientConnection(clientUri);
        this.socket = clientConnection.helidonSocket();
        this.connection = Http2ClientConnection.create((Http2ClientImpl)((Http2ClientImpl)this.grpcClient.http2Client()), (ClientConnection)clientConnection, (boolean)true);
        this.clientStream = new GrpcClientStream(this.connection, Http2Settings.create(), (SocketContext)this.socket, new Http2StreamConfig(){

            public boolean priorKnowledge() {
                return true;
            }

            public int priority() {
                return 0;
            }

            public Duration readTimeout() {
                return GrpcBaseClientCall.this.grpcClient.prototype().readTimeout().orElse(GrpcBaseClientCall.this.grpcClient.prototype().protocolConfig().pollWaitTime());
            }
        }, null, this.connection.streamIdSequence());
        this.startStreamingThreads();
        WritableHeaders<?> headers = GrpcBaseClientCall.setupHeaders(metadata, clientUri.authority(), this.methodDescriptor.getFullMethodName());
        this.clientStream.writeHeaders(Http2Headers.create(headers), false);
    }

    static WritableHeaders<?> setupHeaders(Metadata metadata, String authority, String methodName) {
        WritableHeaders headers = WritableHeaders.create();
        GrpcHeadersUtil.updateHeaders((WritableHeaders)headers, (Metadata)metadata);
        headers.set(Http2Headers.AUTHORITY_NAME, new String[]{authority});
        headers.set(Http2Headers.METHOD_NAME, new String[]{"POST"});
        headers.set(Http2Headers.PATH_NAME, new String[]{"/" + methodName});
        headers.set(Http2Headers.SCHEME_NAME, new String[]{"http"});
        headers.set(GRPC_CONTENT_TYPE);
        headers.set(GRPC_ACCEPT_ENCODING);
        return headers;
    }

    abstract void startStreamingThreads();

    protected BufferData readGrpcFrame() {
        Http2FrameData frameData;
        try {
            frameData = this.clientStream.readOne(this.pollWaitTime());
        }
        catch (StreamTimeoutException e) {
            this.handleStreamTimeout(e);
            return null;
        }
        if (frameData == null) {
            return null;
        }
        BufferData bufferData = frameData.data();
        bufferData.read();
        long grpcLength = bufferData.readUnsignedInt32();
        if ((grpcLength -= (long)bufferData.available()) > 0L) {
            CompositeBufferData compositeBuffer = BufferData.createComposite((BufferData)bufferData);
            do {
                try {
                    frameData = this.clientStream.readOne(this.pollWaitTime());
                }
                catch (StreamTimeoutException e) {
                    this.handleStreamTimeout(e);
                    continue;
                }
                if (frameData == null) continue;
                bufferData = frameData.data();
                compositeBuffer.add(bufferData);
                grpcLength -= (long)bufferData.available();
            } while (grpcLength > 0L);
            bufferData = compositeBuffer;
        }
        bufferData.rewind();
        return bufferData;
    }

    protected void unblockUnaryExecutor() {
        Executor executor = this.callOptions.getExecutor();
        if (executor != null) {
            try {
                executor.execute(() -> {});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected GrpcClientImpl grpcClient() {
        return this.grpcClient;
    }

    protected ClientConnection clientConnection(ClientUri clientUri) {
        WebClient webClient = this.grpcClient.webClient();
        GrpcClientConfig clientConfig = this.grpcClient.prototype();
        ConnectionKey connectionKey = ConnectionKey.create((String)clientUri.scheme(), (String)clientUri.host(), (int)clientUri.port(), (Tls)clientConfig.tls(), (DnsResolver)DefaultDnsResolver.create(), (DnsAddressLookup)DnsAddressLookup.defaultLookup(), (Proxy)Proxy.noProxy());
        return TcpClientConnection.create((WebClient)webClient, (ConnectionKey)connectionKey, Collections.emptyList(), connection -> false, connection -> {}).connect();
    }

    protected boolean isRemoteOpen() {
        return this.clientStream.streamState() != Http2StreamState.HALF_CLOSED_REMOTE && this.clientStream.streamState() != Http2StreamState.CLOSED;
    }

    protected ResT toResponse(final BufferData bufferData) {
        bufferData.read();
        bufferData.readUnsignedInt32();
        return (ResT)this.responseMarshaller.parse(new InputStream(this){

            @Override
            public int read() {
                return bufferData.available() > 0 ? bufferData.read() : -1;
            }
        });
    }

    protected byte[] serializeMessage(ReqT message) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.initBufferSize);
        try (InputStream is = this.requestMarshaller().stream(message);){
            is.transferTo(baos);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return baos.toByteArray();
    }

    protected Duration heartbeatPeriod() {
        return this.heartbeatPeriod;
    }

    protected boolean abortPollTimeExpired() {
        return this.abortPollTimeExpired;
    }

    protected Duration pollWaitTime() {
        return this.pollWaitTime;
    }

    protected Http2ClientConnection connection() {
        return this.connection;
    }

    protected MethodDescriptor.Marshaller<ReqT> requestMarshaller() {
        return this.requestMarshaller;
    }

    protected GrpcClientStream clientStream() {
        return this.clientStream;
    }

    protected ClientCall.Listener<ResT> responseListener() {
        return this.responseListener;
    }

    protected HelidonSocket socket() {
        return this.socket;
    }

    protected MethodMetrics methodMetrics() {
        return this.methodMetrics;
    }

    protected long startMillis() {
        return this.startMillis;
    }

    protected boolean enableMetrics() {
        return this.grpcConfig.enableMetrics();
    }

    protected AtomicLong bytesSent() {
        return this.bytesSent;
    }

    protected AtomicLong bytesRcvd() {
        return this.bytesRcvd;
    }

    private ClientUri nextClientUri() {
        return this.clientUriSupplier == null ? (ClientUri)this.grpcClient.prototype().baseUri().orElseThrow() : (ClientUri)this.clientUriSupplier.next();
    }

    protected void handleStreamTimeout(StreamTimeoutException e) {
        if (this.abortPollTimeExpired()) {
            this.socket().log(LOGGER, System.Logger.Level.ERROR, "[Reading thread] HTTP/2 stream timeout, aborting", new Object[0]);
            throw e;
        }
        this.socket().log(LOGGER, System.Logger.Level.ERROR, "[Reading thread] HTTP/2 stream timeout, retrying", new Object[0]);
    }

    protected void initMetrics() {
        String baseUri = this.grpcChannel.baseUri().toString();
        String methodName = this.methodDescriptor.getFullMethodName();
        this.methodMetrics = ((Map)METHOD_METRICS.get()).computeIfAbsent(baseUri + methodName, uri -> {
            MeterRegistry meterRegistry = Metrics.globalRegistry();
            Tag grpcMethod = Tag.create((String)"grpc.method", (String)methodName);
            Tag grpcTarget = Tag.create((String)"grpc.target", (String)baseUri);
            Counter.Builder callStartedBuilder = (Counter.Builder)((Counter.Builder)Counter.builder((String)"grpc.client.attempt.started").scope("vendor")).tags(List.of(grpcMethod, grpcTarget));
            Counter callStarted = (Counter)meterRegistry.getOrCreate((Meter.Builder)callStartedBuilder);
            Timer.Builder callDurationOkBuilder = (Timer.Builder)((Timer.Builder)((Timer.Builder)Timer.builder((String)"grpc.client.attempt.duration").scope("vendor")).baseUnit("milliseconds")).tags(List.of(grpcMethod, grpcTarget, OK_TAG));
            Timer callDuration = (Timer)meterRegistry.getOrCreate((Meter.Builder)callDurationOkBuilder);
            DistributionSummary.Builder sendMessageSizeBuilder = (DistributionSummary.Builder)((DistributionSummary.Builder)DistributionSummary.builder((String)"grpc.client.attempt.sent_total_compressed_message_size").scope("vendor")).tags(List.of(grpcMethod, grpcTarget, OK_TAG));
            DistributionSummary sentMessageSize = (DistributionSummary)meterRegistry.getOrCreate((Meter.Builder)sendMessageSizeBuilder);
            DistributionSummary.Builder recvMessageSizeBuilder = (DistributionSummary.Builder)((DistributionSummary.Builder)DistributionSummary.builder((String)"grpc.client.attempt.rcvd_total_compressed_message_size").scope("vendor")).tags(List.of(grpcMethod, grpcTarget, OK_TAG));
            DistributionSummary recvMessageSize = (DistributionSummary)meterRegistry.getOrCreate((Meter.Builder)recvMessageSizeBuilder);
            return new MethodMetrics(callStarted, callDuration, sentMessageSize, recvMessageSize);
        });
    }

    protected record MethodMetrics(Counter callStarted, Timer callDuration, DistributionSummary sentMessageSize, DistributionSummary recvMessageSize) {
    }
}

