/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.grpc;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.grpc.GrpcClient;
import io.helidon.webclient.grpc.GrpcClientCall;
import io.helidon.webclient.grpc.GrpcClientImpl;
import io.helidon.webclient.grpc.GrpcUnaryClientCall;

class GrpcChannel
extends Channel {
    private final GrpcClientImpl grpcClient;

    GrpcChannel(GrpcClient grpcClient) {
        this.grpcClient = (GrpcClientImpl)grpcClient;
    }

    public <ReqT, ResT> ClientCall<ReqT, ResT> newCall(MethodDescriptor<ReqT, ResT> methodDescriptor, CallOptions callOptions) {
        MethodDescriptor.MethodType methodType = methodDescriptor.getType();
        return methodType == MethodDescriptor.MethodType.UNARY ? new GrpcUnaryClientCall<ReqT, ResT>(this.grpcClient, methodDescriptor, callOptions) : new GrpcClientCall<ReqT, ResT>(this.grpcClient, methodDescriptor, callOptions);
    }

    public String authority() {
        ClientUri clientUri = (ClientUri)this.grpcClient.prototype().baseUri().orElseThrow(() -> new IllegalArgumentException("No base URI provided for GrpcClient"));
        return clientUri.authority();
    }
}

