/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.context;

import io.helidon.common.context.Context;
import io.helidon.common.context.http.ContextRecordConfig;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.HeaderName;
import java.util.List;
import java.util.Optional;

interface PropagationRecord {
    public static PropagationRecord create(ContextRecordConfig contextRecord) {
        HeaderName headerName = contextRecord.header();
        boolean isArray = contextRecord.array();
        String classifier = contextRecord.classifier().orElseGet(() -> ((HeaderName)headerName).defaultCase());
        if (isArray) {
            List<String> defaults = contextRecord.defaultValues();
            if (defaults.isEmpty() && contextRecord.defaultValue().isPresent()) {
                defaults = List.of((String)contextRecord.defaultValue().get());
            }
            return new ArrayRecord(classifier, headerName, defaults.toArray(new String[0]));
        }
        Optional<String> defaultValue = contextRecord.defaultValue();
        if (defaultValue.isEmpty() && !contextRecord.defaultValues().isEmpty()) {
            defaultValue = Optional.of((String)contextRecord.defaultValues().getFirst());
        }
        return new StringRecord(classifier, headerName, defaultValue);
    }

    public void apply(Context var1, ClientRequestHeaders var2);

    public static class ArrayRecord
    implements PropagationRecord {
        private final String classifier;
        private final HeaderName headerName;
        private final Optional<String[]> defaultValue;

        ArrayRecord(String classifier, HeaderName headerName, String[] defaultValue) {
            this.classifier = classifier;
            this.headerName = headerName;
            this.defaultValue = defaultValue.length == 0 ? Optional.empty() : Optional.of(defaultValue);
        }

        @Override
        public void apply(Context context, ClientRequestHeaders headers) {
            context.get((Object)this.classifier, String[].class).or(() -> this.defaultValue).ifPresent(it -> headers.set(this.headerName, it));
        }

        public String toString() {
            return this.classifier + " -> " + String.valueOf(this.headerName) + " (String[])";
        }
    }

    public static class StringRecord
    implements PropagationRecord {
        private final String classifier;
        private final HeaderName headerName;
        private final Optional<String> defaultValue;

        StringRecord(String classifier, HeaderName headerName, Optional<String> defaultValue) {
            this.classifier = classifier;
            this.headerName = headerName;
            this.defaultValue = defaultValue;
        }

        @Override
        public void apply(Context context, ClientRequestHeaders headers) {
            context.get((Object)this.classifier, String.class).or(() -> this.defaultValue).ifPresent(it -> headers.set(this.headerName, new String[]{it}));
        }

        public String toString() {
            return this.classifier + " -> " + String.valueOf(this.headerName) + " (String)";
        }
    }
}

