/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.context;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.config.Config;
import io.helidon.webclient.api.WebClientServiceRequest;
import io.helidon.webclient.api.WebClientServiceResponse;
import io.helidon.webclient.context.PropagationRecord;
import io.helidon.webclient.context.WebClientContextConfig;
import io.helidon.webclient.spi.WebClientService;
import java.util.List;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=WebClientContextConfig.class)
public class WebClientContextService
implements WebClientService,
RuntimeType.Api<WebClientContextConfig> {
    private final List<PropagationRecord> propagations;
    private final WebClientContextConfig config;

    private WebClientContextService(WebClientContextConfig config) {
        this.config = config;
        this.propagations = config.records().stream().map(PropagationRecord::create).toList();
    }

    public static WebClientContextConfig.Builder builder() {
        return WebClientContextConfig.builder();
    }

    public static WebClientContextService create(Config config) {
        return WebClientContextService.create(WebClientContextConfig.create(config));
    }

    public static WebClientContextService create(WebClientContextConfig config) {
        return new WebClientContextService(config);
    }

    public static WebClientContextService create(Consumer<WebClientContextConfig.Builder> builderConsumer) {
        return ((WebClientContextConfig.Builder)WebClientContextService.builder().update(builderConsumer)).build();
    }

    public String name() {
        return this.config.name();
    }

    public String type() {
        return "context";
    }

    public WebClientContextConfig prototype() {
        return this.config;
    }

    public WebClientServiceResponse handle(WebClientService.Chain chain, WebClientServiceRequest clientRequest) {
        for (PropagationRecord propagation : this.propagations) {
            propagation.apply(clientRequest.context(), clientRequest.headers());
        }
        return chain.proceed(clientRequest);
    }
}

