/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.spi;

import io.helidon.config.Config;
import io.helidon.security.spi.ProviderConfig;
import io.helidon.security.spi.SecurityProvider;
import java.util.function.Function;

public interface EncryptionProvider<T extends ProviderConfig>
extends SecurityProvider {
    public EncryptionSupport encryption(Config var1);

    public EncryptionSupport encryption(T var1);

    public static class EncryptionSupport {
        private final Function<byte[], String> encryptionFunction;
        private final Function<String, byte[]> decryptionFunction;

        protected EncryptionSupport(Function<byte[], String> encryptionFunction, Function<String, byte[]> decryptionFunction) {
            this.encryptionFunction = encryptionFunction;
            this.decryptionFunction = decryptionFunction;
        }

        public static EncryptionSupport create(Function<byte[], String> encryptionFunction, Function<String, byte[]> decryptionFunction) {
            return new EncryptionSupport(encryptionFunction, decryptionFunction);
        }

        public String encrypt(byte[] bytes) {
            return this.encryptionFunction.apply(bytes);
        }

        public byte[] decrypt(String encrypted) {
            return this.decryptionFunction.apply(encrypted);
        }
    }
}

