/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.AuditEvent;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.AuthorizationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.OutboundSecurityClientBuilder;
import io.helidon.security.Principal;
import io.helidon.security.Security;
import io.helidon.security.SecurityClientBuilder;
import io.helidon.security.SecurityContextImpl;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityRequestBuilder;
import io.helidon.security.SecurityTime;
import io.helidon.security.Subject;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.Tracer;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public interface SecurityContext {
    public static final Principal ANONYMOUS_PRINCIPAL = Principal.builder().name("<ANONYMOUS>").addAttribute("anonymous", true).build();
    public static final Subject ANONYMOUS = Subject.builder().principal(ANONYMOUS_PRINCIPAL).addAttribute("anonymous", true).build();

    public SecurityRequestBuilder<?> securityRequestBuilder();

    public SecurityRequestBuilder<?> securityRequestBuilder(SecurityEnvironment var1);

    public SecurityClientBuilder<AuthenticationResponse> atnClientBuilder();

    public AuthenticationResponse authenticate();

    public SecurityClientBuilder<AuthorizationResponse> atzClientBuilder();

    public OutboundSecurityClientBuilder outboundClientBuilder();

    public AuthorizationResponse authorize(Object ... var1);

    public boolean isAuthenticated();

    public void logout();

    public boolean isUserInRole(String var1, String var2);

    public ExecutorService executorService();

    public boolean isUserInRole(String var1);

    public void audit(AuditEvent var1);

    public Optional<Subject> service();

    default public Optional<Principal> servicePrincipal() {
        return this.service().map(Subject::principal);
    }

    default public String serviceName() {
        return this.servicePrincipal().map(java.security.Principal::getName).orElse(null);
    }

    public Optional<Subject> user();

    default public Optional<Principal> userPrincipal() {
        return this.user().map(Subject::principal);
    }

    default public String userName() {
        return this.userPrincipal().map(java.security.Principal::getName).orElse(null);
    }

    public void runAs(Subject var1, Runnable var2);

    public void runAs(String var1, Runnable var2);

    public SpanContext tracingSpan();

    public Tracer tracer();

    public String id();

    public SecurityTime serverTime();

    public SecurityEnvironment env();

    default public void env(Supplier<SecurityEnvironment> envBuilder) {
        this.env(envBuilder.get());
    }

    public void env(SecurityEnvironment var1);

    public EndpointConfig endpointConfig();

    public void endpointConfig(EndpointConfig var1);

    default public void endpointConfig(Supplier<EndpointConfig> epBuilder) {
        this.endpointConfig(epBuilder.get());
    }

    public boolean atzChecked();

    public static class Builder
    implements io.helidon.common.Builder<Builder, SecurityContext> {
        private final Security security;
        private String id;
        private Supplier<ExecutorService> executorServiceSupplier;
        private SecurityTime serverTime;
        private Tracer tracingTracer;
        private SpanContext tracingSpan;
        private SecurityEnvironment env;
        private EndpointConfig ec;

        Builder(Security security) {
            this.security = security;
            this.executorServiceSupplier = security.executorService();
        }

        public SecurityContext build() {
            if (null == this.env) {
                this.env = SecurityEnvironment.builder(this.serverTime).build();
            }
            if (null == this.ec) {
                this.ec = EndpointConfig.builder().build();
            }
            if (null == this.tracingTracer) {
                this.tracingTracer = Tracer.global();
            }
            return new SecurityContextImpl(this);
        }

        Security security() {
            return this.security;
        }

        String id() {
            return this.id;
        }

        Supplier<ExecutorService> executorServiceSupplier() {
            return this.executorServiceSupplier;
        }

        SecurityTime serverTime() {
            return this.serverTime;
        }

        Tracer tracingTracer() {
            return this.tracingTracer;
        }

        SpanContext tracingSpan() {
            return this.tracingSpan;
        }

        SecurityEnvironment env() {
            return this.env;
        }

        EndpointConfig endpointConfig() {
            return this.ec;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder executorService(Supplier<ExecutorService> executorServiceSupplier) {
            this.executorServiceSupplier = executorServiceSupplier;
            return this;
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorServiceSupplier = () -> executorService;
            return this;
        }

        public Builder serverTime(SecurityTime serverTime) {
            this.serverTime = serverTime;
            return this;
        }

        public Builder tracingTracer(Tracer tracingTracer) {
            this.tracingTracer = tracingTracer;
            return this;
        }

        public Builder tracingSpan(SpanContext tracingSpan) {
            this.tracingSpan = tracingSpan;
            return this;
        }

        public Builder env(SecurityEnvironment env) {
            this.env = env;
            return this;
        }

        public Builder endpointConfig(EndpointConfig ec) {
            this.ec = ec;
            return this;
        }
    }
}

