/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.common.CollectionsHelper;
import io.helidon.config.Config;
import io.helidon.security.ClassToInstanceStore;
import io.helidon.security.SecurityLevel;
import io.helidon.security.util.AbacSupport;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class EndpointConfig
implements AbacSupport {
    private final List<SecurityLevel> securityLevels;
    private final AbacSupport attributes;
    private final ClassToInstanceStore<Object> customObjects;
    private final Map<String, Config> configMap;

    private EndpointConfig(Builder builder) {
        this.securityLevels = Collections.unmodifiableList(builder.securityLevels);
        this.attributes = AbacSupport.BasicAttributes.create((AbacSupport)builder.attributes);
        this.customObjects = new ClassToInstanceStore();
        this.customObjects.putAll(builder.customObjects);
        this.configMap = new HashMap<String, Config>(builder.configMap);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static EndpointConfig create() {
        return EndpointConfig.builder().build();
    }

    public Object abacAttributeRaw(String key) {
        return this.attributes.abacAttributeRaw(key);
    }

    public Collection<String> abacAttributeNames() {
        return this.attributes.abacAttributeNames();
    }

    public <U> Optional<U> instance(Class<U> clazz) {
        return this.customObjects.getInstance(clazz);
    }

    public Collection<Class<?>> instanceKeys() {
        return this.customObjects.keys();
    }

    public Optional<Config> config(String configKey) {
        return Optional.ofNullable(this.configMap.get(configKey));
    }

    @Deprecated
    public Map<Class<? extends Annotation>, List<Annotation>> annotations(AnnotationScope ... scopes) {
        HashMap<Class<? extends Annotation>, List<Annotation>> result = new HashMap<Class<? extends Annotation>, List<Annotation>>();
        for (AnnotationScope scope : scopes) {
            Map<Class<? extends Annotation>, List<Annotation>> map;
            switch (scope) {
                case APPLICATION: {
                    map = this.securityLevels.get(0).getClassLevelAnnotations();
                    break;
                }
                case CLASS: {
                    map = this.securityLevels.get(this.securityLevels.size() - 1).getClassLevelAnnotations();
                    break;
                }
                case METHOD: {
                    map = this.securityLevels.get(this.securityLevels.size() - 1).getMethodLevelAnnotations();
                    break;
                }
                default: {
                    map = null;
                }
            }
            if (null == map) continue;
            map.forEach((annotClass, annotList) -> result.computeIfAbsent((Class<? extends Annotation>)annotClass, aClass -> new LinkedList()).addAll(annotList));
        }
        return result;
    }

    public List<SecurityLevel> securityLevels() {
        return this.securityLevels;
    }

    @Deprecated
    public <T extends Annotation> List<T> combineAnnotations(Class<T> annotationClass, AnnotationScope ... scopes) {
        LinkedList result = new LinkedList();
        result.addAll(this.annotations(scopes).getOrDefault(annotationClass, CollectionsHelper.listOf()));
        return result;
    }

    public Builder derive() {
        Builder result = EndpointConfig.builder().attributes(this.attributes).customObjects(this.customObjects).configMap(this.configMap).securityLevels(this.securityLevels);
        return result;
    }

    public static final class Builder
    implements io.helidon.common.Builder<EndpointConfig> {
        private final ClassToInstanceStore<Object> customObjects = new ClassToInstanceStore();
        private final Map<String, Config> configMap = new HashMap<String, Config>();
        private final List<SecurityLevel> securityLevels = new ArrayList<SecurityLevel>();
        private AbacSupport.BasicAttributes attributes = AbacSupport.BasicAttributes.create();

        private Builder() {
        }

        public EndpointConfig build() {
            return new EndpointConfig(this);
        }

        public <U, V extends U> Builder customObject(Class<U> objectClass, V anObject) {
            this.customObjects.putInstance(objectClass, anObject);
            return this;
        }

        public Builder customObjects(ClassToInstanceStore<Object> customObjects) {
            this.customObjects.putAll(customObjects);
            return this;
        }

        public Builder config(String configKey, Config configuration) {
            this.configMap.put(configKey, configuration);
            return this;
        }

        public Builder configMap(Map<String, Config> configMap) {
            this.configMap.putAll(configMap);
            return this;
        }

        @Deprecated
        public Builder annotations(AnnotationScope scope, Map<Class<? extends Annotation>, List<Annotation>> annotations) {
            HashMap<Class<? extends Annotation>, List<Annotation>> newAnnots = new HashMap<Class<? extends Annotation>, List<Annotation>>();
            if (this.securityLevels.isEmpty()) {
                this.securityLevels.add(SecurityLevel.create("APPLICATION").build());
                this.securityLevels.add(SecurityLevel.create("CLASS").build());
            }
            int index = scope == AnnotationScope.APPLICATION ? 0 : this.securityLevels.size() - 1;
            SecurityLevel securityLevel = this.securityLevels.get(index);
            annotations.forEach((aClass, list) -> {
                if (!list.isEmpty()) {
                    Annotation annotation = (Annotation)list.get(0);
                    newAnnots.put(annotation.annotationType(), (List<Annotation>)list);
                }
            });
            switch (scope) {
                case APPLICATION: 
                case CLASS: {
                    this.securityLevels.set(index, SecurityLevel.create(securityLevel).withClassAnnotations(newAnnots).build());
                    break;
                }
                case METHOD: {
                    this.securityLevels.set(index, SecurityLevel.create(securityLevel).withMethodAnnotations(newAnnots).build());
                    break;
                }
                default: {
                    throw new IllegalStateException("Scope FIELD is not supported here.");
                }
            }
            return this;
        }

        private Builder attributes(AbacSupport attributes) {
            this.attributes = AbacSupport.BasicAttributes.create((AbacSupport)attributes);
            return this;
        }

        public Builder addAtribute(String key, Object value) {
            this.attributes.put(key, value);
            return this;
        }

        public Builder securityLevels(List<SecurityLevel> securityLevels) {
            this.securityLevels.addAll(securityLevels);
            return this;
        }
    }

    public static enum AnnotationScope {
        APPLICATION,
        CLASS,
        METHOD,
        FIELD;

    }
}

