/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.AuditEvent;
import io.helidon.security.AuthorizationResponse;
import io.helidon.security.ProviderRequest;
import io.helidon.security.Security;
import io.helidon.security.SecurityClient;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityContextImpl;
import io.helidon.security.SecurityException;
import io.helidon.security.SecurityRequest;
import io.helidon.security.internal.SecurityAuditEvent;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

final class AuthorizationClientImpl
implements SecurityClient<AuthorizationResponse> {
    private final Security security;
    private final SecurityContextImpl context;
    private final SecurityRequest request;
    private final String providerName;
    private final ProviderRequest providerRequest;

    AuthorizationClientImpl(Security security, SecurityContextImpl context, SecurityRequest request, String providerName) {
        this.security = security;
        this.context = context;
        this.request = request;
        this.providerName = providerName;
        this.providerRequest = new ProviderRequest(context, request.resources(), request.requestEntity(), request.responseEntity());
    }

    @Override
    public CompletionStage<AuthorizationResponse> submit() {
        return this.security.resolveAtzProvider(this.providerName).map(providerInstance -> providerInstance.authorize(this.providerRequest).thenApply(response -> {
            if (response.status().isSuccess()) {
                this.context.audit(SecurityAuditEvent.success("authz.authorize", "Provider %s. Request %s. Subject %s").addParam(AuditEvent.AuditParam.plain("provider", providerInstance.getClass().getName())).addParam(AuditEvent.AuditParam.plain("request", this)).addParam(AuditEvent.AuditParam.plain("subject", this.context.user().orElse(SecurityContext.ANONYMOUS))));
            } else {
                this.context.audit(SecurityAuditEvent.failure("authz.authorize", "Provider %s, Description %s, Request %s. Subject %s").addParam(AuditEvent.AuditParam.plain("provider", providerInstance.getClass().getName())).addParam(AuditEvent.AuditParam.plain("request", this)).addParam(AuditEvent.AuditParam.plain("subject", this.context.user().orElse(SecurityContext.ANONYMOUS))).addParam(AuditEvent.AuditParam.plain("message", response.description().orElse(null))).addParam(AuditEvent.AuditParam.plain("exception", response.throwable().orElse(null))));
            }
            return response;
        }).exceptionally(throwable -> {
            this.context.audit(SecurityAuditEvent.error("authz.authorize", "Provider %s, Description %s, Request %s. Subject %s. %s: %s").addParam(AuditEvent.AuditParam.plain("provider", providerInstance.getClass().getName())).addParam(AuditEvent.AuditParam.plain("description", "Audit failure")).addParam(AuditEvent.AuditParam.plain("request", this)).addParam(AuditEvent.AuditParam.plain("subject", this.context.user().orElse(SecurityContext.ANONYMOUS))).addParam(AuditEvent.AuditParam.plain("message", throwable.getMessage())).addParam(AuditEvent.AuditParam.plain("exception", throwable)));
            throw new SecurityException((Throwable)throwable);
        })).orElse(CompletableFuture.completedFuture(AuthorizationResponse.permit()));
    }
}

