/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.util.AbacSupport;
import java.security.Principal;
import java.util.Collection;

public class Grant
implements AbacSupport,
Principal {
    private final AbacSupport properties;
    private final String type;
    private final String name;
    private final String origin;

    protected Grant(Builder<?> builder) {
        this.type = ((Builder)builder).type;
        this.name = ((Builder)builder).name;
        this.origin = ((Builder)builder).origin;
        AbacSupport.BasicAttributes properties = AbacSupport.BasicAttributes.create((AbacSupport)((Builder)builder).properties);
        properties.put("type", (Object)this.type);
        properties.put("name", (Object)this.name);
        properties.put("origin", (Object)this.origin);
        this.properties = properties;
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public Object abacAttributeRaw(String key) {
        return this.properties.abacAttributeRaw(key);
    }

    public Collection<String> abacAttributeNames() {
        return this.properties.abacAttributeNames();
    }

    public String type() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.type + ":" + this.name;
    }

    public String origin() {
        return this.origin;
    }

    public static class Builder<T extends Builder<T>>
    implements io.helidon.common.Builder<Grant> {
        private AbacSupport.BasicAttributes properties = AbacSupport.BasicAttributes.create();
        private String type;
        private String name;
        private String origin = "builder";
        private final T instance = this;

        protected Builder() {
        }

        public Grant build() {
            return new Grant(this);
        }

        public T type(String type) {
            this.type = type;
            return this.instance;
        }

        public T name(String name) {
            this.name = name;
            return this.instance;
        }

        public T origin(String origin) {
            this.origin = origin;
            return this.instance;
        }

        public T attributes(AbacSupport attribs) {
            this.properties = AbacSupport.BasicAttributes.create((AbacSupport)attribs);
            return this.instance;
        }

        public T addAttribute(String key, Object value) {
            this.properties.put(key, value);
            return this.instance;
        }
    }
}

