/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt.jwk;

import io.helidon.common.configurable.Resource;
import io.helidon.security.jwt.jwk.Jwk;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReaderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class JwkKeys {
    private static final System.Logger LOGGER = System.getLogger(JwkKeys.class.getName());
    private static final JsonReaderFactory JSON = Json.createReaderFactory(Collections.emptyMap());
    private final Map<String, Jwk> keyMap = new HashMap<String, Jwk>();
    private final List<Jwk> noKeyIdKeys = new LinkedList<Jwk>();

    private JwkKeys(Builder builder) {
        this.keyMap.putAll(builder.keyMap);
        this.noKeyIdKeys.addAll(builder.noKeyIdKeys);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static JwkKeys create(JsonObject json) {
        return JwkKeys.builder().json(json).build();
    }

    public Optional<Jwk> forKeyId(String keyId) {
        return Optional.ofNullable(this.keyMap.get(keyId));
    }

    public List<Jwk> keys() {
        LinkedList<Jwk> result = new LinkedList<Jwk>();
        result.addAll(this.noKeyIdKeys);
        result.addAll(this.keyMap.values());
        return result;
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, JwkKeys> {
        private final List<Jwk> noKeyIdKeys = new LinkedList<Jwk>();
        private final Map<String, Jwk> keyMap = new HashMap<String, Jwk>();

        private Builder() {
        }

        public JwkKeys build() {
            return new JwkKeys(this);
        }

        public Builder addKey(Jwk key) {
            Objects.requireNonNull(key, "Key must not be null");
            if (null == key.keyId()) {
                this.noKeyIdKeys.add(key);
            } else {
                this.keyMap.put(key.keyId(), key);
            }
            return this;
        }

        public Builder resource(Resource resource) {
            Objects.requireNonNull(resource, "Json resource must not be null");
            try (InputStream is = resource.stream();){
                JsonObject jsonObject = JSON.createReader(is).readObject();
                this.addKeys(jsonObject);
            }
            catch (IOException e) {
                LOGGER.log(System.Logger.Level.WARNING, "Failed to close input stream on resource: " + String.valueOf(resource));
            }
            return this;
        }

        public Builder json(JsonObject json) {
            this.addKeys(json);
            return this;
        }

        private void addKeys(JsonObject jsonObject) {
            JsonArray keyArray = jsonObject.getJsonArray("keys");
            keyArray.forEach(it -> {
                JsonObject aKey = (JsonObject)it;
                try {
                    this.addKey(Jwk.create(aKey));
                }
                catch (Exception e) {
                    LOGGER.log(System.Logger.Level.WARNING, "Could not process a key from JWK JSON, this key will not be available", (Throwable)e);
                }
            });
        }
    }
}

