/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt;

import io.helidon.common.Errors;
import io.helidon.security.jwt.ClaimValidator;
import io.helidon.security.jwt.CommonValidator;
import io.helidon.security.jwt.Jwt;
import io.helidon.security.jwt.Validator;
import java.util.List;
import java.util.Objects;

final class ValidatorWrapper
extends CommonValidator {
    private final Validator<Jwt> validator;

    private ValidatorWrapper(Builder builder) {
        super(builder);
        this.validator = builder.validator;
    }

    static Builder builder() {
        return new Builder();
    }

    @Override
    public void validate(Jwt jwt, Errors.Collector collector, List<ClaimValidator> validators) {
        this.validator.validate(jwt, collector);
    }

    static final class Builder
    extends CommonValidator.BaseBuilder<Builder, ValidatorWrapper> {
        private Validator<Jwt> validator;

        private Builder() {
        }

        public Builder validator(Validator<Jwt> validator) {
            this.validator = Objects.requireNonNull(validator);
            return this;
        }

        public ValidatorWrapper build() {
            Errors.Collector collector = Errors.collector();
            if (this.validator == null) {
                collector.fatal(this.getClass(), "No validator instance was set");
            }
            collector.collect().checkValid();
            return new ValidatorWrapper(this);
        }
    }
}

