/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt;

import io.helidon.common.Errors;
import io.helidon.common.GenericType;
import io.helidon.security.jwt.JwtClaims;
import io.helidon.security.jwt.JwtException;
import io.helidon.security.jwt.JwtUtil;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class JwtHeaders
extends JwtClaims {
    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());
    private final Optional<String> algorithm;
    private final Optional<String> encryption;
    private final Optional<String> contentType;
    private final Optional<String> keyId;
    private final Optional<String> type;
    private final Optional<String> subject;
    private final Optional<String> issuer;
    private final Optional<List<String>> audience;
    private final Map<String, JsonValue> headerClaims;

    private JwtHeaders(Builder builder) {
        this.algorithm = Optional.ofNullable(builder.algorithm);
        this.encryption = Optional.ofNullable(builder.encryption);
        this.contentType = Optional.ofNullable(builder.contentType);
        this.keyId = Optional.ofNullable(builder.keyId);
        this.type = Optional.ofNullable(builder.type);
        this.subject = Optional.ofNullable(builder.subject);
        this.issuer = Optional.ofNullable(builder.issuer);
        this.audience = Optional.ofNullable(builder.audience);
        this.headerClaims = new LinkedHashMap<String, JsonValue>(builder.claims);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static JwtHeaders parseToken(String token) {
        Errors.Collector collector = Errors.collector();
        int firstDot = token.indexOf(46);
        if (firstDot < 0) {
            throw new JwtException("Not a JWT token: " + token);
        }
        String headerBase64 = token.substring(0, firstDot);
        JwtHeaders jwtHeader = JwtHeaders.parseBase64(headerBase64, collector);
        collector.collect().checkValid();
        return jwtHeader;
    }

    static JwtHeaders parseBase64(String base64, Errors.Collector collector) {
        String headerJsonString = JwtHeaders.decode(base64, collector, "JWT header");
        if (collector.hasFatal()) {
            return null;
        }
        JsonObject headerJson = JwtHeaders.parseJson(headerJsonString, collector, base64, "JWT header");
        if (collector.hasFatal()) {
            return null;
        }
        Builder builder = JwtHeaders.builder();
        builder.fromJson(headerJson);
        collector.collect().checkValid();
        return builder.build();
    }

    public JsonObject headerJson() {
        JsonObjectBuilder objectBuilder = JSON.createObjectBuilder();
        this.headerClaims.forEach((arg_0, arg_1) -> ((JsonObjectBuilder)objectBuilder).add(arg_0, arg_1));
        return objectBuilder.build();
    }

    public Optional<JsonValue> headerClaim(String claim) {
        return Optional.ofNullable(this.headerClaims.get(claim));
    }

    public Optional<String> algorithm() {
        return this.algorithm;
    }

    public Optional<String> encryption() {
        return this.encryption;
    }

    public Optional<String> contentType() {
        return this.contentType;
    }

    public Optional<String> keyId() {
        return this.keyId;
    }

    public Optional<String> type() {
        return this.type;
    }

    public Optional<String> subject() {
        return this.subject;
    }

    public Optional<String> issuer() {
        return this.issuer;
    }

    public Optional<List<String>> audience() {
        return this.audience;
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, JwtHeaders> {
        private static final GenericType<List<String>> STRING_LIST_TYPE = new GenericType<List<String>>(){};
        private static final Map<String, KnownField<? extends Object>> KNOWN_HEADER_CLAIMS;
        private static final KnownField<String> TYPE_FIELD;
        private static final KnownField<String> ALG_FIELD;
        private static final KnownField<String> ENC_FIELD;
        private static final KnownField<String> CTY_FIELD;
        private static final KnownField<String> KID_FIELD;
        private static final KnownField<String> SUB_FIELD;
        private static final KnownField<String> ISS_FIELD;
        private static final KnownField<List<String>> AUD_FIELD;
        private final Map<String, JsonValue> claims = new LinkedHashMap<String, JsonValue>();
        private String type;
        private String algorithm;
        private String encryption;
        private String contentType;
        private String keyId;
        private String subject;
        private String issuer;
        private List<String> audience;

        private Builder() {
        }

        public JwtHeaders build() {
            if (this.audience != null) {
                AUD_FIELD.set(this.claims, this.audience);
            }
            return new JwtHeaders(this);
        }

        public Builder addHeaderClaim(String claim, Object value) {
            this.setFromGeneric(claim, value);
            this.claims.put(claim, JwtUtil.toJson(value));
            return this;
        }

        public Builder algorithm(String algorithm) {
            ALG_FIELD.set(this.claims, algorithm);
            this.algorithm = algorithm;
            return this;
        }

        public Builder encryption(String encryption) {
            ENC_FIELD.set(this.claims, encryption);
            this.encryption = encryption;
            return this;
        }

        public Builder contentType(String contentType) {
            CTY_FIELD.set(this.claims, contentType);
            this.contentType = contentType;
            return this;
        }

        public Builder keyId(String keyId) {
            KID_FIELD.set(this.claims, keyId);
            this.keyId = keyId;
            return this;
        }

        public Builder type(String type) {
            TYPE_FIELD.set(this.claims, type);
            this.type = type;
            return this;
        }

        public Builder headerSubject(String subject) {
            SUB_FIELD.set(this.claims, subject);
            this.subject = subject;
            return this;
        }

        public Builder headerIssuer(String issuer) {
            ISS_FIELD.set(this.claims, issuer);
            this.issuer = issuer;
            return this;
        }

        public Builder addHeaderAudience(String audience) {
            if (this.audience == null) {
                this.audience = new LinkedList<String>();
            }
            this.audience.add(audience);
            return this;
        }

        public Builder headerAudience(List<String> audience) {
            this.audience = new LinkedList<String>(audience);
            return this;
        }

        private void setFromGeneric(String claim, Object value) {
            KnownField<? extends Object> knownField = KNOWN_HEADER_CLAIMS.get(claim);
            if (knownField == null) {
                return;
            }
            if (!knownField.supports(value)) {
                throw new IllegalArgumentException("Claim \"" + claim + " is expected to be of type " + String.valueOf(knownField.type) + ", but is " + value.getClass().getName());
            }
            knownField.valueConsumer().accept(this, value);
        }

        private static List<String> jsonToStringList(JsonValue jsonValue) {
            if (jsonValue instanceof JsonString) {
                return List.of(((JsonString)jsonValue).getString());
            }
            if (jsonValue instanceof JsonArray) {
                return ((JsonArray)jsonValue).stream().map(KnownField::jsonToString).collect(Collectors.toList());
            }
            throw new JwtException("Json value should have been a String or an array of Strings, but is " + String.valueOf(jsonValue));
        }

        private static <T> void addKnownField(Map<String, KnownField<? extends Object>> map, KnownField<T> field) {
            map.put(field.name, field);
        }

        void fromJson(JsonObject headerJson) {
            headerJson.forEach((claim, value) -> {
                KnownField<? extends Object> knownField = KNOWN_HEADER_CLAIMS.get(claim);
                if (knownField == null) {
                    this.addHeaderClaim((String)claim, value);
                } else {
                    knownField.set(this, (JsonValue)value);
                }
            });
        }

        static {
            TYPE_FIELD = KnownField.create("typ", Builder::type);
            ALG_FIELD = KnownField.create("alg", Builder::algorithm);
            ENC_FIELD = KnownField.create("enc", Builder::encryption);
            CTY_FIELD = KnownField.create("cty", Builder::contentType);
            KID_FIELD = KnownField.create("kid", Builder::keyId);
            SUB_FIELD = KnownField.create("sub", Builder::headerSubject);
            ISS_FIELD = KnownField.create("iss", Builder::headerIssuer);
            AUD_FIELD = new KnownField<List>("aud", STRING_LIST_TYPE, Builder::headerAudience, Builder::jsonToStringList);
            HashMap<String, KnownField<? extends Object>> map = new HashMap<String, KnownField<? extends Object>>();
            Builder.addKnownField(map, TYPE_FIELD);
            Builder.addKnownField(map, ALG_FIELD);
            Builder.addKnownField(map, ENC_FIELD);
            Builder.addKnownField(map, CTY_FIELD);
            Builder.addKnownField(map, KID_FIELD);
            Builder.addKnownField(map, SUB_FIELD);
            Builder.addKnownField(map, ISS_FIELD);
            Builder.addKnownField(map, AUD_FIELD);
            KNOWN_HEADER_CLAIMS = Map.copyOf(map);
        }
    }

    private static final class KnownField<T> {
        private final String name;
        private final GenericType<T> type;
        private final BiConsumer<Builder, T> valueConsumer;
        private final Function<JsonValue, T> fromJson;

        private KnownField(String name, GenericType<T> type, BiConsumer<Builder, T> valueConsumer, Function<JsonValue, T> fromJson) {
            this.name = name;
            this.type = type;
            this.valueConsumer = valueConsumer;
            this.fromJson = fromJson;
        }

        static KnownField<String> create(String name, BiConsumer<Builder, String> valueConsumer) {
            return new KnownField<String>(name, GenericType.STRING, valueConsumer, KnownField::jsonToString);
        }

        private static String jsonToString(JsonValue jsonValue) {
            if (jsonValue instanceof JsonString) {
                return ((JsonString)jsonValue).getString();
            }
            throw new JwtException("Json value should have been a String, but is " + String.valueOf(jsonValue));
        }

        BiConsumer<Builder, T> valueConsumer() {
            return this.valueConsumer;
        }

        void set(Map<String, JsonValue> claims, T value) {
            claims.put(this.name, JwtUtil.toJson(value));
        }

        void set(Builder builder, JsonValue value) {
            this.valueConsumer.accept(builder, (Builder)this.fromJson.apply(value));
        }

        public boolean supports(Object value) {
            return this.type.rawType().isAssignableFrom(value.getClass());
        }
    }
}

