/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt.jwk;

import io.helidon.common.configurable.Resource;
import io.helidon.security.jwt.jwk.Jwk;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReaderFactory;

public final class JwkKeys {
    private static final Logger LOGGER = Logger.getLogger(JwkKeys.class.getName());
    private static final JsonReaderFactory JSON = Json.createReaderFactory(Collections.emptyMap());
    private final Map<String, Jwk> keyMap = new HashMap<String, Jwk>();
    private final List<Jwk> noKeyIdKeys = new LinkedList<Jwk>();

    private JwkKeys(Builder builder) {
        this.keyMap.putAll(builder.keyMap);
        this.noKeyIdKeys.addAll(builder.noKeyIdKeys);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Jwk> forKeyId(String keyId) {
        return Optional.ofNullable(this.keyMap.get(keyId));
    }

    public List<Jwk> keys() {
        LinkedList<Jwk> result = new LinkedList<Jwk>();
        result.addAll(this.noKeyIdKeys);
        result.addAll(this.keyMap.values());
        return result;
    }

    public static final class Builder
    implements io.helidon.common.Builder<JwkKeys> {
        private final List<Jwk> noKeyIdKeys = new LinkedList<Jwk>();
        private final Map<String, Jwk> keyMap = new HashMap<String, Jwk>();

        private Builder() {
        }

        public JwkKeys build() {
            return new JwkKeys(this);
        }

        public Builder addKey(Jwk key) {
            Objects.requireNonNull(key, "Key must not be null");
            if (null == key.keyId()) {
                this.noKeyIdKeys.add(key);
            } else {
                this.keyMap.put(key.keyId(), key);
            }
            return this;
        }

        public Builder resource(Resource resource) {
            Objects.requireNonNull(resource, "Json resource must not be null");
            try (InputStream is = resource.stream();){
                JsonObject jsonObject = JSON.createReader(is).readObject();
                this.addKeys(jsonObject);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to close input stream on resource: " + resource);
            }
            return this;
        }

        private void addKeys(JsonObject jsonObject) {
            JsonArray keyArray = jsonObject.getJsonArray("keys");
            keyArray.forEach(it -> {
                JsonObject aKey = (JsonObject)it;
                this.addKey(Jwk.create(aKey));
            });
        }
    }
}

