/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.scheduling;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.scheduling.FixedRate;
import io.helidon.scheduling.FixedRateConfigBlueprint;
import io.helidon.scheduling.FixedRateInvocation;
import io.helidon.scheduling.ScheduledConsumer;
import io.helidon.scheduling.TaskConfig;
import io.helidon.scheduling.TaskConfigDecorator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.scheduling.FixedRateConfigBlueprint")
public interface FixedRateConfig
extends FixedRateConfigBlueprint,
Prototype.Api,
TaskConfig {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FixedRateConfig instance) {
        return (Builder)FixedRateConfig.builder().from(instance);
    }

    public static FixedRateConfig create(Config config) {
        return ((Builder)FixedRateConfig.builder().config(config)).buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, FixedRateConfig>
    implements io.helidon.common.Builder<Builder, FixedRate> {
        private Builder() {
        }

        public FixedRateConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.FixedRateConfigImpl(this);
        }

        public FixedRate build() {
            return FixedRate.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends FixedRateConfig>
    extends TaskConfig.BuilderBase<BUILDER, PROTOTYPE>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private Config config;
        private FixedRate.DelayType delayType = FixedRate.DelayType.SINCE_PREVIOUS_START;
        private Long delay;
        private long initialDelay = 0L;
        private ScheduledConsumer<FixedRateInvocation> task;
        private TimeUnit timeUnit = TimeUnit.SECONDS;

        protected BuilderBase() {
        }

        public BUILDER from(FixedRateConfig prototype) {
            super.from(prototype);
            this.initialDelay(prototype.initialDelay());
            this.delay(prototype.delay());
            this.delayType(prototype.delayType());
            this.task(prototype.task());
            this.timeUnit(prototype.timeUnit());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            this.initialDelay(builder.initialDelay());
            builder.delay().ifPresent(this::delay);
            this.delayType(builder.delayType());
            builder.task().ifPresent(this::task);
            this.timeUnit(builder.timeUnit());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            super.config(config);
            config.get("initial-delay").as(Long.class).ifPresent(this::initialDelay);
            config.get("delay").as(Long.class).ifPresent(this::delay);
            config.get("delay-type").as(FixedRate.DelayType.class).ifPresent(this::delayType);
            config.get("time-unit").as(TimeUnit.class).ifPresent(this::timeUnit);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER initialDelay(long initialDelay) {
            this.initialDelay = initialDelay;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER delay(long delay) {
            this.delay = delay;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER delayType(FixedRate.DelayType delayType) {
            Objects.requireNonNull(delayType);
            this.delayType = delayType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER task(ScheduledConsumer<FixedRateInvocation> task) {
            Objects.requireNonNull(task);
            this.task = task;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER timeUnit(TimeUnit timeUnit) {
            Objects.requireNonNull(timeUnit);
            this.timeUnit = timeUnit;
            return (BUILDER)((BuilderBase)this.self());
        }

        public long initialDelay() {
            return this.initialDelay;
        }

        public Optional<Long> delay() {
            return Optional.ofNullable(this.delay);
        }

        public FixedRate.DelayType delayType() {
            return this.delayType;
        }

        public Optional<ScheduledConsumer<FixedRateInvocation>> task() {
            return Optional.ofNullable(this.task);
        }

        public TimeUnit timeUnit() {
            return this.timeUnit;
        }

        @Override
        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        @Override
        public String toString() {
            return "FixedRateConfigBuilder{initialDelay=" + this.initialDelay + ",delay=" + this.delay + ",delayType=" + String.valueOf((Object)this.delayType) + ",task=" + String.valueOf(this.task) + ",timeUnit=" + String.valueOf((Object)this.timeUnit) + "};" + super.toString();
        }

        @Override
        protected void preBuildPrototype() {
            super.preBuildPrototype();
            new TaskConfigDecorator().decorate(this);
        }

        @Override
        protected void validatePrototype() {
            super.validatePrototype();
            Errors.Collector collector = Errors.collector();
            if (this.delay == null) {
                collector.fatal(this.getClass(), "Property \"delay\" is required, but not set");
            }
            if (this.task == null) {
                collector.fatal(this.getClass(), "Property \"task\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class FixedRateConfigImpl
        extends TaskConfig.BuilderBase.TaskConfigImpl
        implements FixedRateConfig,
        Supplier<FixedRate> {
            private final FixedRate.DelayType delayType;
            private final long delay;
            private final long initialDelay;
            private final ScheduledConsumer<FixedRateInvocation> task;
            private final TimeUnit timeUnit;

            protected FixedRateConfigImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.initialDelay = builder.initialDelay();
                this.delay = builder.delay().get();
                this.delayType = builder.delayType();
                this.task = builder.task().get();
                this.timeUnit = builder.timeUnit();
            }

            public FixedRate build() {
                return FixedRate.create(this);
            }

            @Override
            public FixedRate get() {
                return this.build();
            }

            @Override
            public long initialDelay() {
                return this.initialDelay;
            }

            @Override
            public long delay() {
                return this.delay;
            }

            @Override
            public FixedRate.DelayType delayType() {
                return this.delayType;
            }

            @Override
            public ScheduledConsumer<FixedRateInvocation> task() {
                return this.task;
            }

            @Override
            public TimeUnit timeUnit() {
                return this.timeUnit;
            }

            @Override
            public String toString() {
                return "FixedRateConfig{initialDelay=" + this.initialDelay + ",delay=" + this.delay + ",delayType=" + String.valueOf((Object)this.delayType) + ",task=" + String.valueOf(this.task) + ",timeUnit=" + String.valueOf((Object)this.timeUnit) + "};" + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FixedRateConfig)) {
                    return false;
                }
                FixedRateConfig other = (FixedRateConfig)o;
                return super.equals(other) && this.initialDelay == other.initialDelay() && this.delay == other.delay() && Objects.equals((Object)this.delayType, (Object)other.delayType()) && Objects.equals(this.task, other.task()) && Objects.equals((Object)this.timeUnit, (Object)other.timeUnit());
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(new Object[]{this.initialDelay, this.delay, this.delayType, this.task, this.timeUnit});
            }
        }
    }
}

