/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.scheduling;

import io.helidon.common.Builder;
import io.helidon.common.configurable.ScheduledThreadPoolConfig;
import io.helidon.common.configurable.ScheduledThreadPoolSupplier;
import io.helidon.scheduling.CronInvocation;
import io.helidon.scheduling.CronTask;
import io.helidon.scheduling.FixedRateInvocation;
import io.helidon.scheduling.FixedRateTask;
import io.helidon.scheduling.ScheduledConsumer;
import io.helidon.scheduling.SchedulingException;
import io.helidon.scheduling.Task;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Scheduling {
    private Scheduling() {
    }

    public static FixedRateBuilder fixedRateBuilder() {
        return new FixedRateBuilder();
    }

    public static CronBuilder cronBuilder() {
        return new CronBuilder();
    }

    public static final class FixedRateBuilder
    implements Builder<FixedRateBuilder, Task> {
        private ScheduledExecutorService executorService;
        private long initialDelay = 0L;
        private Long delay;
        private TimeUnit timeUnit = TimeUnit.SECONDS;
        private ScheduledConsumer<FixedRateInvocation> task;

        private FixedRateBuilder() {
        }

        public FixedRateBuilder executor(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public FixedRateBuilder initialDelay(long initialDelay) {
            this.initialDelay = initialDelay;
            return this;
        }

        public FixedRateBuilder delay(long delay) {
            this.delay = delay;
            return this;
        }

        public FixedRateBuilder task(ScheduledConsumer<FixedRateInvocation> task) {
            this.task = task;
            return this;
        }

        public FixedRateBuilder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public Task build() {
            if (this.task == null) {
                throw new SchedulingException("No task to execute provided!");
            }
            if (this.delay == null) {
                throw new SchedulingException("No delay provided!");
            }
            if (this.executorService == null) {
                this.executorService = ((ScheduledThreadPoolConfig.Builder)ScheduledThreadPoolSupplier.builder().threadNamePrefix("scheduled-")).build().get();
            }
            return new FixedRateTask(this.executorService, this.initialDelay, this.delay, this.timeUnit, invocation -> this.task.run((FixedRateInvocation)invocation));
        }
    }

    public static final class CronBuilder
    implements Builder<CronBuilder, Task> {
        static final String DEFAULT_THREAD_NAME_PREFIX = "scheduled-";
        private ScheduledExecutorService executorService;
        private String cronExpression;
        private boolean concurrentExecution = true;
        private ScheduledConsumer<CronInvocation> task;

        private CronBuilder() {
        }

        public CronBuilder executor(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public CronBuilder expression(String cronExpression) {
            this.cronExpression = cronExpression;
            return this;
        }

        public CronBuilder concurrentExecution(boolean allowConcurrentExecution) {
            this.concurrentExecution = allowConcurrentExecution;
            return this;
        }

        public CronBuilder task(ScheduledConsumer<CronInvocation> task) {
            this.task = task;
            return this;
        }

        public Task build() {
            if (this.task == null) {
                throw new SchedulingException("No task to execute provided!");
            }
            if (this.cronExpression == null) {
                throw new SchedulingException("No CRON expression provided!");
            }
            if (this.executorService == null) {
                this.executorService = ((ScheduledThreadPoolConfig.Builder)ScheduledThreadPoolSupplier.builder().threadNamePrefix(DEFAULT_THREAD_NAME_PREFIX)).build().get();
            }
            CronTask task = new CronTask(this.executorService, this.cronExpression, this.concurrentExecution, invocation -> this.task.run((CronInvocation)invocation));
            return task;
        }
    }
}

