/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.Config;
import io.helidon.cors.CrossOriginConfig;
import io.helidon.openapi.OpenApiFeature;
import io.helidon.openapi.OpenApiFeatureConfigBlueprint;
import io.helidon.openapi.OpenApiManager;
import io.helidon.openapi.OpenApiService;
import io.helidon.openapi.spi.OpenApiManagerProvider;
import io.helidon.openapi.spi.OpenApiServiceProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.openapi.OpenApiFeatureConfigBlueprint")
public interface OpenApiFeatureConfig
extends OpenApiFeatureConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OpenApiFeatureConfig instance) {
        return (Builder)OpenApiFeatureConfig.builder().from(instance);
    }

    public static OpenApiFeatureConfig create(Config config) {
        return ((Builder)OpenApiFeatureConfig.builder().config(config)).buildPrototype();
    }

    public static OpenApiFeatureConfig create() {
        return OpenApiFeatureConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, OpenApiFeatureConfig>
    implements io.helidon.common.Builder<Builder, OpenApiFeature> {
        private Builder() {
        }

        public OpenApiFeatureConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.OpenApiFeatureConfigImpl(this);
        }

        public OpenApiFeature build() {
            return OpenApiFeature.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends OpenApiFeatureConfig>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<OpenApiService> services = new ArrayList<OpenApiService>();
        private final List<String> roles = new ArrayList<String>(List.of("openapi"));
        private final Set<String> sockets = new LinkedHashSet<String>();
        private boolean isEnabled = true;
        private boolean managerDiscoverServices = false;
        private boolean permitAll = true;
        private boolean servicesDiscoverServices = true;
        private Config config;
        private CrossOriginConfig cors;
        private double weight = 90.0;
        private OpenApiManager<?> manager;
        private String name = "openapi";
        private String staticFile;
        private String webContext = "/openapi";

        protected BuilderBase() {
        }

        public BUILDER from(OpenApiFeatureConfig prototype) {
            this.weight(prototype.weight());
            this.isEnabled(prototype.isEnabled());
            this.webContext(prototype.webContext());
            this.staticFile(prototype.staticFile());
            this.cors(prototype.cors());
            this.addServices(prototype.services());
            this.manager(prototype.manager());
            this.permitAll(prototype.permitAll());
            this.addRoles(prototype.roles());
            this.name(prototype.name());
            this.addSockets(prototype.sockets());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.weight(builder.weight());
            this.isEnabled(builder.isEnabled());
            this.webContext(builder.webContext());
            builder.staticFile().ifPresent(this::staticFile);
            builder.cors().ifPresent(this::cors);
            this.addServices(builder.services());
            builder.manager().ifPresent(this::manager);
            this.permitAll(builder.permitAll());
            this.addRoles(builder.roles());
            this.name(builder.name());
            this.addSockets(builder.sockets());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("weight").as(Double.class).ifPresent(this::weight);
            config.get("enabled").as(Boolean.class).ifPresent(this::isEnabled);
            config.get("web-context").as(String.class).ifPresent(this::webContext);
            config.get("static-file").as(String.class).ifPresent(this::staticFile);
            config.get("cors").map(CrossOriginConfig::create).ifPresent(this::cors);
            config.get("permit-all").as(Boolean.class).ifPresent(this::permitAll);
            config.get("roles").asList(String.class).ifPresent(this::roles);
            config.get("sockets").asList(String.class).map(Set::copyOf).ifPresent(this::sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER weight(double weight) {
            this.weight = weight;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER isEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER webContext(String webContext) {
            Objects.requireNonNull(webContext);
            this.webContext = webContext;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearStaticFile() {
            this.staticFile = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER staticFile(String staticFile) {
            Objects.requireNonNull(staticFile);
            this.staticFile = staticFile;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearCors() {
            this.cors = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER cors(CrossOriginConfig cors) {
            Objects.requireNonNull(cors);
            this.cors = cors;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER cors(Consumer<CrossOriginConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            CrossOriginConfig.Builder builder = CrossOriginConfig.builder();
            consumer.accept(builder);
            this.cors(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER servicesDiscoverServices(boolean discoverServices) {
            this.servicesDiscoverServices = discoverServices;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER services(List<? extends OpenApiService> services) {
            Objects.requireNonNull(services);
            this.services.clear();
            this.services.addAll(services);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addServices(List<? extends OpenApiService> services) {
            Objects.requireNonNull(services);
            this.services.addAll(services);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addService(OpenApiService service) {
            Objects.requireNonNull(service);
            this.services.add(service);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearManager() {
            this.manager = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER manager(OpenApiManager<?> manager) {
            Objects.requireNonNull(manager);
            this.manager = manager;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER permitAll(boolean permitAll) {
            this.permitAll = permitAll;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER roles(List<? extends String> roles) {
            Objects.requireNonNull(roles);
            this.roles.clear();
            this.roles.addAll(roles);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addRoles(List<? extends String> roles) {
            Objects.requireNonNull(roles);
            this.roles.addAll(roles);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sockets(Set<? extends String> sockets) {
            Objects.requireNonNull(sockets);
            this.sockets.clear();
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSockets(Set<? extends String> sockets) {
            Objects.requireNonNull(sockets);
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSocket(String socket) {
            Objects.requireNonNull(socket);
            this.sockets.add(socket);
            return (BUILDER)((BuilderBase)this.self());
        }

        public double weight() {
            return this.weight;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public String webContext() {
            return this.webContext;
        }

        public Optional<String> staticFile() {
            return Optional.ofNullable(this.staticFile);
        }

        public Optional<CrossOriginConfig> cors() {
            return Optional.ofNullable(this.cors);
        }

        public List<OpenApiService> services() {
            return this.services;
        }

        public Optional<OpenApiManager<?>> manager() {
            return Optional.ofNullable(this.manager);
        }

        public boolean permitAll() {
            return this.permitAll;
        }

        public List<String> roles() {
            return this.roles;
        }

        public String name() {
            return this.name;
        }

        public Set<String> sockets() {
            return this.sockets;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "OpenApiFeatureConfigBuilder{weight=" + this.weight + ",isEnabled=" + this.isEnabled + ",webContext=" + this.webContext + ",staticFile=" + this.staticFile + ",cors=" + String.valueOf(this.cors) + ",services=" + String.valueOf(this.services) + ",manager=" + String.valueOf(this.manager) + ",permitAll=" + this.permitAll + ",roles=" + String.valueOf(this.roles) + ",name=" + this.name + ",sockets=" + String.valueOf(this.sockets) + "}";
        }

        protected void preBuildPrototype() {
            this.config = this.config == null ? Config.empty() : this.config;
            HelidonServiceLoader serviceLoader = HelidonServiceLoader.create(ServiceLoader.load(OpenApiServiceProvider.class));
            this.addServices(this.discoverServices(this.config, "services", serviceLoader, OpenApiServiceProvider.class, OpenApiService.class, this.servicesDiscoverServices, this.services));
            serviceLoader = HelidonServiceLoader.create(ServiceLoader.load(OpenApiManagerProvider.class));
            this.discoverService(this.config, "manager", serviceLoader, OpenApiManagerProvider.class, OpenApiManager.class, this.managerDiscoverServices, Optional.ofNullable(this.manager)).ifPresent(this::manager);
        }

        protected void validatePrototype() {
        }

        BUILDER staticFile(Optional<String> staticFile) {
            Objects.requireNonNull(staticFile);
            this.staticFile = staticFile.map(String.class::cast).orElse(this.staticFile);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER cors(Optional<? extends CrossOriginConfig> cors) {
            Objects.requireNonNull(cors);
            this.cors = cors.map(CrossOriginConfig.class::cast).orElse(this.cors);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER manager(Optional<OpenApiManager<?>> manager) {
            Objects.requireNonNull(manager);
            this.manager = manager.map(OpenApiManager.class::cast).orElse(this.manager);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class OpenApiFeatureConfigImpl
        implements OpenApiFeatureConfig,
        Supplier<OpenApiFeature> {
            private final boolean isEnabled;
            private final boolean permitAll;
            private final double weight;
            private final List<OpenApiService> services;
            private final List<String> roles;
            private final Optional<CrossOriginConfig> cors;
            private final Optional<OpenApiManager<?>> manager;
            private final Optional<String> staticFile;
            private final Set<String> sockets;
            private final String name;
            private final String webContext;

            protected OpenApiFeatureConfigImpl(BuilderBase<?, ?> builder) {
                this.weight = builder.weight();
                this.isEnabled = builder.isEnabled();
                this.webContext = builder.webContext();
                this.staticFile = builder.staticFile();
                this.cors = builder.cors();
                this.services = List.copyOf(builder.services());
                this.manager = builder.manager();
                this.permitAll = builder.permitAll();
                this.roles = List.copyOf(builder.roles());
                this.name = builder.name();
                this.sockets = Collections.unmodifiableSet(new LinkedHashSet<String>(builder.sockets()));
            }

            public OpenApiFeature build() {
                return OpenApiFeature.create(this);
            }

            @Override
            public OpenApiFeature get() {
                return this.build();
            }

            @Override
            public double weight() {
                return this.weight;
            }

            @Override
            public boolean isEnabled() {
                return this.isEnabled;
            }

            @Override
            public String webContext() {
                return this.webContext;
            }

            @Override
            public Optional<String> staticFile() {
                return this.staticFile;
            }

            @Override
            public Optional<CrossOriginConfig> cors() {
                return this.cors;
            }

            @Override
            public List<OpenApiService> services() {
                return this.services;
            }

            @Override
            public Optional<OpenApiManager<?>> manager() {
                return this.manager;
            }

            @Override
            public boolean permitAll() {
                return this.permitAll;
            }

            @Override
            public List<String> roles() {
                return this.roles;
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public Set<String> sockets() {
                return this.sockets;
            }

            public String toString() {
                return "OpenApiFeatureConfig{weight=" + this.weight + ",isEnabled=" + this.isEnabled + ",webContext=" + this.webContext + ",staticFile=" + String.valueOf(this.staticFile) + ",cors=" + String.valueOf(this.cors) + ",services=" + String.valueOf(this.services) + ",manager=" + String.valueOf(this.manager) + ",permitAll=" + this.permitAll + ",roles=" + String.valueOf(this.roles) + ",name=" + this.name + ",sockets=" + String.valueOf(this.sockets) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OpenApiFeatureConfig)) {
                    return false;
                }
                OpenApiFeatureConfig other = (OpenApiFeatureConfig)o;
                return this.weight == other.weight() && this.isEnabled == other.isEnabled() && Objects.equals(this.webContext, other.webContext()) && Objects.equals(this.staticFile, other.staticFile()) && Objects.equals(this.cors, other.cors()) && Objects.equals(this.services, other.services()) && Objects.equals(this.manager, other.manager()) && this.permitAll == other.permitAll() && Objects.equals(this.roles, other.roles()) && Objects.equals(this.name, other.name()) && Objects.equals(this.sockets, other.sockets());
            }

            public int hashCode() {
                return Objects.hash(this.weight, this.isEnabled, this.webContext, this.staticFile, this.cors, this.services, this.manager, this.permitAll, this.roles, this.name, this.sockets);
            }
        }
    }
}

