/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum OpenApiFormat {
    JSON(new MediaType[]{MediaTypes.APPLICATION_OPENAPI_JSON, MediaTypes.APPLICATION_JSON}, "json"),
    YAML(new MediaType[]{MediaTypes.APPLICATION_OPENAPI_YAML, MediaTypes.APPLICATION_X_YAML, MediaTypes.APPLICATION_YAML, MediaTypes.TEXT_PLAIN, MediaTypes.TEXT_X_YAML, MediaTypes.TEXT_YAML}, "yaml", "yml"),
    UNSUPPORTED(new MediaType[0], new String[0]);

    private final List<String> fileTypes;
    private final List<MediaType> mediaTypes;

    private OpenApiFormat(MediaType[] mediaTypes, String ... fileTypes) {
        this.mediaTypes = Arrays.asList(mediaTypes);
        this.fileTypes = new ArrayList<String>(Arrays.asList(fileTypes));
    }

    public List<String> fileTypes() {
        return this.fileTypes;
    }

    private boolean supports(MediaType mediaType) {
        for (MediaType mt : this.mediaTypes) {
            if (!mediaType.type().equals(mt.type()) || !mediaType.subtype().equals(mt.subtype())) continue;
            return true;
        }
        return false;
    }

    public static OpenApiFormat valueOf(MediaType mediaType) {
        for (OpenApiFormat candidateType : OpenApiFormat.values()) {
            if (!candidateType.supports(mediaType)) continue;
            return candidateType;
        }
        return UNSUPPORTED;
    }
}

