/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.LazyValue;
import io.helidon.common.config.Config;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.cors.CrossOriginConfig;
import io.helidon.openapi.OpenApiFeatureConfig;
import io.helidon.openapi.OpenApiHttpFeature;
import io.helidon.openapi.OpenApiManager;
import io.helidon.openapi.SimpleOpenApiManager;
import io.helidon.webserver.cors.CorsEnabledServiceHelper;
import io.helidon.webserver.spi.ServerFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

@RuntimeType.PrototypedBy(value=OpenApiFeatureConfig.class)
public final class OpenApiFeature
implements ServerFeature,
RuntimeType.Api<OpenApiFeatureConfig> {
    static final String OPENAPI_ID = "openapi";
    static final double WEIGHT = 90.0;
    static final Map<String, MediaType> SUPPORTED_FORMATS = Map.of("json", MediaTypes.APPLICATION_JSON, "yaml", MediaTypes.APPLICATION_OPENAPI_YAML, "yml", MediaTypes.APPLICATION_OPENAPI_YAML);
    private static final System.Logger LOGGER = System.getLogger(OpenApiFeature.class.getName());
    private static final String DEFAULT_STATIC_FILE_PATH_PREFIX = "META-INF/openapi.";
    private static final List<String> DEFAULT_FILE_PATHS = SUPPORTED_FORMATS.keySet().stream().map(fileType -> DEFAULT_STATIC_FILE_PATH_PREFIX + fileType).toList();
    private final String content;
    private final OpenApiFeatureConfig config;
    private final CorsEnabledServiceHelper corsService;
    private final OpenApiManager<?> manager;
    private final LazyValue<Object> model;

    OpenApiFeature(OpenApiFeatureConfig config) {
        this.config = config;
        String staticFile = config.staticFile().orElse(null);
        String defaultContent = null;
        if (staticFile != null) {
            defaultContent = OpenApiFeature.readContent(staticFile);
            if (defaultContent == null) {
                defaultContent = "";
                LOGGER.log(System.Logger.Level.WARNING, "Static OpenAPI file not found: {0}", staticFile);
            }
        } else {
            String path;
            Iterator<String> iterator = DEFAULT_FILE_PATHS.iterator();
            while (iterator.hasNext() && (defaultContent = OpenApiFeature.readContent(path = iterator.next())) == null) {
            }
            if (defaultContent == null) {
                defaultContent = "";
                LOGGER.log(System.Logger.Level.WARNING, "Static OpenAPI file not found, checked: {0}", DEFAULT_FILE_PATHS);
            }
        }
        this.content = defaultContent;
        this.manager = config.manager().orElseGet(SimpleOpenApiManager::new);
        this.corsService = CorsEnabledServiceHelper.create((String)OPENAPI_ID, (CrossOriginConfig)config.cors().orElse(null));
        this.model = LazyValue.create(() -> this.manager.load(this.content));
    }

    public static OpenApiFeatureConfig.Builder builder() {
        return OpenApiFeatureConfig.builder();
    }

    public static OpenApiFeature create() {
        return OpenApiFeature.builder().build();
    }

    public static OpenApiFeature create(Config config) {
        return new OpenApiFeature(OpenApiFeatureConfig.create(config));
    }

    public static OpenApiFeature create(Consumer<OpenApiFeatureConfig.Builder> builderConsumer) {
        return ((OpenApiFeatureConfig.Builder)OpenApiFeatureConfig.builder().update(builderConsumer)).build();
    }

    static OpenApiFeature create(OpenApiFeatureConfig config) {
        return new OpenApiFeature(config);
    }

    public OpenApiFeatureConfig prototype() {
        return this.config;
    }

    public void setup(ServerFeature.ServerFeatureContext featureContext) {
        if (!this.config.isEnabled()) {
            return;
        }
        HashSet<String> sockets = new HashSet<String>(this.config.sockets());
        if (sockets.isEmpty()) {
            sockets.addAll(featureContext.sockets());
            sockets.add("@default");
        }
        for (String socket : sockets) {
            featureContext.socket(socket).httpRouting().addFeature((Supplier)((Object)new OpenApiHttpFeature(this.config, this.manager, this.model, this.corsService)));
        }
    }

    public String name() {
        return this.config.name();
    }

    public String type() {
        return OPENAPI_ID;
    }

    public void initialize() {
        this.model.get();
    }

    private static String readContent(String path) {
        String string;
        block9: {
            Path file = Path.of(path, new String[0]);
            if (Files.exists(file, new LinkOption[0])) {
                return Files.readString(file);
            }
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            try {
                String string2 = string = is != null ? new String(is.readAllBytes(), StandardCharsets.UTF_8) : null;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            is.close();
        }
        return string;
    }
}

