/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.LazyValue;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.common.uri.UriQuery;
import io.helidon.http.Http;
import io.helidon.http.HttpMediaType;
import io.helidon.openapi.OpenApiFeature;
import io.helidon.openapi.OpenApiUi;
import io.helidon.openapi.OpenApiUiFactory;
import io.helidon.openapi.OpenApiUiNoOpFactory;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Function;

public abstract class OpenApiUiBase
implements OpenApiUi {
    private static final System.Logger LOGGER = System.getLogger(OpenApiUiBase.class.getName());
    private static final LazyValue<OpenApiUiFactory<?, ?>> UI_FACTORY = LazyValue.create(OpenApiUiBase::loadUiFactory);
    private static final String HTML_PREFIX = "<!doctype html>\n<html lang=\"en-US\">\n    <head>\n        <meta charset=\"utf-8\"/>\n        <title>OpenAPI Document</title>\n    </head>\n    <body>\n        <pre>\n";
    private static final String HTML_SUFFIX = "        </pre>\n    </body>\n</html>\n";
    private final Map<MediaType, String> preparedDocuments = new HashMap<MediaType, String>();
    private final boolean isEnabled;
    private final Function<MediaType, String> documentPreparer;
    private final String webContext;
    private final Map<String, String> options = new HashMap<String, String>();

    static OpenApiUi.Builder<?, ?> builder() {
        return ((OpenApiUiFactory)UI_FACTORY.get()).builder();
    }

    protected OpenApiUiBase(Builder<?, ?> builder, Function<MediaType, String> documentPreparer, String openAPIWebContext) {
        Objects.requireNonNull(builder.documentPreparer, "Builder's documentPreparer must be non-null");
        Objects.requireNonNull(builder.openApiSupportWebContext, "Builder's OpenAPISupport web context must be non-null");
        this.documentPreparer = documentPreparer;
        this.isEnabled = builder.isEnabled;
        this.webContext = (String)((Object)Objects.requireNonNullElse(builder.webContext, openAPIWebContext + "/ui"));
        this.options.putAll(builder.options);
    }

    protected boolean isEnabled() {
        return this.isEnabled;
    }

    protected String prepareDocument(MediaType mediaType) {
        return this.documentPreparer.apply(mediaType);
    }

    protected String webContext() {
        return this.webContext;
    }

    protected Map<String, String> options() {
        return Collections.unmodifiableMap(this.options);
    }

    protected boolean sendStaticText(ServerRequest request, ServerResponse response, HttpMediaType mediaType) {
        try {
            response.header(Http.HeaderNames.CONTENT_TYPE, new String[]{mediaType.toString()}).send((Object)this.prepareDocument(request.query(), mediaType));
        }
        catch (IOException e) {
            LOGGER.log(System.Logger.Level.WARNING, "Error formatting OpenAPI output as " + String.valueOf(mediaType), (Throwable)e);
            response.status(Http.Status.INTERNAL_SERVER_ERROR_500).send((Object)"Error formatting OpenAPI output. See server log.");
        }
        return true;
    }

    private static OpenApiUiFactory<?, ?> loadUiFactory() {
        return (OpenApiUiFactory)HelidonServiceLoader.builder(ServiceLoader.load(OpenApiUiFactory.class)).addService((Object)OpenApiUiNoOpFactory.create(), 2.147483647E9).build().iterator().next();
    }

    private String prepareDocument(UriQuery queryParameters, HttpMediaType mediaType) throws IOException {
        String result = null;
        if (this.preparedDocuments.containsKey(mediaType)) {
            return this.preparedDocuments.get(mediaType);
        }
        MediaType resultMediaType = queryParameters.first("format").map(OpenApiFeature.QueryParameterRequestedFormat::chooseFormat).map(OpenApiFeature.QueryParameterRequestedFormat::mediaType).orElse((MediaType)mediaType);
        result = this.prepareDocument(resultMediaType);
        if (mediaType.test(MediaTypes.TEXT_HTML)) {
            result = this.embedInHtml(result);
        }
        this.preparedDocuments.put(resultMediaType, result);
        return result;
    }

    private String embedInHtml(String text) {
        return HTML_PREFIX + text + HTML_SUFFIX;
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends OpenApiUi>
    implements OpenApiUi.Builder<B, T> {
        private final Map<String, String> options = new HashMap<String, String>();
        private boolean isEnabled = true;
        private String webContext;
        private Function<MediaType, String> documentPreparer;
        private String openApiSupportWebContext;

        protected Builder() {
        }

        @Override
        public B options(Map<String, String> options) {
            this.options.putAll(options);
            return (B)((Builder)this.identity());
        }

        @Override
        public B isEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
            return (B)((Builder)this.identity());
        }

        @Override
        public B webContext(String webContext) {
            this.webContext = webContext;
            return (B)((Builder)this.identity());
        }

        @Override
        public B documentPreparer(Function<MediaType, String> documentPreparer) {
            this.documentPreparer = documentPreparer;
            return (B)((Builder)this.identity());
        }

        @Override
        public B openApiSupportWebContext(String openApiWebContext) {
            this.openApiSupportWebContext = openApiWebContext;
            return (B)((Builder)this.identity());
        }

        public String openApiSupportWebContext() {
            return this.openApiSupportWebContext;
        }

        public Function<MediaType, String> documentPreparer() {
            return this.documentPreparer;
        }

        protected Map<String, String> options() {
            return this.options;
        }
    }
}

