/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.openapi.ExpandedTypeDescription;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

final class CustomConstructor
extends Constructor {
    static final Map<Class<?>, ChildMapType<?, ?>> CHILD_MAP_TYPES = Map.of(APIResponses.class, new ChildMapType<APIResponses, APIResponse>(APIResponses.class, APIResponse.class, APIResponses::addAPIResponse, impl -> ExpandedTypeDescription.MapLikeTypeDescription.create(APIResponses.class, impl, APIResponse.class, APIResponses::addAPIResponse)), Callback.class, new ChildMapType<Callback, PathItem>(Callback.class, PathItem.class, Callback::addPathItem, impl -> ExpandedTypeDescription.MapLikeTypeDescription.create(Callback.class, impl, PathItem.class, Callback::addPathItem)), Content.class, new ChildMapType<Content, MediaType>(Content.class, MediaType.class, Content::addMediaType, impl -> ExpandedTypeDescription.MapLikeTypeDescription.create(Content.class, impl, MediaType.class, Content::addMediaType)), Paths.class, new ChildMapType<Paths, PathItem>(Paths.class, PathItem.class, Paths::addPathItem, impl -> ExpandedTypeDescription.MapLikeTypeDescription.create(Paths.class, impl, PathItem.class, Paths::addPathItem)));
    static final Map<Class<?>, ChildMapListType<?, ?>> CHILD_MAP_OF_LIST_TYPES = Map.of(SecurityRequirement.class, new ChildMapListType<SecurityRequirement, String>(SecurityRequirement.class, String.class, SecurityRequirement::addScheme, SecurityRequirement::addScheme, SecurityRequirement::addScheme, impl -> ExpandedTypeDescription.ListMapLikeTypeDescription.create(SecurityRequirement.class, impl, String.class, SecurityRequirement::addScheme, SecurityRequirement::addScheme, SecurityRequirement::addScheme)));
    private static final System.Logger LOGGER = System.getLogger(CustomConstructor.class.getName());

    CustomConstructor(TypeDescription td) {
        super(td, new LoaderOptions());
        this.yamlClassConstructors.put(NodeId.mapping, new ConstructMapping());
    }

    protected void constructMapping2ndStep(MappingNode node, Map<Object, Object> mapping) {
        Class parentType = node.getType();
        if (CHILD_MAP_TYPES.containsKey(parentType)) {
            Class childType = CustomConstructor.CHILD_MAP_TYPES.get((Object)parentType).childType;
            node.getValue().forEach(tuple -> {
                Node valueNode = tuple.getValueNode();
                if (valueNode.getType() == Object.class) {
                    valueNode.setType(childType);
                }
            });
        } else if (CHILD_MAP_OF_LIST_TYPES.containsKey(parentType)) {
            Class childType = CustomConstructor.CHILD_MAP_OF_LIST_TYPES.get((Object)parentType).childType;
            node.getValue().forEach(tuple -> {
                Node valueNode = tuple.getValueNode();
                if (valueNode.getNodeId() == NodeId.sequence) {
                    SequenceNode seqNode = (SequenceNode)valueNode;
                    seqNode.setListType(childType);
                }
            });
        }
        if (parentType.equals(APIResponses.class)) {
            this.convertIntHttpStatuses(node);
        }
        super.constructMapping2ndStep(node, mapping);
    }

    private void convertIntHttpStatuses(MappingNode node) {
        ArrayList numericHttpStatusMarks = new ArrayList();
        node.getValue().forEach(t -> {
            Node keyNode = t.getKeyNode();
            if (keyNode.getTag().equals((Object)Tag.INT)) {
                numericHttpStatusMarks.add(keyNode.getStartMark());
                keyNode.setTag(Tag.STR);
            }
        });
        if (!numericHttpStatusMarks.isEmpty()) {
            LOGGER.log(System.Logger.Level.WARNING, "Numeric HTTP status value(s) should be quoted. Please change the following; unquoted numeric values might be rejected in a future release: {0}", numericHttpStatusMarks);
        }
    }

    class ConstructMapping
    extends Constructor.ConstructMapping {
        ConstructMapping() {
            super((Constructor)CustomConstructor.this);
        }

        public Object construct(Node node) {
            Class parentType = node.getType();
            if (CHILD_MAP_TYPES.containsKey(parentType) || CHILD_MAP_OF_LIST_TYPES.containsKey(parentType)) {
                MappingNode mappingNode = (MappingNode)node;
                if (node.isTwoStepsConstruction()) {
                    return CustomConstructor.this.newMap(mappingNode);
                }
                return CustomConstructor.this.constructMapping(mappingNode);
            }
            return super.construct(node);
        }
    }

    record ChildMapType<P, C>(Class<P> parentType, Class<C> childType, ChildAdder<P, C> childAdder, Function<Class<?>, ExpandedTypeDescription.MapLikeTypeDescription<P, C>> typeDescriptionFactory) {
    }

    record ChildMapListType<P, C>(Class<P> parentType, Class<C> childType, ChildAdder<P, C> childAdder, ChildListAdder<P, C> childListAdder, ChildNameAdder<P> childNameAdder, Function<Class<?>, ExpandedTypeDescription.ListMapLikeTypeDescription<P, C>> typeDescriptionFunction) {
    }

    @FunctionalInterface
    static interface ChildAdder<P, C> {
        public Object addChild(P var1, String var2, C var3);
    }

    @FunctionalInterface
    static interface ChildNameAdder<P> {
        public P addChild(P var1, String var2);
    }

    @FunctionalInterface
    static interface ChildListAdder<P, C> {
        public Object addChildren(P var1, String var2, List<C> var3);
    }
}

