/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.smallrye.openapi.runtime.io.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public enum OpenAPIMediaType {
    JSON(Format.JSON, new MediaType[]{MediaTypes.APPLICATION_OPENAPI_JSON, MediaTypes.APPLICATION_JSON}, "json"),
    YAML(Format.YAML, new MediaType[]{MediaTypes.APPLICATION_OPENAPI_YAML, MediaTypes.APPLICATION_X_YAML, MediaTypes.APPLICATION_YAML, MediaTypes.TEXT_PLAIN, MediaTypes.TEXT_X_YAML, MediaTypes.TEXT_YAML}, "yaml", "yml");

    public static final OpenAPIMediaType DEFAULT_TYPE;
    static final String TYPE_LIST = "json|yaml|yml";
    private final Format format;
    private final List<String> fileTypes;
    private final List<MediaType> mediaTypes;

    private OpenAPIMediaType(Format format, MediaType[] mediaTypes, String ... fileTypes) {
        this.format = format;
        this.mediaTypes = Arrays.asList(mediaTypes);
        this.fileTypes = new ArrayList<String>(Arrays.asList(fileTypes));
    }

    public Format format() {
        return this.format;
    }

    public List<String> matchingTypes() {
        return this.fileTypes;
    }

    public static Optional<OpenAPIMediaType> byFileType(String fileType) {
        for (OpenAPIMediaType candidateType : OpenAPIMediaType.values()) {
            if (!candidateType.matchingTypes().contains(fileType)) continue;
            return Optional.of(candidateType);
        }
        return Optional.empty();
    }

    public static Optional<OpenAPIMediaType> byMediaType(MediaType mt) {
        for (OpenAPIMediaType candidateType : OpenAPIMediaType.values()) {
            if (!candidateType.mediaTypes.contains(mt)) continue;
            return Optional.of(candidateType);
        }
        return Optional.empty();
    }

    public static List<String> recognizedFileTypes() {
        ArrayList<String> result = new ArrayList<String>();
        for (OpenAPIMediaType type : OpenAPIMediaType.values()) {
            result.addAll(type.fileTypes);
        }
        return result;
    }

    public static MediaType[] preferredOrdering() {
        return new MediaType[]{MediaTypes.APPLICATION_OPENAPI_YAML, MediaTypes.APPLICATION_X_YAML, MediaTypes.APPLICATION_YAML, MediaTypes.APPLICATION_OPENAPI_JSON, MediaTypes.APPLICATION_JSON, MediaTypes.TEXT_X_YAML, MediaTypes.TEXT_YAML, MediaTypes.TEXT_PLAIN};
    }

    static {
        DEFAULT_TYPE = YAML;
    }
}

