/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.openapi.ExpandedTypeDescription;
import io.helidon.openapi.ImplTypeDescription;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.runtime.io.Format;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

class Serializer {
    private static final DumperOptions YAML_DUMPER_OPTIONS = new DumperOptions();
    private static final DumperOptions JSON_DUMPER_OPTIONS = new DumperOptions();
    private static final Logger LOGGER = Logger.getLogger(Serializer.class.getName());

    private Serializer() {
    }

    static void serialize(Map<Class<?>, ExpandedTypeDescription> types, Map<Class<?>, ExpandedTypeDescription> implsToTypes, OpenAPI openAPI, Format fmt, Writer writer) {
        if (fmt == Format.JSON) {
            Serializer.serialize(types, implsToTypes, openAPI, writer, JSON_DUMPER_OPTIONS, DumperOptions.ScalarStyle.DOUBLE_QUOTED);
        } else {
            Serializer.serialize(types, implsToTypes, openAPI, writer, YAML_DUMPER_OPTIONS, DumperOptions.ScalarStyle.PLAIN);
        }
    }

    private static void serialize(Map<Class<?>, ExpandedTypeDescription> types, Map<Class<?>, ExpandedTypeDescription> implsToTypes, OpenAPI openAPI, Writer writer, DumperOptions dumperOptions, DumperOptions.ScalarStyle stringStyle) {
        Yaml yaml = new Yaml((Representer)new CustomRepresenter(types, implsToTypes, dumperOptions, stringStyle), dumperOptions);
        yaml.dump((Object)openAPI, (Writer)new TagSuppressingWriter(writer));
    }

    static {
        YAML_DUMPER_OPTIONS.setIndent(2);
        YAML_DUMPER_OPTIONS.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        JSON_DUMPER_OPTIONS.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
        JSON_DUMPER_OPTIONS.setPrettyFlow(true);
        JSON_DUMPER_OPTIONS.setDefaultScalarStyle(DumperOptions.ScalarStyle.DOUBLE_QUOTED);
        JSON_DUMPER_OPTIONS.setSplitLines(false);
    }

    static class CustomRepresenter
    extends Representer {
        private static final String EXTENSIONS = "extensions";
        private final DumperOptions dumperOptions;
        private final DumperOptions.ScalarStyle stringStyle;
        private final Map<Class<?>, ExpandedTypeDescription> implsToTypes;

        CustomRepresenter(Map<Class<?>, ExpandedTypeDescription> types, Map<Class<?>, ExpandedTypeDescription> implsToTypes, DumperOptions dumperOptions, DumperOptions.ScalarStyle stringStyle) {
            this.implsToTypes = implsToTypes;
            this.dumperOptions = dumperOptions;
            this.stringStyle = stringStyle;
            types.values().stream().map(ImplTypeDescription::new).forEach(arg_0 -> ((CustomRepresenter)this).addTypeDescription(arg_0));
        }

        protected Node representScalar(Tag tag, String value, DumperOptions.ScalarStyle style) {
            return super.representScalar(tag, value, this.isExemptedFromQuotes(tag) ? DumperOptions.ScalarStyle.PLAIN : style);
        }

        protected Node representSequence(Tag tag, Iterable<?> sequence, DumperOptions.FlowStyle flowStyle) {
            Node result = super.representSequence(tag, sequence, flowStyle);
            this.representedObjects.clear();
            return result;
        }

        private boolean isExemptedFromQuotes(Tag tag) {
            return tag.equals((Object)Tag.BINARY) || tag.equals((Object)Tag.BOOL) || tag.equals((Object)Tag.FLOAT) || tag.equals((Object)Tag.INT);
        }

        protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
            if (propertyValue == null) {
                return null;
            }
            Property p = property;
            Object v = this.adjustPropertyValue(propertyValue);
            if (propertyValue instanceof Enum) {
                Enum e = (Enum)propertyValue;
                v = e.toString();
            }
            NodeTuple result = this.okToProcess(javaBean, property) ? this.doRepresentJavaBeanProperty(javaBean, p, v, customTag) : null;
            return result;
        }

        private NodeTuple doRepresentJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
            NodeTuple defaultTuple = super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
            if (javaBean instanceof Reference && property.getName().equals("ref")) {
                return new NodeTuple(this.representData("$ref"), defaultTuple.getValueNode());
            }
            if (javaBean instanceof Schema) {
                String propertyName = property.getName();
                if (propertyName.equals("additionalProperties")) {
                    return null;
                }
                if (propertyName.startsWith("additionalProperties")) {
                    return new NodeTuple(this.representData("additionalProperties"), defaultTuple.getValueNode());
                }
            }
            return defaultTuple;
        }

        private Object adjustPropertyValue(Object propertyValue) {
            if (Number.class.isInstance(propertyValue) && !Boolean.getBoolean("io.helidon.openapi.skipTCKWorkaround")) {
                Number n = (Number)propertyValue;
                float diff = n.floatValue() - (float)n.intValue();
                if (diff == 0.0f) {
                    propertyValue = n.intValue();
                } else if ((double)Math.abs(diff) < 0.1) {
                    LOGGER.warning(String.format("Integer approximation of %f did not match but the difference was only %e", n, Float.valueOf(diff)));
                }
            }
            return propertyValue;
        }

        protected MappingNode representJavaBean(Set<Property> properties, Object javaBean) {
            MappingNode result = super.representJavaBean(properties, javaBean);
            this.processExtensions(result, javaBean);
            this.representedObjects.clear();
            return result;
        }

        private void processExtensions(MappingNode node, Object javaBean) {
            if (!Extensible.class.isAssignableFrom(javaBean.getClass())) {
                return;
            }
            ArrayList tuples = new ArrayList(node.getValue());
            if (tuples.isEmpty()) {
                return;
            }
            ArrayList updatedTuples = new ArrayList();
            tuples.forEach(tuple -> {
                Node keyNode = tuple.getKeyNode();
                if (keyNode.getTag().equals((Object)Tag.STR)) {
                    String key = ((ScalarNode)keyNode).getValue();
                    if (key.equals(EXTENSIONS)) {
                        Node valueNode = tuple.getValueNode();
                        if (valueNode.getNodeId().equals((Object)NodeId.mapping)) {
                            MappingNode extensions = (MappingNode)MappingNode.class.cast(valueNode);
                            updatedTuples.addAll(extensions.getValue());
                        }
                    } else {
                        updatedTuples.add(tuple);
                    }
                } else {
                    updatedTuples.add(tuple);
                }
            });
            node.setValue(updatedTuples);
        }

        private boolean okToProcess(Object javaBean, Property property) {
            boolean reject = false;
            return !(reject |= Parameter.class.isAssignableFrom(javaBean.getClass()) && property.getName().equals("hidden"));
        }
    }

    static class TagSuppressingWriter
    extends PrintWriter {
        private static final Pattern SMALLRYE_IMPL_TAG_PATTERN = Pattern.compile("!!" + Pattern.quote(OpenAPIImpl.class.getPackage().getName()) + ".+$");

        TagSuppressingWriter(Writer out) {
            super(out);
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            int effLen = this.detag(CharBuffer.wrap(cbuf), off, len);
            if (effLen > 0) {
                super.write(cbuf, off, effLen);
            }
        }

        @Override
        public void write(String s, int off, int len) {
            int effLen = this.detag(s, off, len);
            if (effLen > 0) {
                super.write(s, off, effLen);
            }
        }

        private int detag(CharSequence cs, int off, int len) {
            int result = len;
            Matcher m = SMALLRYE_IMPL_TAG_PATTERN.matcher(cs.subSequence(off, off + len));
            if (m.matches()) {
                result = len - (m.end() - m.start());
            }
            return result;
        }
    }
}

