/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.config.Config;
import io.helidon.openapi.OpenAPISupport;
import io.helidon.openapi.SEOpenAPISupport;
import io.helidon.openapi.internal.OpenAPIConfigImpl;
import io.smallrye.openapi.api.OpenApiConfig;
import java.util.Objects;

public final class SEOpenAPISupportBuilder
extends OpenAPISupport.Builder<SEOpenAPISupportBuilder> {
    private final OpenAPIConfigImpl.Builder apiConfigBuilder = OpenAPIConfigImpl.builder();

    @Override
    public SEOpenAPISupportBuilder config(Config config) {
        super.config(config);
        this.apiConfigBuilder.config(config);
        return this;
    }

    public SEOpenAPISupport build() {
        SEOpenAPISupport result = new SEOpenAPISupport(this);
        this.validate();
        result.prepareModel();
        return result;
    }

    @Override
    public OpenApiConfig openAPIConfig() {
        return this.apiConfigBuilder.build();
    }

    public SEOpenAPISupportBuilder modelReader(String className) {
        Objects.requireNonNull(className, "modelReader class name must be non-null");
        this.apiConfigBuilder.modelReader(className);
        return this;
    }

    public SEOpenAPISupportBuilder filter(String className) {
        Objects.requireNonNull(className, "filter class name must be non-null");
        this.apiConfigBuilder.filter(className);
        return this;
    }

    public SEOpenAPISupportBuilder servers(String serverList) {
        Objects.requireNonNull(serverList, "serverList must be non-null");
        this.apiConfigBuilder.servers(serverList);
        return this;
    }

    public SEOpenAPISupportBuilder addOperationServer(String operationID, String operationServer) {
        Objects.requireNonNull(operationID, "operationID must be non-null");
        Objects.requireNonNull(operationServer, "operationServer must be non-null");
        this.apiConfigBuilder.addOperationServer(operationID, operationServer);
        return this;
    }

    public SEOpenAPISupportBuilder addPathServer(String path, String pathServer) {
        Objects.requireNonNull(path, "path must be non-null");
        Objects.requireNonNull(pathServer, "pathServer must be non-null");
        this.apiConfigBuilder.addPathServer(path, pathServer);
        return this;
    }
}

