/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.MethodProperty;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertySubstitute;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;

class ExpandedTypeDescription
extends TypeDescription {
    private static final String EXTENSION_PROPERTY_PREFIX = "x-";
    private static final PropertyUtils PROPERTY_UTILS = new PropertyUtils();
    private Class<?> impl;

    static ExpandedTypeDescription create(Class<? extends Object> clazz, Class<?> impl) {
        ExpandedTypeDescription result = clazz.equals(Schema.class) ? new SchemaTypeDescription(clazz, impl) : new ExpandedTypeDescription(clazz, impl);
        result.setPropertyUtils(PROPERTY_UTILS);
        return result;
    }

    private ExpandedTypeDescription(Class<? extends Object> clazz, Class<?> impl) {
        super(clazz, null, impl);
        this.impl = impl;
    }

    ExpandedTypeDescription addRef() {
        PropertySubstitute sub = new PropertySubstitute("ref", String.class, "getRef", "setRef", new Class[0]);
        sub.setTargetType(this.impl);
        this.substituteProperty(sub);
        return this;
    }

    ExpandedTypeDescription addExtensions() {
        PropertySubstitute sub = new PropertySubstitute("extensions", Map.class, "getExtensions", "setExtensions", new Class[0]);
        sub.setTargetType(this.impl);
        this.substituteProperty(sub);
        return this;
    }

    public Property getProperty(String name) {
        if (ExpandedTypeDescription.isExtension(name)) {
            return new ExtensionProperty(name);
        }
        if (ExpandedTypeDescription.isRef(name)) {
            return new RenamedProperty(this.getType(), "ref");
        }
        return super.getProperty(name);
    }

    Property getPropertyNoEx(String name) {
        try {
            Property p = this.getProperty("defaultValue");
            return p;
        }
        catch (YAMLException ex) {
            if (ex.getMessage().startsWith("Unable to find property")) {
                return null;
            }
            throw ex;
        }
    }

    public Object newInstance(String propertyName, Node node) {
        Property p = this.getProperty(propertyName);
        if (p.getType().isEnum()) {
            Class eClass = p.getType();
            String valueText = ((ScalarNode)ScalarNode.class.cast(node)).getValue();
            for (Enum e : (Enum[])eClass.getEnumConstants()) {
                if (!e.toString().equals(valueText)) continue;
                return e;
            }
        }
        return super.newInstance(propertyName, node);
    }

    public boolean setupPropertyType(String key, Node valueNode) {
        return ExpandedTypeDescription.setupExtensionType(key, valueNode) || super.setupPropertyType(key, valueNode);
    }

    void addExcludes(String ... propNames) {
        if (this.excludes == Collections.emptySet()) {
            this.excludes = new HashSet();
        }
        for (String propName : propNames) {
            this.excludes.add(propName);
        }
    }

    Class<?> impl() {
        return this.impl;
    }

    boolean hasDefaultProperty() {
        return this.getPropertyNoEx("defaultValue") != null;
    }

    private static boolean setupExtensionType(String key, Node valueNode) {
        if (ExpandedTypeDescription.isExtension(key)) {
            switch (valueNode.getNodeId()) {
                case sequence: {
                    valueNode.setType(List.class);
                    return true;
                }
                case anchor: {
                    break;
                }
                case mapping: {
                    valueNode.setType(Map.class);
                    return true;
                }
                case scalar: {
                    break;
                }
            }
        }
        return false;
    }

    private static boolean isExtension(String name) {
        return name.startsWith(EXTENSION_PROPERTY_PREFIX);
    }

    private static boolean isRef(String name) {
        return name.equals("$ref");
    }

    static class RenamedProperty
    extends MethodProperty {
        RenamedProperty(Class<?> c, String pojoName) {
            super(RenamedProperty.propertyDescriptor(c, pojoName));
        }

        private static PropertyDescriptor propertyDescriptor(Class<?> c, String pojoName) {
            try {
                return new PropertyDescriptor("ref", c, "getRef", "setRef");
            }
            catch (IntrospectionException e) {
                throw new YAMLException("Error describing property " + pojoName + " for class " + c.getName());
            }
        }
    }

    static class ExtensionProperty
    extends Property {
        private static final Class[] EXTENSION_TYPE_ARGS = new Class[0];

        ExtensionProperty(String name) {
            super(name, Object.class);
        }

        public Class<?>[] getActualTypeArguments() {
            return EXTENSION_TYPE_ARGS;
        }

        public void set(Object object, Object value) throws Exception {
            this.asExt(object).addExtension(this.getName(), value);
        }

        public Object get(Object object) {
            return this.asExt(object).getExtensions().get(this.getName());
        }

        public List<Annotation> getAnnotations() {
            return Collections.emptyList();
        }

        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return null;
        }

        private Extensible<?> asExt(Object object) {
            if (!(object instanceof Extensible)) {
                throw new IllegalArgumentException(String.format("Cannot assign extension %s to object of type %s that does not implement %s", this.getName(), object.getClass().getName(), Extensible.class.getName()));
            }
            return (Extensible)object;
        }
    }

    static final class SchemaTypeDescription
    extends ExpandedTypeDescription {
        private static final PropertyDescriptor ADDL_PROPS_PROP_DESCRIPTOR = SchemaTypeDescription.preparePropertyDescriptor();
        private static final Property ADDL_PROPS_PROPERTY = new MethodProperty(ADDL_PROPS_PROP_DESCRIPTOR){

            public void set(Object object, Object value) throws Exception {
                Schema s = (Schema)Schema.class.cast(object);
                if (value instanceof Schema) {
                    s.setAdditionalPropertiesSchema((Schema)value);
                } else {
                    s.setAdditionalPropertiesBoolean((Boolean)value);
                }
            }

            public Object get(Object object) {
                Schema s = (Schema)Schema.class.cast(object);
                Boolean b = s.getAdditionalPropertiesBoolean();
                return b != null ? b : s.getAdditionalPropertiesSchema();
            }
        };

        private static PropertyDescriptor preparePropertyDescriptor() {
            try {
                return new PropertyDescriptor("additionalProperties", Schema.class.getMethod("getAdditionalPropertiesSchema", new Class[0]), Schema.class.getMethod("setAdditionalPropertiesSchema", Schema.class));
            }
            catch (IntrospectionException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        private SchemaTypeDescription(Class<? extends Object> clazz, Class<?> impl) {
            super(clazz, impl);
        }

        @Override
        public Property getProperty(String name) {
            return name.equals("additionalProperties") ? ADDL_PROPS_PROPERTY : super.getProperty(name);
        }
    }
}

