/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.config.Config;
import io.helidon.media.common.MessageBodyReaderContext;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.media.jsonp.JsonpSupport;
import io.helidon.openapi.ExpandedTypeDescription;
import io.helidon.openapi.OpenAPIParser;
import io.helidon.openapi.SEOpenAPISupportBuilder;
import io.helidon.openapi.Serializer;
import io.helidon.openapi.SnakeYAMLParserHelper;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import io.helidon.webserver.cors.CorsEnabledServiceHelper;
import io.helidon.webserver.cors.CrossOriginConfig;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.jboss.jandex.IndexView;
import org.yaml.snakeyaml.TypeDescription;

public class OpenAPISupport
implements Service {
    public static final String DEFAULT_WEB_CONTEXT = "/openapi";
    public static final MediaType DEFAULT_RESPONSE_MEDIA_TYPE = MediaType.APPLICATION_OPENAPI_YAML;
    private static final Logger LOGGER = Logger.getLogger(OpenAPISupport.class.getName());
    private static final String DEFAULT_STATIC_FILE_PATH_PREFIX = "META-INF/openapi.";
    private static final String OPENAPI_EXPLICIT_STATIC_FILE_LOG_MESSAGE_FORMAT = "Using specified OpenAPI static file %s";
    private static final String OPENAPI_DEFAULTED_STATIC_FILE_LOG_MESSAGE_FORMAT = "Using default OpenAPI static file %s";
    private static final String FEATURE_NAME = "OpenAPI";
    private static final JsonReaderFactory JSON_READER_FACTORY = Json.createReaderFactory(Collections.emptyMap());
    private static SnakeYAMLParserHelper<ExpandedTypeDescription> helper = null;
    private final String webContext;
    private final OpenAPI model;
    private final ConcurrentMap<OpenApiSerializer.Format, String> cachedDocuments = new ConcurrentHashMap<OpenApiSerializer.Format, String>();
    private final Map<Class<?>, ExpandedTypeDescription> implsToTypes;
    private final CorsEnabledServiceHelper corsEnabledServiceHelper;

    private OpenAPISupport(Builder builder) {
        OpenAPISupport.adjustTypeDescriptions(OpenAPISupport.helper().types());
        this.implsToTypes = OpenAPISupport.buildImplsToTypes(OpenAPISupport.helper());
        this.webContext = builder.webContext();
        this.corsEnabledServiceHelper = CorsEnabledServiceHelper.create((String)FEATURE_NAME, (CrossOriginConfig)builder.crossOriginConfig);
        this.model = this.prepareModel(builder.openAPIConfig(), builder.staticFile(), builder.perAppFilteredIndexViews());
    }

    public void update(Routing.Rules rules) {
        this.configureEndpoint(rules);
    }

    public void configureEndpoint(Routing.Rules rules) {
        rules.get(new Handler[]{this::registerJsonpSupport}).any(this.webContext, new Handler[]{this.corsEnabledServiceHelper.processor()}).get(this.webContext, new Handler[]{this::prepareResponse});
    }

    private void registerJsonpSupport(ServerRequest req, ServerResponse res) {
        MessageBodyReaderContext readerContext = req.content().readerContext();
        MessageBodyWriterContext writerContext = res.writerContext();
        JsonpSupport.create().register(readerContext, writerContext);
        req.next();
    }

    static synchronized SnakeYAMLParserHelper<ExpandedTypeDescription> helper() {
        if (helper == null) {
            helper = SnakeYAMLParserHelper.create(ExpandedTypeDescription::create);
            OpenAPISupport.adjustTypeDescriptions(helper.types());
        }
        return helper;
    }

    static Map<Class<?>, ExpandedTypeDescription> buildImplsToTypes(SnakeYAMLParserHelper<ExpandedTypeDescription> helper) {
        return Collections.unmodifiableMap(helper.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toMap(ExpandedTypeDescription::impl, Function.identity())));
    }

    private static void adjustTypeDescriptions(Map<Class<?>, ExpandedTypeDescription> types) {
        ExpandedTypeDescription pathItemTD = types.get(PathItem.class);
        for (PathItem.HttpMethod m : PathItem.HttpMethod.values()) {
            pathItemTD.substituteProperty(m.name().toLowerCase(), Operation.class, OpenAPISupport.getter(m), OpenAPISupport.setter(m), new Class[0]);
            pathItemTD.addExcludes(m.name());
        }
        Set.of(Schema.class, ServerVariable.class).forEach(c -> {
            ExpandedTypeDescription tdWithEnumeration = (ExpandedTypeDescription)((Object)((Object)types.get(c)));
            tdWithEnumeration.substituteProperty("enum", List.class, "getEnumeration", "setEnumeration", new Class[0]);
            tdWithEnumeration.addPropertyParameters("enum", new Class[]{String.class});
            tdWithEnumeration.addExcludes("enumeration");
        });
        for (ExpandedTypeDescription td : types.values()) {
            if (Extensible.class.isAssignableFrom(td.getType())) {
                td.addExtensions();
            }
            if (td.hasDefaultProperty()) {
                td.substituteProperty("default", Object.class, "getDefaultValue", "setDefaultValue", new Class[0]);
                td.addExcludes("defaultValue");
            }
            if (!OpenAPISupport.isRef(td)) continue;
            td.addRef();
        }
    }

    private static boolean isRef(TypeDescription td) {
        for (Class<?> c : td.getType().getInterfaces()) {
            if (!c.equals(Reference.class)) continue;
            return true;
        }
        return false;
    }

    private static String getter(PathItem.HttpMethod method) {
        return OpenAPISupport.methodName("get", method);
    }

    private static String setter(PathItem.HttpMethod method) {
        return OpenAPISupport.methodName("set", method);
    }

    private static String methodName(String operation, PathItem.HttpMethod method) {
        return operation + method.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenAPI prepareModel(OpenApiConfig config, OpenApiStaticFile staticFile, List<FilteredIndexView> filteredIndexViews) {
        try {
            OpenApiDocument openApiDocument = OpenApiDocument.INSTANCE;
            synchronized (openApiDocument) {
                OpenApiDocument.INSTANCE.reset();
                OpenApiDocument.INSTANCE.config(config);
                OpenApiDocument.INSTANCE.modelFromReader((OpenAPI)OpenApiProcessor.modelFromReader((OpenApiConfig)config, (ClassLoader)OpenAPISupport.getContextClassLoader()));
                if (staticFile != null) {
                    OpenApiDocument.INSTANCE.modelFromStaticFile(OpenAPIParser.parse(OpenAPISupport.helper().types(), staticFile.getContent(), OpenAPIMediaType.byFormat(staticFile.getFormat())));
                }
                if (this.isAnnotationProcessingEnabled(config)) {
                    this.expandModelUsingAnnotations(config, filteredIndexViews);
                } else {
                    LOGGER.log(Level.FINE, "OpenAPI Annotation processing is disabled");
                }
                OpenApiDocument.INSTANCE.filter(OpenApiProcessor.getFilter((OpenApiConfig)config, (ClassLoader)OpenAPISupport.getContextClassLoader()));
                OpenApiDocument.INSTANCE.initialize();
                return OpenApiDocument.INSTANCE.get();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error initializing OpenAPI information", ex);
        }
    }

    private boolean isAnnotationProcessingEnabled(OpenApiConfig config) {
        return !config.scanDisable();
    }

    private void expandModelUsingAnnotations(OpenApiConfig config, List<FilteredIndexView> filteredIndexViews) {
        if (filteredIndexViews.isEmpty() || config.scanDisable()) {
            return;
        }
        AtomicReference<OpenAPIImpl> aggregateModelRef = new AtomicReference<OpenAPIImpl>(new OpenAPIImpl());
        filteredIndexViews.forEach(filteredIndexView -> {
            OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(config, (IndexView)filteredIndexView, List.of(new HelidonAnnotationScannerExtension()));
            OpenAPIImpl modelForApp = scanner.scan();
            aggregateModelRef.set(MergeUtil.merge((OpenAPIImpl)((OpenAPIImpl)aggregateModelRef.get()), (OpenAPIImpl)modelForApp));
        });
        OpenApiDocument.INSTANCE.modelFromAnnotations((OpenAPI)aggregateModelRef.get());
    }

    private static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static String typeFromPath(Path path) {
        Path staticFileNamePath = path.getFileName();
        if (staticFileNamePath == null) {
            throw new IllegalArgumentException("File path " + path.toAbsolutePath().toString() + " does not seem to have a file name value but one is expected");
        }
        String pathText = staticFileNamePath.toString();
        String specifiedFileType = pathText.substring(pathText.lastIndexOf(".") + 1);
        return specifiedFileType;
    }

    private void prepareResponse(ServerRequest req, ServerResponse resp) {
        try {
            MediaType resultMediaType = this.chooseResponseMediaType(req);
            String openAPIDocument = this.prepareDocument(resultMediaType);
            resp.status((Http.ResponseStatus)Http.Status.OK_200);
            resp.headers().add("Content-Type", new String[]{resultMediaType.toString()});
            resp.send((Object)openAPIDocument);
        }
        catch (Exception ex) {
            resp.status((Http.ResponseStatus)Http.Status.INTERNAL_SERVER_ERROR_500);
            resp.send((Object)"Error serializing OpenAPI document");
            LOGGER.log(Level.SEVERE, "Error serializing OpenAPI document", ex);
        }
    }

    String prepareDocument(MediaType resultMediaType) throws IOException {
        if (this.model == null) {
            throw new IllegalStateException("OpenAPI model used but has not been initialized");
        }
        OpenAPIMediaType matchingOpenAPIMediaType = OpenAPIMediaType.byMediaType(resultMediaType).orElseGet(() -> {
            LOGGER.log(Level.FINER, () -> String.format("Requested media type %s not supported; using default", resultMediaType.toString()));
            return OpenAPIMediaType.DEFAULT_TYPE;
        });
        OpenApiSerializer.Format resultFormat = matchingOpenAPIMediaType.format();
        String result = this.cachedDocuments.computeIfAbsent(resultFormat, fmt -> {
            String r = this.formatDocument((OpenApiSerializer.Format)fmt);
            LOGGER.log(Level.FINER, "Created and cached OpenAPI document in {0} format", fmt.toString());
            return r;
        });
        return result;
    }

    private String formatDocument(OpenApiSerializer.Format fmt) {
        StringWriter sw = new StringWriter();
        Serializer.serialize(OpenAPISupport.helper().types(), this.implsToTypes, this.model, fmt, sw);
        return sw.toString();
    }

    private MediaType chooseResponseMediaType(ServerRequest req) {
        Optional requestedMediaType = req.headers().bestAccepted(OpenAPIMediaType.preferredOrdering());
        MediaType resultMediaType = requestedMediaType.orElseGet(() -> {
            LOGGER.log(Level.FINER, () -> String.format("Did not recognize requested media type %s; responding with default %s", req.headers().acceptedTypes(), DEFAULT_RESPONSE_MEDIA_TYPE.toString()));
            return DEFAULT_RESPONSE_MEDIA_TYPE;
        });
        return resultMediaType;
    }

    public static Builder builder() {
        return OpenAPISupport.builderSE();
    }

    public static OpenAPISupport create() {
        return OpenAPISupport.builderSE().build();
    }

    public static OpenAPISupport create(Config config) {
        return OpenAPISupport.builderSE().config(config).build();
    }

    static SEOpenAPISupportBuilder builderSE() {
        return new SEOpenAPISupportBuilder();
    }

    public static abstract class Builder
    implements io.helidon.common.Builder<OpenAPISupport> {
        public static final String CONFIG_KEY = "openapi";
        private Optional<String> webContext = Optional.empty();
        private Optional<String> staticFilePath = Optional.empty();
        private CrossOriginConfig crossOriginConfig = null;

        public OpenAPISupport build() {
            this.validate();
            return new OpenAPISupport(this);
        }

        public Builder config(Config config) {
            config.get("web-context").asString().ifPresent(this::webContext);
            config.get("static-file").asString().ifPresent(this::staticFile);
            config.get("cors").as(CrossOriginConfig::create).ifPresent(this::crossOriginConfig);
            return this;
        }

        String webContext() {
            String webContextPath = this.webContext.orElse(OpenAPISupport.DEFAULT_WEB_CONTEXT);
            if (this.webContext.isPresent()) {
                LOGGER.log(Level.FINE, "OpenAPI path set to {0}", webContextPath);
            } else {
                LOGGER.log(Level.FINE, "OpenAPI path defaulting to {0}", webContextPath);
            }
            return webContextPath;
        }

        OpenApiStaticFile staticFile() {
            return this.staticFilePath.isPresent() ? this.getExplicitStaticFile() : this.getDefaultStaticFile();
        }

        public abstract OpenApiConfig openAPIConfig();

        public void validate() throws IllegalStateException {
        }

        public Builder webContext(String path) {
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            this.webContext = Optional.of(path);
            return this;
        }

        public Builder staticFile(String path) {
            Objects.requireNonNull(path, "path to static file must be non-null");
            this.staticFilePath = Optional.of(path);
            return this;
        }

        public Builder crossOriginConfig(CrossOriginConfig crossOriginConfig) {
            Objects.requireNonNull(crossOriginConfig, "CrossOriginConfig must be non-null");
            this.crossOriginConfig = crossOriginConfig;
            return this;
        }

        public abstract List<FilteredIndexView> perAppFilteredIndexViews();

        private OpenApiStaticFile getExplicitStaticFile() {
            BufferedInputStream is;
            Path path = Paths.get(this.staticFilePath.get(), new String[0]);
            String specifiedFileType = OpenAPISupport.typeFromPath(path);
            OpenAPIMediaType specifiedMediaType = OpenAPIMediaType.byFileType(specifiedFileType);
            if (specifiedMediaType == null) {
                throw new IllegalArgumentException("OpenAPI file path " + path.toAbsolutePath().toString() + " is not one of recognized types: " + OpenAPIMediaType.recognizedFileTypes());
            }
            try {
                is = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("OpenAPI file " + path.toAbsolutePath().toString() + " was specified but was not found", ex);
            }
            try {
                LOGGER.log(Level.FINE, () -> String.format(OpenAPISupport.OPENAPI_EXPLICIT_STATIC_FILE_LOG_MESSAGE_FORMAT, path.toAbsolutePath().toString()));
                return new OpenApiStaticFile((InputStream)is, specifiedMediaType.format());
            }
            catch (Exception ex) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ioex) {
                    ex.addSuppressed(ioex);
                }
                throw ex;
            }
        }

        private OpenApiStaticFile getDefaultStaticFile() {
            ArrayList<CallSite> candidatePaths = LOGGER.isLoggable(Level.FINER) ? new ArrayList<CallSite>() : null;
            for (OpenAPIMediaType candidate : OpenAPIMediaType.values()) {
                for (String type : candidate.matchingTypes()) {
                    String candidatePath = OpenAPISupport.DEFAULT_STATIC_FILE_PATH_PREFIX + type;
                    InputStream is = null;
                    try {
                        is = OpenAPISupport.getContextClassLoader().getResourceAsStream(candidatePath);
                        if (is != null) {
                            Path path = Paths.get(candidatePath, new String[0]);
                            LOGGER.log(Level.FINE, () -> String.format(OpenAPISupport.OPENAPI_DEFAULTED_STATIC_FILE_LOG_MESSAGE_FORMAT, path.toAbsolutePath().toString()));
                            return new OpenApiStaticFile(is, candidate.format());
                        }
                        if (candidatePaths == null) continue;
                        candidatePaths.add((CallSite)((Object)candidatePath));
                    }
                    catch (Exception ex) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException ioex) {
                                ex.addSuppressed(ioex);
                            }
                        }
                        throw ex;
                    }
                }
            }
            if (candidatePaths != null) {
                LOGGER.log(Level.FINER, candidatePaths.stream().collect(Collectors.joining("No default static OpenAPI description file found; checked [", ",", "]")));
            }
            return null;
        }
    }

    static enum OpenAPIMediaType {
        JSON(OpenApiSerializer.Format.JSON, new MediaType[]{MediaType.APPLICATION_OPENAPI_JSON, MediaType.APPLICATION_JSON}, "json"),
        YAML(OpenApiSerializer.Format.YAML, new MediaType[]{MediaType.APPLICATION_OPENAPI_YAML, MediaType.APPLICATION_X_YAML, MediaType.APPLICATION_YAML, MediaType.TEXT_PLAIN, MediaType.TEXT_X_YAML, MediaType.TEXT_YAML}, "yaml", "yml");

        private static final OpenAPIMediaType DEFAULT_TYPE;
        private final OpenApiSerializer.Format format;
        private final List<String> fileTypes;
        private final List<MediaType> mediaTypes;

        private OpenAPIMediaType(OpenApiSerializer.Format format, MediaType[] mediaTypes, String ... fileTypes) {
            this.format = format;
            this.mediaTypes = Arrays.asList(mediaTypes);
            this.fileTypes = new ArrayList<String>(Arrays.asList(fileTypes));
        }

        private OpenApiSerializer.Format format() {
            return this.format;
        }

        private List<String> matchingTypes() {
            return this.fileTypes;
        }

        private static OpenAPIMediaType byFileType(String fileType) {
            for (OpenAPIMediaType candidateType : OpenAPIMediaType.values()) {
                if (!candidateType.matchingTypes().contains(fileType)) continue;
                return candidateType;
            }
            return null;
        }

        private static Optional<OpenAPIMediaType> byMediaType(MediaType mt) {
            for (OpenAPIMediaType candidateType : OpenAPIMediaType.values()) {
                if (!candidateType.mediaTypes.contains(mt)) continue;
                return Optional.of(candidateType);
            }
            return Optional.empty();
        }

        private static List<String> recognizedFileTypes() {
            ArrayList<String> result = new ArrayList<String>();
            for (OpenAPIMediaType type : OpenAPIMediaType.values()) {
                result.addAll(type.fileTypes);
            }
            return result;
        }

        private static OpenAPIMediaType byFormat(OpenApiSerializer.Format format) {
            for (OpenAPIMediaType candidateType : OpenAPIMediaType.values()) {
                if (!candidateType.format.equals((Object)format)) continue;
                return candidateType;
            }
            return null;
        }

        private static MediaType[] preferredOrdering() {
            return new MediaType[]{MediaType.APPLICATION_OPENAPI_YAML, MediaType.APPLICATION_X_YAML, MediaType.APPLICATION_YAML, MediaType.APPLICATION_OPENAPI_JSON, MediaType.APPLICATION_JSON, MediaType.TEXT_X_YAML, MediaType.TEXT_YAML, MediaType.TEXT_PLAIN};
        }

        static {
            DEFAULT_TYPE = YAML;
        }
    }

    private static class HelidonAnnotationScannerExtension
    implements AnnotationScannerExtension {
        private HelidonAnnotationScannerExtension() {
        }

        public Object parseExtension(String key, String value) {
            if (value == null) {
                return null;
            }
            if ("true".equalsIgnoreCase(value = value.trim()) || "false".equalsIgnoreCase(value)) {
                return Boolean.valueOf(value);
            }
            switch (value.charAt(0)) {
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case '[': 
                case '{': {
                    try {
                        JsonReader reader = JSON_READER_FACTORY.createReader((Reader)new StringReader(value));
                        JsonValue jsonValue = reader.readValue();
                        return HelidonAnnotationScannerExtension.convertJsonValue(jsonValue);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.SEVERE, String.format("Error parsing extension key: %s, value: %s", key, value), ex);
                        break;
                    }
                }
            }
            return value;
        }

        private static Object convertJsonValue(JsonValue jsonValue) {
            switch (jsonValue.getValueType()) {
                case ARRAY: {
                    JsonArray jsonArray = jsonValue.asJsonArray();
                    return jsonArray.stream().map(HelidonAnnotationScannerExtension::convertJsonValue).collect(Collectors.toList());
                }
                case FALSE: {
                    return Boolean.FALSE;
                }
                case TRUE: {
                    return Boolean.TRUE;
                }
                case NULL: {
                    return null;
                }
                case STRING: {
                    return ((JsonString)JsonString.class.cast(jsonValue)).getString();
                }
                case NUMBER: {
                    JsonNumber jsonNumber = (JsonNumber)JsonNumber.class.cast(jsonValue);
                    return jsonNumber.numberValue();
                }
                case OBJECT: {
                    JsonObject jsonObject = jsonValue.asJsonObject();
                    return jsonObject.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> HelidonAnnotationScannerExtension.convertJsonValue((JsonValue)entry.getValue())));
                }
            }
            return jsonValue.toString();
        }
    }
}

