/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.config.Config;
import io.helidon.media.jsonp.server.JsonSupport;
import io.helidon.openapi.SEOpenAPISupportBuilder;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.IndexView;

public class OpenAPISupport
implements Service {
    public static final String DEFAULT_WEB_CONTEXT = "/openapi";
    public static final MediaType DEFAULT_RESPONSE_MEDIA_TYPE = MediaType.APPLICATION_OPENAPI_YAML;
    private static final Logger LOGGER = Logger.getLogger(OpenAPISupport.class.getName());
    private static final String DEFAULT_STATIC_FILE_PATH_PREFIX = "META-INF/openapi.";
    private static final String OPENAPI_EXPLICIT_STATIC_FILE_LOG_MESSAGE_FORMAT = "Using specified OpenAPI static file %s";
    private static final String OPENAPI_DEFAULTED_STATIC_FILE_LOG_MESSAGE_FORMAT = "Using default OpenAPI static file %s";
    private final String webContext;
    private final OpenAPI model;
    private final ConcurrentMap<OpenApiSerializer.Format, String> cachedDocuments = new ConcurrentHashMap<OpenApiSerializer.Format, String>();

    private OpenAPISupport(Builder builder) {
        this.webContext = builder.webContext();
        this.model = this.prepareModel(builder.openAPIConfig(), builder.indexView(), builder.staticFile());
    }

    public void update(Routing.Rules rules) {
        this.configureEndpoint(rules);
    }

    public void configureEndpoint(Routing.Rules rules) {
        rules.get(new Handler[]{JsonSupport.create()}).get(this.webContext, new Handler[]{this::prepareResponse});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenAPI prepareModel(OpenApiConfig config, IndexView indexView, OpenApiStaticFile staticFile) {
        try {
            OpenApiDocument openApiDocument = OpenApiDocument.INSTANCE;
            synchronized (openApiDocument) {
                OpenApiDocument.INSTANCE.reset();
                OpenApiDocument.INSTANCE.config(config);
                OpenApiDocument.INSTANCE.modelFromReader((OpenAPI)OpenApiProcessor.modelFromReader((OpenApiConfig)config, (ClassLoader)OpenAPISupport.getContextClassLoader()));
                OpenApiDocument.INSTANCE.modelFromStaticFile((OpenAPI)OpenApiProcessor.modelFromStaticFile((OpenApiStaticFile)staticFile));
                if (this.isAnnotationProcessingEnabled(config)) {
                    this.expandModelUsingAnnotations(config, indexView);
                } else {
                    LOGGER.log(Level.FINE, "OpenAPI Annotation processing is disabled");
                }
                OpenApiDocument.INSTANCE.filter(OpenApiProcessor.getFilter((OpenApiConfig)config, (ClassLoader)OpenAPISupport.getContextClassLoader()));
                OpenApiDocument.INSTANCE.initialize();
                return OpenApiDocument.INSTANCE.get();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error initializing OpenAPI information", ex);
        }
    }

    private boolean isAnnotationProcessingEnabled(OpenApiConfig config) {
        return !config.scanDisable();
    }

    private void expandModelUsingAnnotations(OpenApiConfig config, IndexView indexView) throws IOException {
        if (indexView != null) {
            OpenApiDocument.INSTANCE.modelFromAnnotations((OpenAPI)OpenApiProcessor.modelFromAnnotations((OpenApiConfig)config, (IndexView)new FilteredIndexView(indexView, config)));
        }
    }

    private static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static String typeFromPath(Path path) {
        Path staticFileNamePath = path.getFileName();
        if (staticFileNamePath == null) {
            throw new IllegalArgumentException("File path " + path.toAbsolutePath().toString() + " does not seem to have a file name value but one is expected");
        }
        String pathText = staticFileNamePath.toString();
        String specifiedFileType = pathText.substring(pathText.lastIndexOf(".") + 1);
        return specifiedFileType;
    }

    private void prepareResponse(ServerRequest req, ServerResponse resp) {
        try {
            MediaType resultMediaType = this.chooseResponseMediaType(req);
            String openAPIDocument = this.prepareDocument(resultMediaType);
            resp.status((Http.ResponseStatus)Http.Status.OK_200);
            resp.headers().add("Content-Type", new String[]{resultMediaType.toString()});
            resp.send((Object)openAPIDocument);
        }
        catch (IOException ex) {
            resp.status((Http.ResponseStatus)Http.Status.INTERNAL_SERVER_ERROR_500);
            resp.send((Object)"Error serializing OpenAPI document");
            LOGGER.log(Level.SEVERE, "Error serializing OpenAPI document", ex);
        }
    }

    String prepareDocument(MediaType resultMediaType) throws IOException {
        if (this.model == null) {
            throw new IllegalStateException("OpenAPI model used but has not been initialized");
        }
        OpenAPIMediaTypes matchingOpenAPIMediaType = OpenAPIMediaTypes.byMediaType(resultMediaType).orElseGet(() -> {
            LOGGER.log(Level.FINER, () -> String.format("Requested media type %s not supported; using default", resultMediaType.toString()));
            return OpenAPIMediaTypes.DEFAULT_TYPE;
        });
        OpenApiSerializer.Format resultFormat = matchingOpenAPIMediaType.format();
        String result = this.cachedDocuments.computeIfAbsent(resultFormat, fmt -> {
            String r = this.formatDocument((OpenApiSerializer.Format)fmt);
            LOGGER.log(Level.FINER, "Created and cached OpenAPI document in {0} format", fmt.toString());
            return r;
        });
        return result;
    }

    private String formatDocument(OpenApiSerializer.Format fmt) {
        try {
            return OpenApiSerializer.serialize((OpenAPI)this.model, (OpenApiSerializer.Format)fmt);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private MediaType chooseResponseMediaType(ServerRequest req) {
        Optional requestedMediaType = req.headers().bestAccepted(OpenAPIMediaTypes.preferredOrdering());
        MediaType resultMediaType = requestedMediaType.orElseGet(() -> {
            LOGGER.log(Level.FINER, () -> String.format("Did not recognize requested media type %s; responding with default %s", req.headers().acceptedTypes(), DEFAULT_RESPONSE_MEDIA_TYPE.toString()));
            return DEFAULT_RESPONSE_MEDIA_TYPE;
        });
        return resultMediaType;
    }

    public static Builder builder() {
        return OpenAPISupport.builderSE();
    }

    public static OpenAPISupport create() {
        return OpenAPISupport.builderSE().build();
    }

    public static OpenAPISupport create(Config config) {
        return OpenAPISupport.builderSE().helidonConfig(config).build();
    }

    public static SEOpenAPISupportBuilder builderSE() {
        return new SEOpenAPISupportBuilder();
    }

    public static abstract class Builder
    implements io.helidon.common.Builder<OpenAPISupport> {
        private Optional<String> webContext = Optional.empty();
        private Optional<String> staticFilePath = Optional.empty();

        public OpenAPISupport build() {
            this.validate();
            return new OpenAPISupport(this);
        }

        String webContext() {
            String webContextPath = this.webContext.orElse(OpenAPISupport.DEFAULT_WEB_CONTEXT);
            if (this.webContext.isPresent()) {
                LOGGER.log(Level.FINE, "OpenAPI path set to {0}", webContextPath);
            } else {
                LOGGER.log(Level.FINE, "OpenAPI path defaulting to {0}", webContextPath);
            }
            return webContextPath;
        }

        OpenApiStaticFile staticFile() {
            return this.staticFilePath.isPresent() ? this.getExplicitStaticFile() : this.getDefaultStaticFile();
        }

        public abstract OpenApiConfig openAPIConfig();

        public abstract IndexView indexView();

        public void validate() throws IllegalStateException {
        }

        public Builder webContext(String path) {
            this.webContext = Optional.of(path);
            return this;
        }

        public Builder staticFile(String path) {
            Objects.requireNonNull(path, "path to static file must be non-null");
            this.staticFilePath = Optional.of(path);
            return this;
        }

        private OpenApiStaticFile getExplicitStaticFile() {
            BufferedInputStream is;
            Path path = Paths.get(this.staticFilePath.get(), new String[0]);
            String specifiedFileType = OpenAPISupport.typeFromPath(path);
            OpenAPIMediaTypes specifiedMediaType = OpenAPIMediaTypes.byFileType(specifiedFileType);
            if (specifiedMediaType == null) {
                throw new IllegalArgumentException("OpenAPI file path " + path.toAbsolutePath().toString() + " is not one of recognized types: " + OpenAPIMediaTypes.recognizedFileTypes());
            }
            try {
                is = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("OpenAPI file " + path.toAbsolutePath().toString() + " was specified but was not found", ex);
            }
            try {
                LOGGER.log(Level.FINE, () -> String.format(OpenAPISupport.OPENAPI_EXPLICIT_STATIC_FILE_LOG_MESSAGE_FORMAT, path.toAbsolutePath().toString()));
                return new OpenApiStaticFile((InputStream)is, specifiedMediaType.format());
            }
            catch (Exception ex) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ioex) {
                    ex.addSuppressed(ioex);
                }
                throw ex;
            }
        }

        private OpenApiStaticFile getDefaultStaticFile() {
            ArrayList<String> candidatePaths = LOGGER.isLoggable(Level.FINER) ? new ArrayList<String>() : null;
            for (OpenAPIMediaTypes candidate : OpenAPIMediaTypes.values()) {
                for (String type : candidate.matchingTypes()) {
                    String candidatePath = OpenAPISupport.DEFAULT_STATIC_FILE_PATH_PREFIX + type;
                    InputStream is = null;
                    try {
                        is = OpenAPISupport.getContextClassLoader().getResourceAsStream(candidatePath);
                        if (is != null) {
                            Path path = Paths.get(candidatePath, new String[0]);
                            LOGGER.log(Level.FINE, () -> String.format(OpenAPISupport.OPENAPI_DEFAULTED_STATIC_FILE_LOG_MESSAGE_FORMAT, path.toAbsolutePath().toString()));
                            return new OpenApiStaticFile(is, candidate.format());
                        }
                        if (candidatePaths == null) continue;
                        candidatePaths.add(candidatePath);
                    }
                    catch (Exception ex) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException ioex) {
                                ex.addSuppressed(ioex);
                            }
                        }
                        throw ex;
                    }
                }
            }
            if (candidatePaths != null) {
                LOGGER.log(Level.FINER, candidatePaths.stream().collect(Collectors.joining("No default static OpenAPI description file found; checked [", ",", "]")));
            }
            return null;
        }
    }

    private static enum OpenAPIMediaTypes {
        JSON(OpenApiSerializer.Format.JSON, new MediaType[]{MediaType.APPLICATION_OPENAPI_JSON, MediaType.APPLICATION_JSON}, "json"),
        YAML(OpenApiSerializer.Format.YAML, new MediaType[]{MediaType.APPLICATION_OPENAPI_YAML, MediaType.APPLICATION_X_YAML, MediaType.APPLICATION_YAML, MediaType.TEXT_PLAIN, MediaType.TEXT_X_YAML, MediaType.TEXT_YAML}, "yaml", "yml");

        private static final OpenAPIMediaTypes DEFAULT_TYPE;
        private final OpenApiSerializer.Format format;
        private final List<String> fileTypes;
        private final List<MediaType> mediaTypes;

        private OpenAPIMediaTypes(OpenApiSerializer.Format format, MediaType[] mediaTypes, String ... fileTypes) {
            this.format = format;
            this.mediaTypes = Arrays.asList(mediaTypes);
            this.fileTypes = new ArrayList<String>(Arrays.asList(fileTypes));
        }

        private OpenApiSerializer.Format format() {
            return this.format;
        }

        private List<String> matchingTypes() {
            return this.fileTypes;
        }

        private static OpenAPIMediaTypes byFileType(String fileType) {
            for (OpenAPIMediaTypes candidateType : OpenAPIMediaTypes.values()) {
                if (!candidateType.matchingTypes().contains(fileType)) continue;
                return candidateType;
            }
            return null;
        }

        private static Optional<OpenAPIMediaTypes> byMediaType(MediaType mt) {
            for (OpenAPIMediaTypes candidateType : OpenAPIMediaTypes.values()) {
                if (!candidateType.mediaTypes.contains(mt)) continue;
                return Optional.of(candidateType);
            }
            return Optional.empty();
        }

        private static List<String> recognizedFileTypes() {
            ArrayList<String> result = new ArrayList<String>();
            for (OpenAPIMediaTypes type : OpenAPIMediaTypes.values()) {
                result.addAll(type.fileTypes);
            }
            return result;
        }

        private static MediaType[] preferredOrdering() {
            return new MediaType[]{MediaType.APPLICATION_OPENAPI_YAML, MediaType.APPLICATION_X_YAML, MediaType.APPLICATION_YAML, MediaType.APPLICATION_OPENAPI_JSON, MediaType.APPLICATION_JSON, MediaType.TEXT_PLAIN};
        }

        static {
            DEFAULT_TYPE = YAML;
        }
    }
}

