/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.tyrus;

import io.helidon.common.Weight;
import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataWriter;
import io.helidon.common.http.DirectHandler;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpPrologue;
import io.helidon.common.http.RequestException;
import io.helidon.common.http.WritableHeaders;
import io.helidon.common.uri.UriQuery;
import io.helidon.microprofile.tyrus.TyrusCdiExtension;
import io.helidon.microprofile.tyrus.TyrusConnection;
import io.helidon.microprofile.tyrus.TyrusRoute;
import io.helidon.microprofile.tyrus.TyrusRouting;
import io.helidon.nima.webserver.ConnectionContext;
import io.helidon.nima.webserver.Routing;
import io.helidon.nima.webserver.spi.ServerConnection;
import io.helidon.nima.websocket.webserver.WsUpgrader;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Extension;
import jakarta.websocket.WebSocketContainer;
import jakarta.websocket.server.ServerEndpointConfig;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusUpgradeResponse;
import org.glassfish.tyrus.core.TyrusWebSocketEngine;
import org.glassfish.tyrus.server.TyrusServerContainer;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.WebSocketEngine;

@Weight(value=200.0)
public class TyrusUpgrader
extends WsUpgrader {
    private static final System.Logger LOGGER = System.getLogger(TyrusUpgrader.class.getName());
    private final TyrusRouting tyrusRouting;
    private final WebSocketEngine engine;

    TyrusUpgrader(Set<String> origins) {
        super(origins);
        TyrusCdiExtension extension = (TyrusCdiExtension)CDI.current().select(TyrusCdiExtension.class, new Annotation[0]).get();
        Objects.requireNonNull(extension);
        this.tyrusRouting = extension.tyrusRouting();
        TyrusServerContainer tyrusServerContainer = this.initializeTyrus();
        this.engine = tyrusServerContainer.getWebSocketEngine();
    }

    public ServerConnection upgrade(ConnectionContext ctx, HttpPrologue prologue, WritableHeaders<?> headers) {
        if (!headers.contains(WS_KEY)) {
            return null;
        }
        String wsKey = headers.get(WS_KEY).value();
        String version = headers.contains(WS_VERSION) ? headers.get(WS_VERSION).value() : "13";
        if (!"13".equals(version)) {
            throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).message("Unsupported WebSocket Version").header(SUPPORTED_VERSION_HEADER).build();
        }
        String path = prologue.uriPath().path();
        UriQuery query = prologue.query();
        TyrusRoute route = ((TyrusRouting)ctx.router().routing(TyrusRouting.class, (Routing)this.tyrusRouting)).findRoute(prologue);
        if (route == null) {
            return null;
        }
        if (!this.anyOrigin() && headers.contains(Http.Header.ORIGIN)) {
            String origin = headers.get(Http.Header.ORIGIN).value();
            if (!this.origins().contains(origin)) {
                throw RequestException.builder().message("Invalid Origin").type(DirectHandler.EventType.FORBIDDEN).build();
            }
        }
        WebSocketEngine.UpgradeInfo upgradeInfo = this.protocolHandshake(headers, query, path);
        DataWriter dataWriter = ctx.dataWriter();
        String switchingProtocols = "HTTP/1.1 101 Switching Protocols\r\nConnection: Upgrade\r\nUpgrade: websocket\r\nSec-WebSocket-Accept: " + this.hash(ctx, wsKey) + "\r\n\r\n";
        dataWriter.write(BufferData.create((byte[])switchingProtocols.getBytes(StandardCharsets.US_ASCII)));
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, "Upgraded to websocket version " + version);
        }
        return new TyrusConnection(ctx, upgradeInfo);
    }

    TyrusServerContainer initializeTyrus() {
        Set allEndpointClasses = this.tyrusRouting.routes().stream().map(TyrusRoute::endpointClass).collect(Collectors.toSet());
        TyrusServerContainer tyrusServerContainer = new TyrusServerContainer(allEndpointClasses){
            private final WebSocketEngine engine;
            {
                this.engine = TyrusWebSocketEngine.builder((WebSocketContainer)this).build();
            }

            public void register(Class<?> endpointClass) {
                throw new UnsupportedOperationException("Cannot register endpoint class");
            }

            public void register(ServerEndpointConfig serverEndpointConfig) {
                throw new UnsupportedOperationException("Cannot register ServerEndpointConfig");
            }

            public Set<Extension> getInstalledExtensions() {
                return TyrusUpgrader.this.tyrusRouting.extensions();
            }

            public WebSocketEngine getWebSocketEngine() {
                return this.engine;
            }
        };
        WebSocketEngine engine = tyrusServerContainer.getWebSocketEngine();
        this.tyrusRouting.routes().forEach(route -> {
            try {
                if (route.serverEndpointConfig() != null) {
                    LOGGER.log(System.Logger.Level.DEBUG, () -> "Registering ws endpoint " + route.path() + route.serverEndpointConfig().getPath());
                    engine.register(route.serverEndpointConfig(), route.path());
                } else {
                    LOGGER.log(System.Logger.Level.DEBUG, () -> "Registering annotated ws endpoint " + route.path());
                    engine.register(route.endpointClass(), route.path());
                }
            }
            catch (DeploymentException e) {
                throw new RuntimeException(e);
            }
        });
        return tyrusServerContainer;
    }

    WebSocketEngine.UpgradeInfo protocolHandshake(WritableHeaders<?> headers, UriQuery uriQuery, String path) {
        LOGGER.log(System.Logger.Level.DEBUG, "Initiating WebSocket handshake with Tyrus...");
        HashMap<String, String[]> paramsMap = new HashMap<String, String[]>();
        for (String name : uriQuery.names()) {
            paramsMap.put(name, uriQuery.all(name).toArray(new String[0]));
        }
        RequestContext requestContext = RequestContext.Builder.create().requestURI(URI.create(path)).queryString(uriQuery.value()).parameterMap(paramsMap).build();
        headers.forEach(e -> requestContext.getHeaders().put(e.name(), List.of(e.values())));
        TyrusUpgradeResponse upgradeResponse = new TyrusUpgradeResponse();
        WebSocketEngine.UpgradeInfo upgradeInfo = this.engine.upgrade((UpgradeRequest)requestContext, (UpgradeResponse)upgradeResponse);
        upgradeResponse.getHeaders().forEach((key, value) -> headers.add(Http.Header.create((Http.HeaderName)Http.Header.createName((String)key, (String)key.toLowerCase(Locale.ROOT)), (List)value)));
        return upgradeInfo;
    }
}

