/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.tyrus;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataReader;
import io.helidon.nima.webserver.ConnectionContext;
import io.helidon.nima.webserver.spi.ServerConnection;
import io.helidon.nima.websocket.WsListener;
import io.helidon.nima.websocket.WsSession;
import jakarta.websocket.CloseReason;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.glassfish.tyrus.spi.CompletionHandler;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.WebSocketEngine;
import org.glassfish.tyrus.spi.Writer;

class TyrusConnection
implements ServerConnection,
WsSession {
    private static final System.Logger LOGGER = System.getLogger(TyrusConnection.class.getName());
    private final ConnectionContext ctx;
    private final WebSocketEngine.UpgradeInfo upgradeInfo;
    private final TyrusListener listener;

    TyrusConnection(ConnectionContext ctx, WebSocketEngine.UpgradeInfo upgradeInfo) {
        this.ctx = ctx;
        this.upgradeInfo = upgradeInfo;
        this.listener = new TyrusListener();
    }

    public void handle() {
        DataReader dataReader = this.ctx.dataReader();
        this.listener.onOpen(this);
        try {
            while (true) {
                BufferData buffer = dataReader.readBuffer();
                this.listener.receive((WsSession)this, buffer, true);
            }
        }
        catch (Exception e) {
            this.listener.onError(this, e);
            this.listener.onClose(this, 1011, e.getMessage());
            return;
        }
    }

    public WsSession send(String text, boolean last) {
        return this;
    }

    public WsSession send(BufferData bufferData, boolean last) {
        return this;
    }

    public WsSession ping(BufferData bufferData) {
        return this;
    }

    public WsSession pong(BufferData bufferData) {
        return this;
    }

    public WsSession close(int code, String reason) {
        return this;
    }

    public WsSession terminate() {
        return this;
    }

    public Optional<String> subProtocol() {
        return Optional.empty();
    }

    class TyrusListener
    implements WsListener {
        private static final int MAX_RETRIES = 5;
        private Connection connection;

        TyrusListener() {
        }

        public void receive(WsSession session, String text, boolean last) {
        }

        public void receive(WsSession session, BufferData buffer, boolean last) {
            byte[] b = new byte[buffer.available()];
            buffer.read(b);
            this.writeToTyrus(session, ByteBuffer.wrap(b));
        }

        public void onClose(WsSession session, int status, String reason) {
            this.connection.close(new CloseReason(CloseReason.CloseCodes.getCloseCode((int)status), reason));
        }

        public void onError(WsSession session, Throwable t) {
            this.connection.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, t.getMessage()));
        }

        public void onOpen(WsSession session) {
            Writer writer = new Writer(){

                public void close() {
                }

                public void write(ByteBuffer byteBuffer, CompletionHandler<ByteBuffer> completionHandler) {
                    byte[] b = new byte[byteBuffer.remaining()];
                    byteBuffer.get(b);
                    TyrusConnection.this.ctx.dataWriter().writeNow(BufferData.create((byte[])b));
                    completionHandler.completed((Object)byteBuffer);
                }
            };
            this.connection = TyrusConnection.this.upgradeInfo.createConnection(writer, TyrusListener::close);
        }

        private void writeToTyrus(WsSession session, ByteBuffer nioBuffer) {
            int retries = 5;
            while (nioBuffer.remaining() > 0 && retries-- > 0) {
                this.connection.getReadHandler().handle(nioBuffer);
            }
            if (retries == 0) {
                String reason = "Tyrus did not consume all data after 5 retries";
                this.connection.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, reason));
            }
        }

        private static void close(CloseReason closeReason) {
            LOGGER.log(System.Logger.Level.DEBUG, () -> "Connection closed: " + String.valueOf(closeReason));
        }
    }
}

