/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.tyrus;

import io.helidon.config.Config;
import io.helidon.microprofile.cdi.RuntimeStart;
import io.helidon.microprofile.server.RoutingName;
import io.helidon.microprofile.server.RoutingPath;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.microprofile.tyrus.TyrusApplication;
import io.helidon.microprofile.tyrus.TyrusRouting;
import io.helidon.nima.webserver.Routing;
import io.helidon.nima.webserver.WebServer;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.websocket.Endpoint;
import jakarta.websocket.Extension;
import jakarta.websocket.server.ServerApplicationConfig;
import jakarta.websocket.server.ServerEndpoint;
import jakarta.websocket.server.ServerEndpointConfig;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;

public class TyrusCdiExtension
implements jakarta.enterprise.inject.spi.Extension {
    private static final System.Logger LOGGER = System.getLogger(TyrusCdiExtension.class.getName());
    private static final String DEFAULT_WEBSOCKET_PATH = "/";
    private Config config;
    private ServerCdiExtension serverCdiExtension;
    private final TyrusApplication.Builder appBuilder = TyrusApplication.builder();
    private volatile TyrusRouting tyrusRouting;

    void prepareRuntime(@Observes @RuntimeStart Config config) {
        this.config = config;
    }

    void startServer(@Observes @Priority(value=4099) @Initialized(value=ApplicationScoped.class) Object event, BeanManager beanManager) {
        this.serverCdiExtension = (ServerCdiExtension)beanManager.getExtension(ServerCdiExtension.class);
        this.registerWebSockets();
    }

    void applicationClass(@Observes ProcessAnnotatedType<? extends ServerApplicationConfig> applicationClass) {
        LOGGER.log(System.Logger.Level.TRACE, () -> "Application class found " + String.valueOf(applicationClass.getAnnotatedType().getJavaClass()));
        this.appBuilder.applicationClass(applicationClass.getAnnotatedType().getJavaClass());
    }

    public void applicationClass(Class<? extends ServerApplicationConfig> applicationClass) {
        LOGGER.log(System.Logger.Level.TRACE, () -> "Using manually set application class  " + String.valueOf(applicationClass));
        this.appBuilder.updateApplicationClass(applicationClass);
    }

    void endpointClasses(@Observes @WithAnnotations(value={ServerEndpoint.class}) ProcessAnnotatedType<?> endpoint) {
        LOGGER.log(System.Logger.Level.TRACE, () -> "Annotated endpoint found " + String.valueOf(endpoint.getAnnotatedType().getJavaClass()));
        this.appBuilder.annotatedEndpoint(endpoint.getAnnotatedType().getJavaClass());
    }

    void endpointConfig(@Observes ProcessAnnotatedType<? extends Endpoint> endpoint) {
        LOGGER.log(System.Logger.Level.TRACE, () -> "Programmatic endpoint found " + String.valueOf(endpoint.getAnnotatedType().getJavaClass()));
        this.appBuilder.programmaticEndpoint(endpoint.getAnnotatedType().getJavaClass());
    }

    void extension(@Observes ProcessAnnotatedType<? extends Extension> extension) {
        LOGGER.log(System.Logger.Level.TRACE, () -> "Extension found " + String.valueOf(extension.getAnnotatedType().getJavaClass()));
        Class cls = extension.getAnnotatedType().getJavaClass();
        try {
            Extension instance = (Extension)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.appBuilder.extension(instance);
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(System.Logger.Level.WARNING, () -> "Extension does not have no-args constructor for " + String.valueOf(extension.getAnnotatedType().getJavaClass()) + "! Skipping.");
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Unable to load WebSocket extension", e);
        }
    }

    TyrusRouting tyrusRouting() {
        return this.tyrusRouting;
    }

    private void registerWebSockets() {
        block8: {
            try {
                TyrusApplication app = this.appBuilder.build();
                TyrusRouting.Builder tyrusRoutingBuilder = TyrusRouting.builder();
                Optional<Class<? extends ServerApplicationConfig>> appClass = app.applicationClass();
                Optional contextRoot = appClass.flatMap(c -> this.findContextRoot(this.config, (Class<? extends ServerApplicationConfig>)c));
                Optional<String> namedRouting = appClass.flatMap(c -> this.findNamedRouting(this.config, (Class<? extends ServerApplicationConfig>)c));
                boolean routingNameRequired = appClass.map(c -> this.isNamedRoutingRequired(this.config, (Class<? extends ServerApplicationConfig>)c)).orElse(false);
                String rootPath = contextRoot.orElse(DEFAULT_WEBSOCKET_PATH);
                LOGGER.log(System.Logger.Level.INFO, "Registering websocket application at " + rootPath);
                if (appClass.isPresent()) {
                    Class<? extends ServerApplicationConfig> c2 = appClass.get();
                    ServerApplicationConfig instance = null;
                    try {
                        instance = (ServerApplicationConfig)CDI.current().select(c2, new Annotation[0]).get();
                    }
                    catch (UnsatisfiedResolutionException unsatisfiedResolutionException) {
                        // empty catch block
                    }
                    if (instance == null) {
                        try {
                            instance = c2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Unable to instantiate websocket application " + String.valueOf(c2), e);
                        }
                    }
                    Set endpointConfigs = instance.getEndpointConfigs(app.programmaticEndpoints());
                    Set endpointClasses = instance.getAnnotatedEndpointClasses(app.annotatedEndpoints());
                    endpointClasses.forEach(cl -> tyrusRoutingBuilder.endpoint(rootPath, (Class<?>)cl));
                    endpointConfigs.forEach(cf -> tyrusRoutingBuilder.endpoint(rootPath, (ServerEndpointConfig)cf));
                    this.tyrusRouting = tyrusRoutingBuilder.build();
                    this.addWsRouting(this.tyrusRouting, namedRouting, routingNameRequired, c2.getName());
                    break block8;
                }
                app.annotatedEndpoints().forEach(cl -> tyrusRoutingBuilder.endpoint(rootPath, (Class<?>)cl));
                app.programmaticEndpoints().forEach(ep -> tyrusRoutingBuilder.endpoint(rootPath, (Class<?>)ep));
                app.extensions().forEach(tyrusRoutingBuilder::extension);
                this.tyrusRouting = tyrusRoutingBuilder.build();
                this.serverCdiExtension.serverBuilder().addRouting((Routing)this.tyrusRouting);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Unable to load WebSocket extension", e);
            }
        }
    }

    private void addWsRouting(TyrusRouting routing, Optional<String> namedRouting, boolean routingNameRequired, String appName) {
        WebServer.Builder serverBuilder = this.serverCdiExtension.serverBuilder();
        if (namedRouting.isPresent()) {
            String socket = namedRouting.get();
            if (!serverBuilder.hasSocket(socket)) {
                if (routingNameRequired) {
                    throw new IllegalStateException("Application " + appName + " requires routing " + socket + " to exist, yet such a socket is not configured for web server");
                }
                LOGGER.log(System.Logger.Level.INFO, "Routing " + socket + " does not exist, using default routing for application " + appName);
                serverBuilder.addRouting((Routing)routing);
            } else {
                serverBuilder.routerBuilder(socket).addRouting((Routing)routing);
            }
        } else {
            serverBuilder.addRouting((Routing)routing);
        }
    }

    private Optional<String> findContextRoot(Config config, Class<? extends ServerApplicationConfig> applicationClass) {
        return config.get(applicationClass.getName() + ".routing-path.path").asString().or(() -> Optional.ofNullable(applicationClass.getAnnotation(RoutingPath.class)).map(RoutingPath::value)).map(path -> path.startsWith(DEFAULT_WEBSOCKET_PATH) ? path : DEFAULT_WEBSOCKET_PATH + path);
    }

    private Optional<String> findNamedRouting(Config config, Class<? extends ServerApplicationConfig> applicationClass) {
        return config.get(applicationClass.getName() + ".routing-name.name").asString().or(() -> Optional.ofNullable(applicationClass.getAnnotation(RoutingName.class)).map(RoutingName::value)).flatMap(name -> "@default".equals(name) ? Optional.empty() : Optional.of(name));
    }

    private boolean isNamedRoutingRequired(Config config, Class<? extends ServerApplicationConfig> applicationClass) {
        return config.get(applicationClass.getName() + ".routing-name.required").asBoolean().or(() -> Optional.ofNullable(applicationClass.getAnnotation(RoutingName.class)).map(RoutingName::required)).orElse(false);
    }
}

