/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.tyrus;

import io.helidon.common.configurable.ThreadPoolSupplier;
import io.helidon.config.Config;
import io.helidon.microprofile.cdi.RuntimeStart;
import io.helidon.microprofile.server.RoutingName;
import io.helidon.microprofile.server.RoutingPath;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.microprofile.tyrus.WebSocketApplication;
import io.helidon.webserver.Routing;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.websocket.WebSocketRouting;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.websocket.Endpoint;
import jakarta.websocket.Extension;
import jakarta.websocket.server.ServerApplicationConfig;
import jakarta.websocket.server.ServerEndpoint;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;

public class WebSocketCdiExtension
implements jakarta.enterprise.inject.spi.Extension {
    private static final Logger LOGGER = Logger.getLogger(WebSocketCdiExtension.class.getName());
    private static final String DEFAULT_WEBSOCKET_PATH = "/";
    private Config config;
    private ServerCdiExtension serverCdiExtension;
    private final WebSocketApplication.Builder appBuilder = WebSocketApplication.builder();
    private ExecutorService executorService;

    void prepareRuntime(@Observes @RuntimeStart Config config) {
        this.config = config;
    }

    void startServer(@Observes @Priority(value=4099) @Initialized(value=ApplicationScoped.class) Object event, BeanManager beanManager) {
        this.serverCdiExtension = (ServerCdiExtension)beanManager.getExtension(ServerCdiExtension.class);
        this.registerWebSockets();
    }

    void applicationClass(@Observes ProcessAnnotatedType<? extends ServerApplicationConfig> applicationClass) {
        LOGGER.finest(() -> "Application class found " + applicationClass.getAnnotatedType().getJavaClass());
        this.appBuilder.applicationClass(applicationClass.getAnnotatedType().getJavaClass());
    }

    public void applicationClass(Class<? extends ServerApplicationConfig> applicationClass) {
        LOGGER.finest(() -> "Using manually set application class  " + applicationClass);
        this.appBuilder.updateApplicationClass(applicationClass);
    }

    void endpointClasses(@Observes @WithAnnotations(value={ServerEndpoint.class}) ProcessAnnotatedType<?> endpoint) {
        LOGGER.finest(() -> "Annotated endpoint found " + endpoint.getAnnotatedType().getJavaClass());
        this.appBuilder.annotatedEndpoint(endpoint.getAnnotatedType().getJavaClass());
    }

    void endpointConfig(@Observes ProcessAnnotatedType<? extends Endpoint> endpoint) {
        LOGGER.finest(() -> "Programmatic endpoint found " + endpoint.getAnnotatedType().getJavaClass());
        this.appBuilder.programmaticEndpoint(endpoint.getAnnotatedType().getJavaClass());
    }

    void extension(@Observes ProcessAnnotatedType<? extends Extension> extension) {
        LOGGER.finest(() -> "Extension found " + extension.getAnnotatedType().getJavaClass());
        Class cls = extension.getAnnotatedType().getJavaClass();
        try {
            Extension instance = (Extension)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.appBuilder.extension(instance);
        }
        catch (NoSuchMethodException e) {
            LOGGER.warning(() -> "Extension does not have no-args constructor for " + extension.getAnnotatedType().getJavaClass() + "! Skppping.");
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Unable to load WebSocket extension", e);
        }
    }

    WebSocketApplication toWebSocketApplication() {
        return this.appBuilder.build();
    }

    private void registerWebSockets() {
        block8: {
            try {
                WebSocketApplication app = this.toWebSocketApplication();
                WebSocketRouting.Builder wsRoutingBuilder = WebSocketRouting.builder();
                Optional<Class<? extends ServerApplicationConfig>> appClass = app.applicationClass();
                Optional contextRoot = appClass.flatMap(c -> this.findContextRoot(this.config, (Class<? extends ServerApplicationConfig>)c));
                Optional<String> namedRouting = appClass.flatMap(c -> this.findNamedRouting(this.config, (Class<? extends ServerApplicationConfig>)c));
                boolean routingNameRequired = appClass.map(c -> this.isNamedRoutingRequired(this.config, (Class<? extends ServerApplicationConfig>)c)).orElse(false);
                String rootPath = contextRoot.orElse(DEFAULT_WEBSOCKET_PATH);
                LOGGER.info("Registering websocket application at " + rootPath);
                this.executorService = ThreadPoolSupplier.builder().threadNamePrefix("helidon-websocket-").build().get();
                wsRoutingBuilder.executor(this.executorService);
                if (appClass.isPresent()) {
                    Class<? extends ServerApplicationConfig> c2 = appClass.get();
                    ServerApplicationConfig instance = null;
                    try {
                        instance = (ServerApplicationConfig)CDI.current().select(c2, new Annotation[0]).get();
                    }
                    catch (UnsatisfiedResolutionException unsatisfiedResolutionException) {
                        // empty catch block
                    }
                    if (instance == null) {
                        try {
                            instance = c2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Unable to instantiate websocket application " + c2, e);
                        }
                    }
                    Set endpointConfigs = instance.getEndpointConfigs(app.programmaticEndpoints());
                    Set endpointClasses = instance.getAnnotatedEndpointClasses(app.annotatedEndpoints());
                    endpointClasses.forEach(aClass -> wsRoutingBuilder.endpoint(rootPath, aClass));
                    endpointConfigs.forEach(wsCfg -> wsRoutingBuilder.endpoint(rootPath, wsCfg));
                    this.addWsRouting(wsRoutingBuilder.build(), namedRouting, routingNameRequired, c2.getName());
                    break block8;
                }
                app.annotatedEndpoints().forEach(aClass -> wsRoutingBuilder.endpoint(rootPath, aClass));
                app.programmaticEndpoints().forEach(wsCfg -> wsRoutingBuilder.endpoint(rootPath, wsCfg));
                app.extensions().forEach(arg_0 -> ((WebSocketRouting.Builder)wsRoutingBuilder).extension(arg_0));
                this.serverCdiExtension.serverBuilder().addRouting((Routing)wsRoutingBuilder.build());
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Unable to load WebSocket extension", e);
            }
        }
    }

    void terminate(@Observes @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        this.executorService.shutdown();
    }

    private void addWsRouting(WebSocketRouting routing, Optional<String> namedRouting, boolean routingNameRequired, String appName) {
        WebServer.Builder serverBuilder = this.serverCdiExtension.serverBuilder();
        if (namedRouting.isPresent()) {
            String socket = namedRouting.get();
            if (!serverBuilder.hasSocket(socket)) {
                if (routingNameRequired) {
                    throw new IllegalStateException("Application " + appName + " requires routing " + socket + " to exist, yet such a socket is not configured for web server");
                }
                LOGGER.info("Routing " + socket + " does not exist, using default routing for application " + appName);
                serverBuilder.addRouting((Routing)routing);
            } else {
                serverBuilder.addNamedRouting(socket, (Routing)routing);
            }
        } else {
            serverBuilder.addRouting((Routing)routing);
        }
    }

    private Optional<String> findContextRoot(Config config, Class<? extends ServerApplicationConfig> applicationClass) {
        return config.get(applicationClass.getName() + ".routing-path.path").asString().or(() -> Optional.ofNullable(applicationClass.getAnnotation(RoutingPath.class)).map(RoutingPath::value)).map(path -> path.startsWith(DEFAULT_WEBSOCKET_PATH) ? path : DEFAULT_WEBSOCKET_PATH + path);
    }

    private Optional<String> findNamedRouting(Config config, Class<? extends ServerApplicationConfig> applicationClass) {
        return config.get(applicationClass.getName() + ".routing-name.name").asString().or(() -> Optional.ofNullable(applicationClass.getAnnotation(RoutingName.class)).map(RoutingName::value)).flatMap(name -> "@default".equals(name) ? Optional.empty() : Optional.of(name));
    }

    private boolean isNamedRoutingRequired(Config config, Class<? extends ServerApplicationConfig> applicationClass) {
        return config.get(applicationClass.getName() + ".routing-name.required").asBoolean().or(() -> Optional.ofNullable(applicationClass.getAnnotation(RoutingName.class)).map(RoutingName::required)).orElse(false);
    }
}

