/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.tyrus;

import io.helidon.common.HelidonFeatures;
import io.helidon.common.HelidonFlavor;
import io.helidon.config.Config;
import io.helidon.microprofile.cdi.RuntimeStart;
import io.helidon.microprofile.server.RoutingName;
import io.helidon.microprofile.server.RoutingPath;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.microprofile.tyrus.TyrusSupportMp;
import io.helidon.microprofile.tyrus.WebSocketApplication;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerConfiguration;
import io.helidon.webserver.Service;
import io.helidon.webserver.tyrus.TyrusSupport;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpoint;

public class WebSocketCdiExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(WebSocketCdiExtension.class.getName());
    private static final String DEFAULT_WEBSOCKET_PATH = "/websocket";
    private Config config;
    private ServerCdiExtension serverCdiExtension;
    private WebSocketApplication.Builder appBuilder = WebSocketApplication.builder();

    private void prepareRuntime(@Observes @RuntimeStart Config config) {
        this.config = config;
    }

    private void startServer(@Observes @Priority(value=4099) @Initialized(value=ApplicationScoped.class) Object event, BeanManager beanManager) {
        this.serverCdiExtension = (ServerCdiExtension)beanManager.getExtension(ServerCdiExtension.class);
        this.registerWebSockets(beanManager, this.serverCdiExtension.serverConfigBuilder().build());
    }

    private void applicationClass(@Observes ProcessAnnotatedType<? extends ServerApplicationConfig> applicationClass) {
        LOGGER.finest(() -> "Application class found " + applicationClass.getAnnotatedType().getJavaClass());
        this.appBuilder.applicationClass(applicationClass.getAnnotatedType().getJavaClass());
    }

    public void applicationClass(Class<? extends ServerApplicationConfig> applicationClass) {
        LOGGER.finest(() -> "Using manually set application class  " + applicationClass);
        this.appBuilder.updateApplicationClass(applicationClass);
    }

    private void endpointClasses(@Observes @WithAnnotations(value={ServerEndpoint.class}) ProcessAnnotatedType<?> endpoint) {
        LOGGER.finest(() -> "Annotated endpoint found " + endpoint.getAnnotatedType().getJavaClass());
        this.appBuilder.annotatedEndpoint(endpoint.getAnnotatedType().getJavaClass());
    }

    private void endpointConfig(@Observes ProcessAnnotatedType<? extends Endpoint> endpoint) {
        LOGGER.finest(() -> "Programmatic endpoint found " + endpoint.getAnnotatedType().getJavaClass());
        this.appBuilder.programmaticEndpoint(endpoint.getAnnotatedType().getJavaClass());
    }

    WebSocketApplication toWebSocketApplication() {
        return this.appBuilder.build();
    }

    private void registerWebSockets(BeanManager beanManager, ServerConfiguration serverConfig) {
        try {
            Routing.Builder routing;
            WebSocketApplication app = this.toWebSocketApplication();
            TyrusSupport.Builder builder = TyrusSupport.builder();
            Optional<Class<? extends ServerApplicationConfig>> appClass = app.applicationClass();
            Optional contextRoot = appClass.flatMap(c -> this.findContextRoot(this.config, (Class<? extends ServerApplicationConfig>)c));
            Optional namedRouting = appClass.flatMap(c -> this.findNamedRouting(this.config, (Class<? extends ServerApplicationConfig>)c));
            boolean routingNameRequired = appClass.map(c -> this.isNamedRoutingRequired(this.config, (Class<? extends ServerApplicationConfig>)c)).orElse(false);
            if (appClass.isPresent()) {
                Class<? extends ServerApplicationConfig> c2 = appClass.get();
                ServerApplicationConfig instance = null;
                try {
                    instance = (ServerApplicationConfig)CDI.current().select(c2, new Annotation[0]).get();
                }
                catch (UnsatisfiedResolutionException unsatisfiedResolutionException) {
                    // empty catch block
                }
                if (instance == null) {
                    try {
                        instance = c2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to instantiate websocket application " + c2, e);
                    }
                }
                Set endpointConfigs = instance.getEndpointConfigs(app.programmaticEndpoints());
                Set endpointClasses = instance.getAnnotatedEndpointClasses(app.annotatedEndpoints());
                endpointClasses.forEach(arg_0 -> ((TyrusSupport.Builder)builder).register(arg_0));
                endpointConfigs.forEach(arg_0 -> ((TyrusSupport.Builder)builder).register(arg_0));
                routing = this.serverCdiExtension.routingBuilder(namedRouting, routingNameRequired, serverConfig, c2.getName());
            } else {
                app.annotatedEndpoints().forEach(arg_0 -> ((TyrusSupport.Builder)builder).register(arg_0));
                app.programmaticEndpoints().forEach(arg_0 -> ((TyrusSupport.Builder)builder).register(arg_0));
                routing = this.serverCdiExtension.serverRoutingBuilder();
            }
            String rootPath = contextRoot.orElse(DEFAULT_WEBSOCKET_PATH);
            LOGGER.info("Registering websocket application at " + rootPath);
            routing.register(rootPath, new Service[]{new TyrusSupportMp(builder.build())});
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Unable to load WebSocket extension", e);
        }
    }

    private Optional<String> findContextRoot(Config config, Class<? extends ServerApplicationConfig> applicationClass) {
        return config.get(applicationClass.getName() + ".routing-path.path").asString().or(() -> Optional.ofNullable(applicationClass.getAnnotation(RoutingPath.class)).map(RoutingPath::value)).map(path -> path.startsWith("/") ? path : "/" + path);
    }

    private Optional<String> findNamedRouting(Config config, Class<? extends ServerApplicationConfig> applicationClass) {
        return config.get(applicationClass.getName() + ".routing-name.name").asString().or(() -> Optional.ofNullable(applicationClass.getAnnotation(RoutingName.class)).map(RoutingName::value)).flatMap(name -> "@default".equals(name) ? Optional.empty() : Optional.of(name));
    }

    private boolean isNamedRoutingRequired(Config config, Class<? extends ServerApplicationConfig> applicationClass) {
        return config.get(applicationClass.getName() + ".routing-name.required").asBoolean().or(() -> Optional.ofNullable(applicationClass.getAnnotation(RoutingName.class)).map(RoutingName::required)).orElse(false);
    }

    static {
        HelidonFeatures.register((HelidonFlavor)HelidonFlavor.MP, (String[])new String[]{"WebSocket"});
    }
}

