/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing;

import io.helidon.microprofile.testing.HelidonTestScoped;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public abstract sealed class HelidonTestScope
implements Context {
    public static HelidonTestScope ofThread() {
        return new PerThread();
    }

    public static HelidonTestScope ofContainer() {
        return new PerContainer();
    }

    public Class<? extends Annotation> getScope() {
        return HelidonTestScoped.class;
    }

    public boolean isActive() {
        return true;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> context) {
        return this.instances().get(contextual, context);
    }

    public <T> T get(Contextual<T> contextual) {
        return this.instances().get(contextual).orElse(null);
    }

    public void close() {
        this.instances().destroy();
    }

    abstract Instances instances();

    static final class PerThread
    extends HelidonTestScope {
        private static final ThreadLocal<Instances> THREAD_LOCAL = ThreadLocal.withInitial(Instances::new);

        PerThread() {
        }

        @Override
        Instances instances() {
            return THREAD_LOCAL.get();
        }

        @Override
        public void close() {
            THREAD_LOCAL.remove();
            super.close();
        }
    }

    static final class PerContainer
    extends HelidonTestScope {
        private final Instances instances = new Instances(new ConcurrentHashMap());

        PerContainer() {
        }

        @Override
        Instances instances() {
            return this.instances;
        }
    }

    private record Instances(Map<Contextual<?>, Instance<?>> map) {
        Instances() {
            this(new HashMap());
        }

        <T> Instance<T> create(Contextual<T> contextual, CreationalContext<T> context) {
            return this.map.computeIfAbsent(contextual, k -> new Instance((Bean)k, context));
        }

        <T> T get(Contextual<T> contextual, CreationalContext<T> context) {
            return (T)this.get(contextual).orElseGet(() -> this.create(contextual, context).it);
        }

        <T> Optional<T> get(Contextual<T> contextual) {
            return Optional.ofNullable(this.map.get(contextual)).map(Instance::it);
        }

        void destroy() {
            this.map.values().forEach(Instance::destroy);
        }
    }

    private record Instance<T>(Bean<T> bean, CreationalContext<T> context, T it) {
        Instance(Bean<T> bean, CreationalContext<T> context) {
            this(bean, context, bean.create(context));
        }

        void destroy() {
            this.bean.destroy(this.it, this.context);
        }
    }
}

