/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing;

import io.helidon.microprofile.testing.AddBean;
import io.helidon.microprofile.testing.AddConfig;
import io.helidon.microprofile.testing.AddConfigBlock;
import io.helidon.microprofile.testing.AddExtension;
import io.helidon.microprofile.testing.Configuration;
import io.helidon.microprofile.testing.HelidonTestDescriptor;
import io.helidon.microprofile.testing.HelidonTestDescriptorDelegate;
import io.helidon.microprofile.testing.HelidonTestDescriptorImpl;
import io.helidon.microprofile.testing.Instrumented;
import io.helidon.microprofile.testing.PrettyPrinter;
import io.helidon.microprofile.testing.PrettyPrinters;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public sealed interface HelidonTestInfo<T extends AnnotatedElement>
extends HelidonTestDescriptor<T> {
    public static ClassInfo classInfo(Class<?> cls) {
        return HelidonTestInfo.classInfo(cls, HelidonTestDescriptorImpl::new);
    }

    public static ClassInfo classInfo(Class<?> cls, Function<Class<?>, HelidonTestDescriptor<Class<?>>> function) {
        Class<?> theClass = Instrumented.isInstrumented(cls) ? cls.getSuperclass() : cls;
        return (ClassInfo)ClassInfo.CACHE.compute(theClass.getName(), (e, r) -> {
            if (r == null || r.get() == null) {
                return new SoftReference<ClassInfo>(new ClassInfo((HelidonTestDescriptor)function.apply(cls)));
            }
            return r;
        }).get();
    }

    public static ClassInfo classInfo(HelidonTestDescriptor<Class<?>> desc) {
        return (ClassInfo)ClassInfo.CACHE.compute(desc.element().getName(), (e, r) -> {
            if (r == null || r.get() == null) {
                return new SoftReference<ClassInfo>(new ClassInfo(desc));
            }
            return r;
        }).get();
    }

    public static MethodInfo methodInfo(Method element, ClassInfo classInfo) {
        return HelidonTestInfo.methodInfo(element, classInfo, HelidonTestDescriptorImpl::new);
    }

    public static MethodInfo methodInfo(Method method, ClassInfo classInfo, Function<Method, HelidonTestDescriptor<Method>> function) {
        return (MethodInfo)MethodInfo.CACHE.compute(MethodInfo.cacheKey(method, classInfo), (e, r) -> {
            if (r == null || r.get() == null) {
                return new SoftReference<MethodInfo>(new MethodInfo((HelidonTestDescriptor)function.apply(method), classInfo));
            }
            return r;
        }).get();
    }

    public static MethodInfo methodInfo(HelidonTestDescriptor<Method> desc, ClassInfo classInfo) {
        return (MethodInfo)MethodInfo.CACHE.compute(MethodInfo.cacheKey(desc.element(), classInfo), (e, r) -> {
            if (r == null || r.get() == null) {
                return new SoftReference<MethodInfo>(new MethodInfo(desc, classInfo));
            }
            return r;
        }).get();
    }

    public String id();

    public Class<?> testClass();

    default public Optional<Method> testMethod() {
        return Optional.empty();
    }

    public ClassInfo classInfo();

    default public boolean requiresReset() {
        return false;
    }

    public static final class ClassInfo
    extends HelidonTestDescriptorDelegate<Class<?>>
    implements HelidonTestInfo<Class<?>> {
        private static final Map<String, SoftReference<ClassInfo>> CACHE = new ConcurrentHashMap<String, SoftReference<ClassInfo>>();

        private ClassInfo(HelidonTestDescriptor<Class<?>> descriptor) {
            super(descriptor);
        }

        @Override
        public String id() {
            return ((Class)this.element()).getName();
        }

        @Override
        public Class<?> testClass() {
            return (Class)this.element();
        }

        @Override
        public ClassInfo classInfo() {
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassInfo)) {
                return false;
            }
            ClassInfo that = (ClassInfo)o;
            return Objects.equals(((Class)this.element()).getName(), ((Class)that.element()).getName());
        }

        public int hashCode() {
            return ((Class)this.element()).getName().hashCode();
        }

        public String toString() {
            return new PrettyPrinter().object(PrettyPrinters.classInfo(this)).toString();
        }
    }

    public static final class MethodInfo
    implements HelidonTestInfo<Method> {
        private static final Map<String, SoftReference<MethodInfo>> CACHE = new ConcurrentHashMap<String, SoftReference<MethodInfo>>();
        private final HelidonTestDescriptor<Method> descriptor;
        private final ClassInfo classInfo;

        private MethodInfo(HelidonTestDescriptor<Method> descriptor, ClassInfo classInfo) {
            this.descriptor = descriptor;
            this.classInfo = classInfo;
        }

        private static String cacheKey(Method method, ClassInfo classInfo) {
            return ((Class)classInfo.element()).getName() + "#" + method.getName() + Arrays.stream(method.getParameterTypes()).map(Type::getTypeName).collect(Collectors.joining(",", "(", ")"));
        }

        @Override
        public String id() {
            return this.classInfo.id() + "#" + this.element().getName();
        }

        @Override
        public Class<?> testClass() {
            return (Class)this.classInfo.element();
        }

        @Override
        public Optional<Method> testMethod() {
            return Optional.of(this.descriptor.element());
        }

        @Override
        public ClassInfo classInfo() {
            return this.classInfo;
        }

        @Override
        public Method element() {
            return this.descriptor.element();
        }

        @Override
        public List<AddExtension> addExtensions() {
            return MethodInfo.concat(this.classInfo.addExtensions(), this.descriptor.addExtensions());
        }

        @Override
        public List<AddBean> addBeans() {
            return MethodInfo.concat(this.classInfo.addBeans(), this.descriptor.addBeans());
        }

        @Override
        public boolean addJaxRs() {
            return this.classInfo.addJaxRs() || this.descriptor.addJaxRs();
        }

        @Override
        public boolean disableDiscovery() {
            return this.classInfo.disableDiscovery() || this.descriptor.disableDiscovery();
        }

        @Override
        public Optional<Configuration> configuration() {
            return this.descriptor.configuration();
        }

        @Override
        public List<AddConfig> addConfigs() {
            return MethodInfo.concat(this.classInfo.addConfigs(), this.descriptor.addConfigs());
        }

        @Override
        public List<AddConfigBlock> addConfigBlocks() {
            return MethodInfo.concat(this.classInfo.addConfigBlocks(), this.descriptor.addConfigBlocks());
        }

        @Override
        public List<Method> addConfigSources() {
            return this.classInfo.addConfigSources();
        }

        @Override
        public <A extends Annotation, C extends Annotation> Stream<A> annotations(Class<A> aType, Class<C> cType, Function<C, A[]> function) {
            return Stream.concat(this.descriptor.annotations(aType, cType, function), this.classInfo.annotations((Class)aType, (Class)cType, (Function)function));
        }

        @Override
        public <A extends Annotation> Stream<A> annotations(Class<A> aType) {
            return Stream.concat(this.descriptor.annotations(aType), this.classInfo.annotations((Class)aType));
        }

        @Override
        public boolean requiresReset() {
            return this.classInfo.resetPerTest() || this.descriptor.configuration().isPresent() || this.descriptor.disableDiscovery() || this.descriptor.addJaxRs() || !this.descriptor.addBeans().isEmpty() || !this.descriptor.addExtensions().isEmpty() || !this.descriptor.addConfigs().isEmpty() || !this.descriptor.addConfigBlocks().isEmpty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodInfo)) {
                return false;
            }
            MethodInfo that = (MethodInfo)o;
            return Objects.equals(this.element().getName(), that.element().getName());
        }

        public int hashCode() {
            return this.element().hashCode();
        }

        public String toString() {
            return new PrettyPrinter().object(PrettyPrinters.methodInfo(this)).toString();
        }

        private static <T> List<T> concat(List<T> l1, List<T> l2) {
            return Stream.concat(l1.stream(), l2.stream()).toList();
        }
    }
}

