/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing;

import io.helidon.microprofile.testing.ReflectionHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.function.Function;

public class Proxies {
    private Proxies() {
    }

    public static <T extends Annotation> T mirror(Class<T> type, Annotation annotation) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Object o = Proxy.newProxyInstance(cl, new Class[]{type}, (proxy, method, args) -> {
            Method sourceMethod = annotation.getClass().getMethod(method.getName(), new Class[0]);
            return ReflectionHelper.invoke(Object.class, sourceMethod, annotation, new Object[0]);
        });
        return (T)((Annotation)type.cast(o));
    }

    public static <T extends Annotation> T annotation(Class<T> type, Function<String, Object> function) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Object o = Proxy.newProxyInstance(cl, (Class[])List.of(type).toArray(Class[]::new), (proxy, method, args) -> {
            String methodName = method.getName();
            if ("annotationType".equals(methodName)) {
                return type;
            }
            Object value = function.apply(methodName);
            return value != null ? value : method.getDefaultValue();
        });
        return (T)((Annotation)type.cast(o));
    }
}

