/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing;

import io.helidon.common.testing.virtualthreads.PinningRecorder;
import io.helidon.microprofile.testing.AddExtension;
import io.helidon.microprofile.testing.HelidonTestExtension;
import io.helidon.microprofile.testing.HelidonTestInfo;
import io.helidon.microprofile.testing.HelidonTestScope;
import io.helidon.microprofile.testing.PrettyPrinter;
import io.helidon.microprofile.testing.PrettyPrinters;
import io.helidon.microprofile.testing.ReflectionHelper;
import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.se.SeContainerInitializer;
import jakarta.enterprise.inject.spi.Extension;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;

public class HelidonTestContainer {
    private static final System.Logger LOGGER = System.getLogger(HelidonTestContainer.class.getName());
    private static final AtomicInteger NEXT_ID = new AtomicInteger(1);
    private final HelidonTestInfo<?> testInfo;
    private final HelidonTestScope testScope;
    private final BiFunction<HelidonTestInfo<?>, HelidonTestScope, HelidonTestExtension> extensionFactory;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ReentrantLock lock = new ReentrantLock();
    private final int id = NEXT_ID.getAndIncrement();
    private SeContainer container;
    private PinningRecorder pinningRecorder;
    private RuntimeException error;

    public HelidonTestContainer(HelidonTestInfo<?> testInfo, HelidonTestScope testScope, BiFunction<HelidonTestInfo<?>, HelidonTestScope, HelidonTestExtension> extensionFactory) {
        this.testInfo = testInfo;
        this.testScope = testScope;
        this.extensionFactory = extensionFactory;
    }

    public void close() {
        if (this.container != null && this.closed.compareAndSet(false, true)) {
            LOGGER.log(System.Logger.Level.DEBUG, "closing container id={0}", this.id);
            this.container.close();
            if (this.pinningRecorder != null) {
                this.pinningRecorder.close();
            }
        }
    }

    public boolean closed() {
        return this.closed.get();
    }

    public boolean initFailed() {
        return this.error != null;
    }

    public <T> T resolveInstance(Class<T> type) throws InitializationFailed {
        if (type.isAssignableFrom(SeContainer.class)) {
            return type.cast(this.container());
        }
        return (T)this.container().select(type, new Annotation[0]).get();
    }

    public boolean isSupported(Class<?> type) throws InitializationFailed {
        if (type.isAssignableFrom(SeContainer.class)) {
            return true;
        }
        return !this.container().select(type, new Annotation[0]).isUnsatisfied();
    }

    private SeContainer container() {
        if (this.error == null && this.container == null) {
            try {
                this.lock.lock();
                if (this.error == null && this.container == null) {
                    this.start();
                }
            }
            catch (RuntimeException ex) {
                this.error = ex;
                throw ex;
            }
            finally {
                this.lock.unlock();
            }
        }
        if (this.error != null) {
            throw new InitializationFailed(this.error);
        }
        return this.container;
    }

    private void start() {
        LOGGER.log(System.Logger.Level.DEBUG, "starting container\n{0}", this);
        if (this.testInfo.pinningDetection()) {
            this.pinningRecorder = PinningRecorder.create();
            this.pinningRecorder.record(Duration.ofMillis(this.testInfo.pinningThreshold()));
        }
        HelidonTestExtension testExtension = this.extensionFactory.apply(this.testInfo, this.testScope);
        SeContainerInitializer initializer = SeContainerInitializer.newInstance();
        if (this.testInfo.disableDiscovery()) {
            initializer.disableDiscovery();
        }
        for (AddExtension extension : this.testInfo.addExtensions()) {
            initializer.addExtensions(new Class[]{ReflectionHelper.requirePublic(extension.value())});
        }
        initializer.addExtensions(new Extension[]{testExtension});
        this.container = initializer.initialize();
    }

    public String toString() {
        return new PrettyPrinter().object(printer -> printer.value("id", this.id).object("testInfo", PrettyPrinters.testInfo(this.testInfo))).toString();
    }

    public static final class InitializationFailed
    extends RuntimeException {
        private InitializationFailed(RuntimeException error) {
            super("Container initialization previously failed", error);
        }
    }
}

