/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

final class PrettyPrinter {
    private final StringBuilder sb = new StringBuilder();
    private int i = 0;
    static final Consumer<PrettyPrinter> EMPTY = printer -> {};

    PrettyPrinter() {
    }

    PrettyPrinter name(String name) {
        if (name != null && !name.isEmpty()) {
            this.value(name).append(" = ");
        }
        return this;
    }

    PrettyPrinter value(Object value) {
        return this.append(Character.valueOf('\n')).indent().append(value);
    }

    PrettyPrinter value(String key, Object value) {
        return this.name(key).append(value);
    }

    PrettyPrinter block(String key, String block) {
        this.name(key).append("<<");
        block.lines().forEach(this::value);
        this.value(">>");
        return this;
    }

    PrettyPrinter object(Consumer<PrettyPrinter> action) {
        this.append(Character.valueOf('{')).indent(() -> action.accept(this)).append(Character.valueOf('\n')).indent().append(Character.valueOf('}'));
        return this;
    }

    PrettyPrinter object(String name, Consumer<PrettyPrinter> action) {
        if (action != EMPTY) {
            this.name(name).object(action);
        }
        return this;
    }

    <T> PrettyPrinter objects(String name, List<T> list, Function<T, Consumer<PrettyPrinter>> function) {
        if (list != null) {
            list.forEach(e -> this.object(name, (Consumer)function.apply(e)));
        }
        return this;
    }

    <T> PrettyPrinter values(String name, List<T> list, Function<T, ?> mapper) {
        if (list != null && !list.isEmpty()) {
            this.name(name).append(Character.valueOf('[')).indent(() -> list.forEach(e -> this.value(mapper.apply(e)))).append(Character.valueOf('\n')).indent().append(Character.valueOf(']'));
        }
        return this;
    }

    @SafeVarargs
    final <T> PrettyPrinter values(String name, T ... values) {
        return this.values(name, Arrays.asList(values), e -> e);
    }

    PrettyPrinter apply(Consumer<PrettyPrinter> action) {
        action.accept(this);
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }

    private PrettyPrinter append(Object object) {
        this.sb.append(object);
        return this;
    }

    private PrettyPrinter indent() {
        this.sb.append("  ".repeat(this.i));
        return this;
    }

    private PrettyPrinter indent(Runnable action) {
        try {
            ++this.i;
            action.run();
            PrettyPrinter prettyPrinter = this;
            return prettyPrinter;
        }
        finally {
            --this.i;
        }
    }
}

