/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing;

import io.helidon.config.mp.MpConfigSources;
import io.helidon.microprofile.testing.AddConfig;
import io.helidon.microprofile.testing.AddConfigBlock;
import io.helidon.microprofile.testing.Configuration;
import io.helidon.microprofile.testing.HelidonTestConfigDelegate;
import io.helidon.microprofile.testing.HelidonTestInfo;
import io.helidon.microprofile.testing.ReflectionHelper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;

class HelidonTestConfigSynthetic
extends HelidonTestConfigDelegate {
    private final Map<String, String> map = new HashMap<String, String>();
    private final Map<String, Set<String>> blocks = new HashMap<String, Set<String>>();
    private final Set<Method> methods = new HashSet<Method>();
    private final Set<String> resources = new HashSet<String>();
    private final HelidonTestInfo<?> testInfo;
    private final ReentrantLock lock = new ReentrantLock();
    private final Runnable onUpdate;
    private boolean useExisting;
    private Config config;

    HelidonTestConfigSynthetic(HelidonTestInfo<?> testInfo, Runnable onUpdate) {
        this.testInfo = testInfo;
        this.onUpdate = onUpdate;
        this.map.put("config_ordinal", "1000");
        this.map.put("server.port", "0");
        this.map.put("mp.config.profile", "test");
        testInfo.addConfigs().forEach(xva$0 -> this.update((AddConfig)xva$0));
        testInfo.addConfigBlocks().forEach(xva$0 -> this.update((AddConfigBlock)xva$0));
        testInfo.addConfigSources().forEach(this::update);
        testInfo.configuration().ifPresent(this::update);
    }

    @Override
    Config delegate() {
        if (this.config == null) {
            try {
                this.lock.lock();
                if (this.config == null) {
                    this.config = this.buildConfig();
                    this.onUpdate.run();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.config;
    }

    void update(Configuration annotation) {
        this.map.put("mp.config.profile", annotation.profile());
        this.useExisting = annotation.useExisting();
        List<String> sources = List.of(annotation.configSources());
        if (!this.resources.containsAll(sources)) {
            this.resources.addAll(sources);
            this.config = null;
        }
    }

    void update(AddConfig ... annotations) {
        for (AddConfig annotation : annotations) {
            this.map.put(annotation.key(), annotation.value());
        }
    }

    void update(AddConfigBlock ... annotations) {
        for (AddConfigBlock annotation : annotations) {
            if (!this.blocks.computeIfAbsent(annotation.type(), t -> new HashSet()).add(annotation.value())) continue;
            this.config = null;
        }
    }

    void update(Method method) {
        if (this.methods.add(ReflectionHelper.requireStatic(method))) {
            this.config = null;
        }
    }

    boolean useExisting() {
        return this.useExisting;
    }

    private Config buildConfig() {
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        configSources.add(MpConfigSources.create((String)this.testInfo.id(), this.map));
        this.blocks.forEach((type, values) -> {
            for (String value : values) {
                ConfigSource config = MpConfigSources.create((String)type, (Reader)new StringReader(value));
                configSources.add(this.addConfigOrdinal(config, (String)type, "900"));
            }
        });
        for (Method m : this.methods) {
            ConfigSource config = ReflectionHelper.invoke(ConfigSource.class, ReflectionHelper.requireStatic(m), null, new Object[0]);
            configSources.add(new ConfigSourceWrapper(config));
        }
        for (String source : this.resources) {
            String filename = source.trim();
            for (URL url : HelidonTestConfigSynthetic.resources(filename)) {
                String type2 = HelidonTestConfigSynthetic.extension(filename);
                ConfigSource config = MpConfigSources.create((String)type2, (URL)url);
                configSources.add(this.addConfigOrdinal(config, type2, "700"));
            }
        }
        ConfigBuilder builder = ConfigProviderResolver.instance().getBuilder().addDefaultSources().addDiscoveredSources().addDiscoveredConverters();
        configSources.forEach(xva$0 -> builder.withSources(new ConfigSource[]{xva$0}));
        return builder.build();
    }

    private ConfigSource addConfigOrdinal(ConfigSource config, String type, String ordinal) {
        HashMap<String, String> properties = new HashMap<String, String>(config.getProperties());
        properties.putIfAbsent("config_ordinal", ordinal);
        return MpConfigSources.create((String)type, properties);
    }

    private static String extension(String filename) {
        int idx = filename.lastIndexOf(46);
        return idx > -1 ? filename.substring(idx + 1) : "properties";
    }

    private static Collection<URL> resources(String name) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            HashMap urls = new HashMap();
            cl.getResources(name).asIterator().forEachRemaining(u -> urls.put(u.toString(), u));
            return urls.values();
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to read '%s' from classpath", name), e);
        }
    }

    private record ConfigSourceWrapper(ConfigSource delegate) implements ConfigSource
    {
        public Set<String> getPropertyNames() {
            return this.delegate.getPropertyNames();
        }

        public String getValue(String propertyName) {
            return this.delegate.getValue(propertyName);
        }

        public String getName() {
            return this.delegate.getName();
        }

        public Map<String, String> getProperties() {
            return this.delegate.getProperties();
        }

        public int getOrdinal() {
            boolean isDefault = ReflectionHelper.isDefaultMethod(this.delegate, "getOrdinal");
            boolean isDefaultOrdinal = this.delegate.getOrdinal() == 100;
            return isDefault && isDefaultOrdinal ? 800 : this.delegate.getOrdinal();
        }
    }
}

