/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing;

import io.helidon.microprofile.testing.AddConfig;
import io.helidon.microprofile.testing.AddConfigBlock;
import io.helidon.microprofile.testing.Configuration;
import io.helidon.microprofile.testing.HelidonTestDescriptor;
import io.helidon.microprofile.testing.HelidonTestInfo;
import io.helidon.microprofile.testing.PrettyPrinter;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;

class PrettyPrinters {
    private PrettyPrinters() {
    }

    static Consumer<PrettyPrinter> testInfo(HelidonTestInfo<?> info) {
        HelidonTestInfo<?> helidonTestInfo = info;
        Objects.requireNonNull(helidonTestInfo);
        HelidonTestInfo<?> helidonTestInfo2 = helidonTestInfo;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HelidonTestInfo.ClassInfo.class, HelidonTestInfo.MethodInfo.class}, helidonTestInfo2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                HelidonTestInfo.ClassInfo classInfo = (HelidonTestInfo.ClassInfo)helidonTestInfo2;
                yield PrettyPrinters.classInfo(classInfo);
            }
            case 1 -> {
                HelidonTestInfo.MethodInfo methodInfo = (HelidonTestInfo.MethodInfo)helidonTestInfo2;
                yield PrettyPrinters.methodInfo(methodInfo);
            }
        };
    }

    static Consumer<PrettyPrinter> methodInfo(HelidonTestInfo.MethodInfo info) {
        return printer -> printer.value("class", ((Class)info.classInfo().element()).getName()).value("method", info.element().getName()).value("requiresReset", info.requiresReset()).apply(PrettyPrinters.testDescriptor(info));
    }

    static Consumer<PrettyPrinter> classInfo(HelidonTestInfo.ClassInfo info) {
        return printer -> printer.value("class", ((Class)info.element()).getName()).apply(PrettyPrinters.testDescriptor(info));
    }

    static Consumer<PrettyPrinter> testDescriptor(HelidonTestDescriptor<?> desc) {
        return printer -> printer.value("resetPerTest", desc.resetPerTest()).value("pinningDetection", desc.pinningDetection()).value("pinningThreshold", desc.pinningThreshold()).value("disableDiscovery", desc.disableDiscovery()).values("addExtensions", desc.addExtensions(), a -> a.value().getName()).values("addBeans", desc.addBeans(), a -> a.value().getName()).object("configuration", desc.configuration().map(PrettyPrinters::configuration).orElse(PrettyPrinter.EMPTY)).objects("addConfig", desc.addConfigs(), PrettyPrinters::addConfig).objects("addConfigBlock", desc.addConfigBlocks(), PrettyPrinters::addConfigBlock);
    }

    static Consumer<PrettyPrinter> configuration(Configuration a) {
        return printer -> printer.object("configuration", p -> p.value("useExisting", a.useExisting()).value("profile", a.profile()).values("configSources", a.configSources()));
    }

    static Consumer<PrettyPrinter> addConfig(AddConfig a) {
        return printer -> printer.value("key", a.key()).value("value", a.value());
    }

    static Consumer<PrettyPrinter> addConfigBlock(AddConfigBlock a) {
        return printer -> printer.value("type", a.type()).block("value", a.value());
    }
}

