/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing.junit5;

import io.helidon.microprofile.testing.HelidonTestInfo;
import io.helidon.microprofile.testing.junit5.HelidonTestDescriptorImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.junit.jupiter.api.MethodDescriptor;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.MethodOrdererContext;

public class HelidonImplicitResetOrderer
implements MethodOrderer {
    public void orderMethods(MethodOrdererContext context) {
        HelidonImplicitResetOrderer.sort(context.getMethodDescriptors());
    }

    private static <T extends MethodDescriptor> void sort(List<T> descriptors) {
        ArrayList<MethodDescriptor> shared = new ArrayList<MethodDescriptor>();
        ArrayList<MethodDescriptor> exclusive = new ArrayList<MethodDescriptor>();
        for (MethodDescriptor e : descriptors) {
            Method method = e.getMethod();
            HelidonTestInfo.ClassInfo classInfo = HelidonTestInfo.classInfo(method.getDeclaringClass(), HelidonTestDescriptorImpl::new);
            HelidonTestInfo.MethodInfo methodInfo = HelidonTestInfo.methodInfo((Method)method, (HelidonTestInfo.ClassInfo)classInfo, HelidonTestDescriptorImpl::new);
            if (!classInfo.resetPerTest() && methodInfo.requiresReset()) {
                exclusive.add(e);
                continue;
            }
            shared.add(e);
        }
        if (!exclusive.isEmpty()) {
            ListIterator<T> i = descriptors.listIterator();
            for (MethodDescriptor e : shared) {
                i.next();
                i.set(e);
            }
            for (MethodDescriptor e : exclusive) {
                i.next();
                i.set(e);
            }
        }
    }
}

