/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.server;

import io.helidon.common.configurable.ServerThreadPoolSupplier;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.config.Config;
import io.helidon.config.mp.MpConfig;
import io.helidon.config.mp.MpConfigSources;
import io.helidon.microprofile.cdi.HelidonContainer;
import io.helidon.microprofile.server.JaxRsApplication;
import io.helidon.microprofile.server.JaxRsCdiExtension;
import io.helidon.microprofile.server.MpException;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.microprofile.server.ServerImpl;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.enterprise.inject.se.SeContainer;
import javax.enterprise.inject.spi.CDI;
import javax.ws.rs.core.Application;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.glassfish.jersey.server.ResourceConfig;

public interface Server {
    @SafeVarargs
    public static Server create(Application ... applications) throws MpException {
        Builder builder = Server.builder();
        Arrays.stream(applications).forEach(builder::addApplication);
        return builder.build();
    }

    @SafeVarargs
    public static Server create(Class<? extends Application> ... applicationClasses) throws MpException {
        Builder builder = Server.builder();
        Arrays.stream(applicationClasses).forEach(builder::addApplication);
        return builder.build();
    }

    public static Server create() throws MpException {
        return Server.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Server start() throws MpException;

    public Server stop() throws MpException;

    public String host();

    public int port();

    public static final class Builder {
        private static final Logger STARTUP_LOGGER = Logger.getLogger("io.helidon.microprofile.startup.builder");
        private final List<Class<?>> resourceClasses = new LinkedList();
        private final List<JaxRsApplication> applications = new LinkedList<JaxRsApplication>();
        private org.eclipse.microprofile.config.Config config;
        private String host;
        private String basePath;
        private int port = -1;
        private Supplier<? extends ExecutorService> defaultExecutorService;
        private JaxRsCdiExtension jaxRs;
        private boolean retainDiscovered = false;

        private Builder() {
            ServerCdiExtension server = null;
            try {
                server = (ServerCdiExtension)CDI.current().getBeanManager().getExtension(ServerCdiExtension.class);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (null != server && server.started()) {
                throw new IllegalStateException("Server is already started. Maybe you have initialized CDI yourself? If you do so, then you cannot use Server.builder() to set up your server. Config is initialized with defaults or using meta-config.yaml; applications are discovered using CDI. To use custom configuration, you can use ConfigProviderResolver.instance().registerConfig(config, classLoader);");
            }
        }

        public Server build() {
            STARTUP_LOGGER.entering(Builder.class.getName(), "build");
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (null == this.config) {
                this.config = ConfigProviderResolver.instance().getConfig(classLoader);
            }
            ConfigProviderResolver.instance().registerConfig(this.config, classLoader);
            HelidonContainer instance = HelidonContainer.instance();
            try {
                return (Server)Contexts.runInContext((Context)instance.context(), this::doBuild);
            }
            catch (Exception e) {
                try {
                    ((SeContainer)CDI.current()).close();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                throw e;
            }
        }

        private Server doBuild() {
            ServerCdiExtension server = (ServerCdiExtension)CDI.current().getBeanManager().getExtension(ServerCdiExtension.class);
            if (null == this.defaultExecutorService) {
                this.defaultExecutorService = ServerThreadPoolSupplier.builder().name("server").config(MpConfig.toHelidonConfig((org.eclipse.microprofile.config.Config)this.config).get("server.executor-service")).build();
            }
            server.defaultExecutorService(this.defaultExecutorService);
            if (null != this.basePath) {
                server.basePath(this.basePath);
            }
            STARTUP_LOGGER.finest("Configuration obtained");
            this.jaxRs = (JaxRsCdiExtension)CDI.current().getBeanManager().getExtension(JaxRsCdiExtension.class);
            if (!(this.applications.isEmpty() && this.resourceClasses.isEmpty() || this.retainDiscovered)) {
                this.jaxRs.removeApplications();
            }
            if (!this.resourceClasses.isEmpty()) {
                this.jaxRs.removeResourceClasses();
                this.jaxRs.addResourceClasses(this.resourceClasses);
            }
            this.jaxRs.addApplications(this.applications);
            if (!this.resourceClasses.isEmpty()) {
                this.jaxRs.addSyntheticApplication(this.resourceClasses);
            }
            STARTUP_LOGGER.finest("Jersey resource configuration");
            if (null == this.host) {
                this.host = this.config.getOptionalValue("server.host", String.class).orElse("0.0.0.0");
            }
            if (this.port == -1) {
                this.port = this.config.getOptionalValue("server.port", Integer.class).orElse(7001);
            }
            return new ServerImpl(this);
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder defaultExecutorServiceSupplier(Supplier<? extends ExecutorService> supplier) {
            this.defaultExecutorService = supplier;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder config(Config config) {
            this.config = ConfigProviderResolver.instance().getBuilder().withSources(new ConfigSource[]{MpConfigSources.create((Config)Objects.requireNonNull(config, "Config cannot be null"))}).build();
            return this;
        }

        public Builder config(org.eclipse.microprofile.config.Config config) {
            this.config = config;
            return this;
        }

        public Builder resourceConfig(ResourceConfig config) {
            Application application = config.getApplication();
            JaxRsApplication.Builder builder = JaxRsApplication.builder().appName(config.getApplicationName()).config(config);
            if (null != application) {
                builder.applicationClass(application.getClass());
            }
            this.applications.add(builder.build());
            return this;
        }

        public Builder addApplication(JaxRsApplication application) {
            this.applications.add(application);
            return this;
        }

        public Builder addApplication(Application application) {
            this.applications.add(JaxRsApplication.create(application));
            return this;
        }

        public Builder retainDiscoveredApplications(boolean retain) {
            this.retainDiscovered = retain;
            return this;
        }

        public Builder applications(Application ... applications) {
            this.applications.clear();
            for (Application application : applications) {
                this.addApplication(application);
            }
            return this;
        }

        public Builder addApplication(String contextRoot, Application application) {
            this.applications.add(JaxRsApplication.builder().application(application).contextRoot(contextRoot).build());
            return this;
        }

        public Builder addApplication(Class<? extends Application> applicationClass) {
            this.applications.add(JaxRsApplication.create(applicationClass));
            return this;
        }

        public Builder addApplication(String contextRoot, Class<? extends Application> applicationClass) {
            this.applications.add(JaxRsApplication.builder().application(applicationClass).contextRoot(contextRoot).build());
            return this;
        }

        public Builder addResourceClass(Class<?> resource) {
            this.resourceClasses.add(resource);
            return this;
        }

        String host() {
            return this.host;
        }

        int port() {
            return this.port;
        }
    }
}

